/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.citizensnpcs.nms.v1_20_R4.util.EntityNodeEvaluatorBase;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final PathPoint[] reusableNeighbors = new PathPoint[EnumDirection.EnumDirectionLimit.a.b()];
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(PathPoint pathPoint) {
        AxisAlignedBB axisAlignedBB = this.mob.cK();
        Vec3D vec3D = new Vec3D((double)pathPoint.a - this.mob.du() + axisAlignedBB.b() / 2.0, (double)pathPoint.b - this.mob.dw() + axisAlignedBB.c() / 2.0, (double)pathPoint.c - this.mob.dA() + axisAlignedBB.d() / 2.0);
        int n = MathHelper.c((double)(vec3D.f() / axisAlignedBB.a()));
        vec3D = vec3D.a((double)(1.0f / (float)n));
        for (int i = 1; i <= n; ++i) {
            if (!this.hasCollisions(axisAlignedBB = axisAlignedBB.c(vec3D))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(BlockPosition blockPosition) {
        PathType pathType = this.getCachedPathType(blockPosition.u(), blockPosition.v(), blockPosition.w());
        return pathType != PathType.b && this.mvmt.getPathfindingMalus(pathType) >= 0.0f;
    }

    @Override
    public void b() {
        this.mvmt.setPathfindingMalus(PathType.j, this.oldWaterCost);
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.b();
    }

    protected PathPoint findAcceptedNode(int n, int n2, int n3, int n4, double d, EnumDirection enumDirection, PathType pathType) {
        PathPoint pathPoint = null;
        BlockPosition.MutableBlockPosition mutableBlockPosition = new BlockPosition.MutableBlockPosition();
        double d2 = this.getFloorLevel((BlockPosition)mutableBlockPosition.d(n, n2, n3));
        if (d2 - d > this.getMobJumpHeight()) {
            return null;
        }
        PathType pathType2 = this.getCachedPathType(n, n2, n3);
        float f = this.mvmt.getPathfindingMalus(pathType2);
        if (f >= 0.0f) {
            pathPoint = this.getNodeAndUpdateCostToMax(n, n2, n3, pathType2, f);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(pathType) && pathPoint != null && pathPoint.k >= 0.0f && !this.canReachWithoutCollision(pathPoint)) {
            pathPoint = null;
        }
        if (!(pathType2 == PathType.c || this.isAmphibious() && pathType2 == PathType.j)) {
            if ((pathPoint == null || pathPoint.k < 0.0f) && n4 > 0 && (pathType2 != PathType.h || this.g()) && pathType2 != PathType.m && pathType2 != PathType.e && pathType2 != PathType.f) {
                pathPoint = this.tryJumpOn(n, n2, n3, n4, d, enumDirection, pathType, mutableBlockPosition);
            } else if (!this.isAmphibious() && pathType2 == PathType.j && !this.f()) {
                pathPoint = this.tryFindFirstNonWaterBelow(n, n2, n3, pathPoint);
            } else if (pathType2 == PathType.b) {
                pathPoint = this.tryFindFirstGroundNodeBelow(n, n2, n3);
            } else if (EntityNodeEvaluator.doesBlockHavePartialCollision(pathType2) && pathPoint == null) {
                pathPoint = this.getClosedNode(n, n2, n3, pathType2);
            }
            return pathPoint;
        }
        return pathPoint;
    }

    private PathPoint getBlockedNode(int n, int n2, int n3) {
        PathPoint pathPoint = this.c(n, n2, n3);
        pathPoint.l = PathType.a;
        pathPoint.k = -1.0f;
        return pathPoint;
    }

    protected PathType getCachedPathType(int n, int n2, int n3) {
        return (PathType)this.pathTypesByPosCacheByMob.computeIfAbsent(BlockPosition.a((int)n, (int)n2, (int)n3), l -> this.getPathTypeOfMob(this.a, n, n2, n3, this.mob));
    }

    private PathPoint getClosedNode(int n, int n2, int n3, PathType pathType) {
        PathPoint pathPoint = this.c(n, n2, n3);
        pathPoint.i = true;
        pathPoint.l = pathType;
        pathPoint.k = pathType.a();
        return pathPoint;
    }

    protected double getFloorLevel(BlockPosition blockPosition) {
        ICollisionAccess iCollisionAccess = this.a.a();
        return (this.f() || this.isAmphibious()) && iCollisionAccess.b_(blockPosition).a(TagsFluid.a) ? (double)blockPosition.v() + 0.5 : EntityNodeEvaluator.getFloorLevel((IBlockAccess)iCollisionAccess, blockPosition);
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dJ());
    }

    public int a(PathPoint[] pathPointArray, PathPoint pathPoint) {
        EnumDirection enumDirection;
        int n = 0;
        int n2 = 0;
        PathType pathType = this.getCachedPathType(pathPoint.a, pathPoint.b + 1, pathPoint.c);
        PathType pathType2 = this.getCachedPathType(pathPoint.a, pathPoint.b, pathPoint.c);
        if (this.mvmt.getPathfindingMalus(pathType) >= 0.0f && pathType2 != PathType.w) {
            n2 = MathHelper.d((float)Math.max(1.0f, this.mob.dJ()));
        }
        double d = this.getFloorLevel(new BlockPosition(pathPoint.a, pathPoint.b, pathPoint.c));
        for (EnumDirection enumDirection2 : EnumDirection.EnumDirectionLimit.a) {
            enumDirection = this.findAcceptedNode(pathPoint.a + enumDirection2.j(), pathPoint.b, pathPoint.c + enumDirection2.l(), n2, d, enumDirection2, pathType2);
            this.reusableNeighbors[enumDirection2.e()] = enumDirection;
            if (!this.isNeighborValid((PathPoint)enumDirection, pathPoint)) continue;
            pathPointArray[n++] = enumDirection;
        }
        for (EnumDirection enumDirection2 : EnumDirection.EnumDirectionLimit.a) {
            PathPoint pathPoint2;
            enumDirection = enumDirection2.h();
            if (!this.isDiagonalValid(pathPoint, this.reusableNeighbors[enumDirection2.e()], this.reusableNeighbors[enumDirection.e()]) || !this.isDiagonalValid(pathPoint2 = this.findAcceptedNode(pathPoint.a + enumDirection2.j() + enumDirection.j(), pathPoint.b, pathPoint.c + enumDirection2.l() + enumDirection.l(), n2, d, enumDirection2, pathType2))) continue;
            pathPointArray[n++] = pathPoint2;
        }
        return n;
    }

    private PathPoint getNodeAndUpdateCostToMax(int n, int n2, int n3, PathType pathType, float f) {
        PathPoint pathPoint = this.c(n, n2, n3);
        pathPoint.l = pathType;
        pathPoint.k = Math.max(pathPoint.k, f);
        return pathPoint;
    }

    public PathType a(PathfindingContext pathfindingContext, int n, int n2, int n3) {
        return EntityNodeEvaluator.getPathTypeStatic(pathfindingContext, new BlockPosition.MutableBlockPosition(n, n2, n3));
    }

    public PathType getPathTypeOfMob(PathfindingContext pathfindingContext, int n, int n2, int n3, EntityLiving entityLiving) {
        Set set = this.getPathTypeWithinMobBB(pathfindingContext, n, n2, n3);
        if (set.contains(PathType.h)) {
            return PathType.h;
        }
        if (set.contains(PathType.m)) {
            return PathType.m;
        }
        PathType pathType = PathType.a;
        for (PathType pathType2 : set) {
            if (this.mvmt.getPathfindingMalus(pathType2) < 0.0f) {
                return pathType2;
            }
            if (!(this.mvmt.getPathfindingMalus(pathType2) >= this.mvmt.getPathfindingMalus(pathType))) continue;
            pathType = pathType2;
        }
        if (this.d <= 1 && pathType != PathType.b && this.mvmt.getPathfindingMalus(pathType) == 0.0f && this.a(pathfindingContext, n, n2, n3) == PathType.b) {
            return PathType.b;
        }
        return pathType;
    }

    public PathType a(PathfindingContext pathfindingContext, int n, int n2, int n3, EntityInsentient entityInsentient) {
        Set set = this.getPathTypeWithinMobBB(pathfindingContext, n, n2, n3);
        if (set.contains(PathType.h)) {
            return PathType.h;
        }
        if (set.contains(PathType.m)) {
            return PathType.m;
        }
        PathType pathType = PathType.a;
        for (PathType pathType2 : set) {
            if (entityInsentient.a(pathType2) < 0.0f) {
                return pathType2;
            }
            if (!(entityInsentient.a(pathType2) >= entityInsentient.a(pathType))) continue;
            pathType = pathType2;
        }
        if (this.d <= 1 && pathType != PathType.b && entityInsentient.a(pathType) == 0.0f && this.a(pathfindingContext, n, n2, n3) == PathType.b) {
            return PathType.b;
        }
        return pathType;
    }

    public Set getPathTypeWithinMobBB(PathfindingContext pathfindingContext, int n, int n2, int n3) {
        EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.e; ++j) {
                for (int k = 0; k < this.f; ++k) {
                    int n4 = i + n;
                    int n5 = j + n2;
                    int n6 = k + n3;
                    PathType pathType = this.a(pathfindingContext, n4, n5, n6);
                    BlockPosition blockPosition = this.mob.dp();
                    boolean bl = this.d();
                    if (pathType == PathType.s && this.e() && bl) {
                        pathType = PathType.d;
                    }
                    if (pathType == PathType.r && !bl) {
                        pathType = PathType.a;
                    }
                    if (pathType == PathType.l && this.a(pathfindingContext, blockPosition.u(), blockPosition.v(), blockPosition.w()) != PathType.l && this.a(pathfindingContext, blockPosition.u(), blockPosition.v() - 1, blockPosition.w()) != PathType.l) {
                        pathType = PathType.m;
                    }
                    enumSet.add(pathType);
                }
            }
        }
        return enumSet;
    }

    public PathPoint a() {
        BlockPosition blockPosition;
        int n;
        BlockPosition.MutableBlockPosition mutableBlockPosition;
        block12: {
            mutableBlockPosition = new BlockPosition.MutableBlockPosition();
            n = this.mob.dv();
            IBlockData iBlockData = this.a.a((BlockPosition)mutableBlockPosition.b(this.mob.du(), (double)n, this.mob.dA()));
            if (!this.mob.a(iBlockData.u())) {
                if (this.f() && this.mob.be()) {
                    while (true) {
                        if (!iBlockData.a(Blocks.G) && iBlockData.u() != FluidTypes.c.a(false)) {
                            --n;
                            break block12;
                        }
                        iBlockData = this.a.a((BlockPosition)mutableBlockPosition.b(this.mob.du(), (double)(++n), this.mob.dA()));
                    }
                }
                if (this.mob.aE()) {
                    n = MathHelper.a((double)(this.mob.dw() + 0.5));
                } else {
                    mutableBlockPosition.b(this.mob.du(), this.mob.dw() + 1.0, this.mob.dA());
                    while (mutableBlockPosition.v() > this.a.a().I_()) {
                        n = mutableBlockPosition.v();
                        mutableBlockPosition.q(mutableBlockPosition.v() - 1);
                        blockPosition = this.a.a((BlockPosition)mutableBlockPosition);
                        if (blockPosition.i() || blockPosition.a(PathMode.a)) continue;
                        break;
                    }
                }
            } else {
                while (true) {
                    if (!this.mob.a(iBlockData.u())) {
                        --n;
                        break;
                    }
                    iBlockData = this.a.a((BlockPosition)mutableBlockPosition.b(this.mob.du(), (double)(++n), this.mob.dA()));
                }
            }
        }
        blockPosition = this.mob.dp();
        if (!this.canStartAt((BlockPosition)mutableBlockPosition.d(blockPosition.u(), n, blockPosition.w()))) {
            AxisAlignedBB axisAlignedBB = this.mob.cK();
            if (this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.a, (double)n, axisAlignedBB.c)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.a, (double)n, axisAlignedBB.f)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.d, (double)n, axisAlignedBB.c)) || this.canStartAt((BlockPosition)mutableBlockPosition.b(axisAlignedBB.d, (double)n, axisAlignedBB.f))) {
                return this.getStartNode((BlockPosition)mutableBlockPosition);
            }
        }
        return this.getStartNode(new BlockPosition(blockPosition.u(), n, blockPosition.w()));
    }

    protected PathPoint getStartNode(BlockPosition blockPosition) {
        PathPoint pathPoint = this.b(blockPosition);
        pathPoint.l = this.getCachedPathType(pathPoint.a, pathPoint.b, pathPoint.c);
        pathPoint.k = this.mvmt.getPathfindingMalus(pathPoint.l);
        return pathPoint;
    }

    public PathDestination a(double d, double d2, double d3) {
        return this.b(d, d2, d3);
    }

    private boolean hasCollisions(AxisAlignedBB axisAlignedBB) {
        return this.collisionCache.computeIfAbsent((Object)axisAlignedBB, object -> !this.a.a().a((Entity)this.mob, axisAlignedBB));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(PathPoint pathPoint) {
        if (pathPoint != null && !pathPoint.i) {
            if (pathPoint.l == PathType.d) {
                return false;
            }
            return pathPoint.k >= 0.0f;
        }
        return false;
    }

    protected boolean isDiagonalValid(PathPoint pathPoint, PathPoint pathPoint2, PathPoint pathPoint3) {
        if (pathPoint3 != null && pathPoint2 != null && pathPoint3.b <= pathPoint.b && pathPoint2.b <= pathPoint.b) {
            if (pathPoint2.l != PathType.d && pathPoint3.l != PathType.d) {
                boolean bl = pathPoint3.l == PathType.h && pathPoint2.l == PathType.h && (double)this.mob.dj() < 0.5;
                return (pathPoint3.b < pathPoint.b || pathPoint3.k >= 0.0f || bl) && (pathPoint2.b < pathPoint.b || pathPoint2.k >= 0.0f || bl);
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(PathPoint pathPoint, PathPoint pathPoint2) {
        return pathPoint != null && !pathPoint.i && (pathPoint.k >= 0.0f || pathPoint2.k < 0.0f);
    }

    @Override
    public void prepare(ChunkCache chunkCache, EntityLiving entityLiving) {
        super.prepare(chunkCache, entityLiving);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(PathType.j);
    }

    @Override
    public void a(ChunkCache chunkCache, EntityInsentient entityInsentient) {
        super.a(chunkCache, entityInsentient);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(PathType.j);
    }

    private PathPoint tryFindFirstGroundNodeBelow(int n, int n2, int n3) {
        for (int i = n2 - 1; i >= this.mob.dP().I_(); --i) {
            if (n2 - i > this.mob.cx()) {
                return this.getBlockedNode(n, i, n3);
            }
            PathType pathType = this.getCachedPathType(n, i, n3);
            float f = this.mvmt.getPathfindingMalus(pathType);
            if (pathType == PathType.b) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(n, i, n3, pathType, f);
            }
            return this.getBlockedNode(n, i, n3);
        }
        return this.getBlockedNode(n, n2, n3);
    }

    private PathPoint tryFindFirstNonWaterBelow(int n, int n2, int n3, PathPoint pathPoint) {
        --n2;
        while (n2 > this.mob.dP().I_()) {
            PathType pathType = this.getCachedPathType(n, n2, n3);
            if (pathType != PathType.j) {
                return pathPoint;
            }
            pathPoint = this.getNodeAndUpdateCostToMax(n, n2, n3, pathType, this.mvmt.getPathfindingMalus(pathType));
            --n2;
        }
        return pathPoint;
    }

    private PathPoint tryJumpOn(int n, int n2, int n3, int n4, double d, EnumDirection enumDirection, PathType pathType, BlockPosition.MutableBlockPosition mutableBlockPosition) {
        PathPoint pathPoint = this.findAcceptedNode(n, n2 + 1, n3, n4 - 1, d, enumDirection, pathType);
        if (pathPoint == null) {
            return null;
        }
        if (this.mob.dj() >= 1.0f) {
            return pathPoint;
        }
        if (pathPoint.l != PathType.b && pathPoint.l != PathType.c) {
            return pathPoint;
        }
        double d2 = (double)(n - enumDirection.j()) + 0.5;
        double d3 = (double)(n3 - enumDirection.l()) + 0.5;
        double d4 = (double)this.mob.dj() / 2.0;
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(d2 - d4, this.getFloorLevel((BlockPosition)mutableBlockPosition.b(d2, (double)(n2 + 1), d3)) + 0.001, d3 - d4, d2 + d4, (double)this.mob.dk() + this.getFloorLevel((BlockPosition)mutableBlockPosition.b((double)pathPoint.a, (double)pathPoint.b, (double)pathPoint.c)) - 0.002, d3 + d4);
        return this.hasCollisions(axisAlignedBB) ? null : pathPoint;
    }

    public static PathType checkNeighbourBlocks(PathfindingContext pathfindingContext, int n, int n2, int n3, PathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    PathType pathType2 = pathfindingContext.a(n + i, n2 + j, n3 + k);
                    if (pathType2 == PathType.q) {
                        return PathType.p;
                    }
                    if (pathType2 == PathType.o || pathType2 == PathType.i) {
                        return PathType.n;
                    }
                    if (pathType2 == PathType.j) {
                        return PathType.k;
                    }
                    if (pathType2 != PathType.y) continue;
                    return PathType.y;
                }
            }
        }
        return pathType;
    }

    private static boolean doesBlockHavePartialCollision(PathType pathType) {
        return pathType == PathType.h || pathType == PathType.s || pathType == PathType.t;
    }

    public static double getFloorLevel(IBlockAccess iBlockAccess, BlockPosition blockPosition) {
        BlockPosition blockPosition2 = blockPosition.d();
        VoxelShape voxelShape = iBlockAccess.a_(blockPosition2).k(iBlockAccess, blockPosition2);
        return (double)blockPosition2.v() + (voxelShape.c() ? 0.0 : voxelShape.c(EnumDirection.EnumAxis.b));
    }

    public static PathType getPathTypeStatic(PathfindingContext pathfindingContext, BlockPosition.MutableBlockPosition mutableBlockPosition) {
        int n;
        int n2;
        int n3 = mutableBlockPosition.u();
        PathType pathType = pathfindingContext.a(n3, n2 = mutableBlockPosition.v(), n = mutableBlockPosition.w());
        if (pathType == PathType.b && n2 >= pathfindingContext.a().I_() + 1) {
            PathType pathType2;
            switch (pathfindingContext.a(n3, n2 - 1, n)) {
                case b: 
                case j: 
                case i: 
                case c: {
                    pathType2 = PathType.b;
                    break;
                }
                case o: {
                    pathType2 = PathType.o;
                    break;
                }
                case q: {
                    pathType2 = PathType.q;
                    break;
                }
                case w: {
                    pathType2 = PathType.w;
                    break;
                }
                case f: {
                    pathType2 = PathType.g;
                    break;
                }
                case y: {
                    pathType2 = PathType.y;
                    break;
                }
                case e: {
                    pathType2 = PathType.z;
                    break;
                }
                default: {
                    pathType2 = EntityNodeEvaluator.checkNeighbourBlocks(pathfindingContext, n3, n2, n, PathType.c);
                }
            }
            return pathType2;
        }
        return pathType;
    }
}

