/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_20_R4.util.EntityNodeEvaluator;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class EntityPathfinder
extends Pathfinder {
    private final int maxVisitedNodes;
    private final PathPoint[] neighbors = new PathPoint[32];
    private final EntityNodeEvaluator nodeEvaluator;
    private final Path openSet = new Path();

    public EntityPathfinder(EntityNodeEvaluator entityNodeEvaluator, int n) {
        super((PathfinderAbstract)entityNodeEvaluator, n);
        this.nodeEvaluator = entityNodeEvaluator;
        this.maxVisitedNodes = n;
    }

    public PathEntity findPath(ChunkCache chunkCache, EntityLiving entityLiving, Set<BlockPosition> set, float f, int n, float f2) {
        this.openSet.a();
        this.nodeEvaluator.prepare(chunkCache, entityLiving);
        PathPoint pathPoint = this.nodeEvaluator.a();
        if (pathPoint == null) {
            return null;
        }
        Map<PathDestination, BlockPosition> map = set.stream().collect(Collectors.toMap(blockPosition -> this.nodeEvaluator.a(blockPosition.u(), blockPosition.v(), blockPosition.w()), Function.identity()));
        PathEntity pathEntity = this.findPath(chunkCache.a(), pathPoint, map, f, n, f2);
        this.nodeEvaluator.b();
        return pathEntity;
    }

    public PathEntity a(ChunkCache chunkCache, EntityInsentient entityInsentient, Set<BlockPosition> set, float f, int n, float f2) {
        this.openSet.a();
        this.nodeEvaluator.a(chunkCache, entityInsentient);
        PathPoint pathPoint = this.nodeEvaluator.a();
        if (pathPoint == null) {
            return null;
        }
        Map<PathDestination, BlockPosition> map = set.stream().collect(Collectors.toMap(blockPosition -> this.nodeEvaluator.a(blockPosition.u(), blockPosition.v(), blockPosition.w()), Function.identity()));
        PathEntity pathEntity = this.findPath(chunkCache.a(), pathPoint, map, f, n, f2);
        this.nodeEvaluator.b();
        return pathEntity;
    }

    private PathEntity findPath(GameProfilerFiller gameProfilerFiller, PathPoint pathPoint, Map<PathDestination, BlockPosition> map, float f, int n, float f2) {
        Object object;
        Set<PathDestination> set = map.keySet();
        pathPoint.e = 0.0f;
        pathPoint.g = pathPoint.f = this.getBestH(pathPoint, set);
        this.openSet.a();
        this.openSet.a(pathPoint);
        ImmutableSet immutableSet = ImmutableSet.of();
        int n2 = 0;
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)set.size());
        int n3 = (int)((float)this.maxVisitedNodes * f2);
        while (!this.openSet.e() && ++n2 < n3) {
            object = this.openSet.c();
            ((PathPoint)object).i = true;
            for (PathDestination pathDestination2 : set) {
                if (!(object.d((PathPoint)pathDestination2) <= (float)n)) continue;
                pathDestination2.e();
                hashSet.add(pathDestination2);
            }
            if (!hashSet.isEmpty()) break;
            if (object.a(pathPoint) >= f) continue;
            int n4 = this.nodeEvaluator.a(this.neighbors, (PathPoint)object);
            for (int i = 0; i < n4; ++i) {
                PathPoint pathPoint2 = this.neighbors[i];
                float f3 = this.a((PathPoint)object, pathPoint2);
                pathPoint2.j = ((PathPoint)object).j + f3;
                float f4 = ((PathPoint)object).e + f3 + pathPoint2.k;
                if (!(pathPoint2.j < f) || pathPoint2.c() && !(f4 < pathPoint2.e)) continue;
                pathPoint2.h = object;
                pathPoint2.e = f4;
                pathPoint2.f = this.getBestH(pathPoint2, set) * 1.5f;
                if (pathPoint2.c()) {
                    this.openSet.a(pathPoint2, pathPoint2.e + pathPoint2.f);
                    continue;
                }
                pathPoint2.g = pathPoint2.e + pathPoint2.f;
                this.openSet.a(pathPoint2);
            }
        }
        Optional<Object> optional = object = !hashSet.isEmpty() ? hashSet.stream().map(pathDestination -> this.reconstructPath(pathDestination.d(), (BlockPosition)map.get(pathDestination), true)).min(Comparator.comparingInt(PathEntity::e)) : this.getFallbackDestinations(map, set);
        if (((Optional)object).isEmpty()) {
            return null;
        }
        PathEntity pathEntity = (PathEntity)((Optional)object).get();
        return pathEntity;
    }

    private float getBestH(PathPoint pathPoint, Set<PathDestination> set) {
        float f = Float.MAX_VALUE;
        for (PathDestination pathDestination : set) {
            float f2 = pathPoint.a((PathPoint)pathDestination);
            pathDestination.a(f2, pathPoint);
            f = Math.min(f2, f);
        }
        return f;
    }

    public Optional<PathEntity> getFallbackDestinations(Map<PathDestination, BlockPosition> map, Set<PathDestination> set) {
        if (Settings.Setting.DISABLE_MC_NAVIGATION_FALLBACK.asBoolean()) {
            return Optional.empty();
        }
        return set.stream().map(pathDestination -> this.reconstructPath(pathDestination.d(), (BlockPosition)map.get(pathDestination), false)).min(Comparator.comparingDouble(PathEntity::m).thenComparingInt(PathEntity::e));
    }

    private PathEntity reconstructPath(PathPoint pathPoint, BlockPosition blockPosition, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        PathPoint pathPoint2 = pathPoint;
        arrayList.add(0, pathPoint);
        while (pathPoint2.h != null) {
            pathPoint2 = pathPoint2.h;
            arrayList.add(0, pathPoint2);
        }
        return new PathEntity((List)arrayList, blockPosition, bl);
    }
}

