/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public void m_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.ex()) {
                    this.v(0.0f);
                    return;
                }
                if (this.d < 0) {
                    for (int i = 0; i < this.c.length; ++i) {
                        this.c[i][0] = this.dE();
                        this.c[i][1] = this.dv();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dE();
                this.c[this.d][1] = this.dv();
                float[][] fArray = NMS.calculateDragonPositions(this.dE(), new double[][]{this.a(0, 1.0f), this.a(5, 1.0f), this.a(10, 1.0f), this.a(12, 1.0f), this.a(14, 1.0f), this.a(16, 1.0f)});
                for (int i = 0; i < this.co.length; ++i) {
                    Vec3D vec3D = new Vec3D(this.co[i].dt(), this.co[i].dv(), this.co[i].dz());
                    this.co[i].a_(this.dt() + (double)fArray[i][0], this.dv() + (double)fArray[i][1], this.dz() + (double)fArray[i][2]);
                    this.co[i].L = this.co[i].ad = vec3D.c;
                    this.co[i].M = this.co[i].ae = vec3D.d;
                    this.co[i].N = this.co[i].af = vec3D.e;
                }
                if (this.cT() != null) {
                    this.t(this.cT().getBukkitYaw() - 180.0f);
                }
                Vec3D vec3D = this.dr();
                if (vec3D.c != 0.0 || vec3D.d != 0.0 || vec3D.e != 0.0) {
                    vec3D = vec3D.d(0.98, 0.91, 0.98);
                    if (this.cT() == null) {
                        this.t(Util.getDragonYaw((Entity)this.getBukkitEntity(), vec3D.c, vec3D.e));
                    }
                    this.a_(this.dt() + vec3D.c, this.dv() + vec3D.d, this.dz() + vec3D.e);
                    this.i(vec3D);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.cd |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.co[i].cK());
                            continue;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dO(), this.dO().a((net.minecraft.world.entity.Entity)this, this.co[6].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dO(), this.dO().a((net.minecraft.world.entity.Entity)this, this.co[7].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dO().a((net.minecraft.world.entity.Entity)this, this.co[0].cK().g(1.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dO().a((net.minecraft.world.entity.Entity)this, this.co[1].cK().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            } else {
                super.m_();
            }
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition dimensionTransition) {
            if (this.npc == null) {
                return super.a(dimensionTransition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, dimensionTransition);
        }

        public void dA() {
            if (this.npc == null) {
                super.dA();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect n_() {
            return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public float fd() {
            return NMS.getJumpPower(this.npc, super.fd());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean N_() {
            return NMSImpl.isLeashed(this.npc, () -> super.N_(), (EntityInsentient)this);
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double d, double d2, double d3) {
            NMS.callKnockbackEvent(this.npc, (float)d, d2, d3, nPCKnockbackEvent -> super.p((double)((float)nPCKnockbackEvent.getStrength()), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean g(DamageSource damageSource, float f) {
            if (this.npc == null) {
                return super.g(damageSource, f);
            }
            Vec3D vec3D = this.dr();
            boolean bl = super.g(damageSource, f);
            if (this.gh().a().i() == DragonControllerPhase.k) {
                this.i(vec3D);
            }
            return bl;
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.dr().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.i(vec3D);
            }
            return bl;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entityEnderDragonNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entityEnderDragonNPC);
        }
    }
}

