/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.ServerPlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends PlayerChunkMap.EntityTracker {
    private final net.minecraft.world.entity.Entity tracker;
    private static volatile Boolean REQUIRES_SYNC;
    private static final MethodHandle TRACK_DELTA;
    private static final MethodHandle TRACKER;
    private static final MethodHandle TRACKER_ENTRY;
    private static final MethodHandle TRACKING_RANGE;
    private static final MethodHandle TRACKING_RANGE_SETTER;
    private static final MethodHandle TRACKING_SET_SETTER;
    private static final MethodHandle UPDATE_INTERVAL;

    public CitizensEntityTracker(PlayerChunkMap playerChunkMap, net.minecraft.world.entity.Entity entity, int n, int n2, boolean bl) {
        PlayerChunkMap playerChunkMap2 = playerChunkMap;
        Objects.requireNonNull(playerChunkMap2);
        super(playerChunkMap2, entity, n, n2, bl);
        this.tracker = entity;
        try {
            final Set set = this.f;
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<ServerPlayerConnection>(){

                public boolean add(ServerPlayerConnection serverPlayerConnection) {
                    boolean bl = super.add((Object)serverPlayerConnection);
                    if (bl) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)serverPlayerConnection.o().getBukkitEntity()));
                    }
                    return bl;
                }

                protected Set<ServerPlayerConnection> delegate() {
                    return set;
                }

                public boolean remove(Object object) {
                    boolean bl = super.remove(object);
                    if (bl) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((ServerPlayerConnection)object).o().getBukkitEntity()));
                    }
                    return bl;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public CitizensEntityTracker(PlayerChunkMap playerChunkMap, PlayerChunkMap.EntityTracker entityTracker) {
        this(playerChunkMap, CitizensEntityTracker.getTracker(entityTracker), CitizensEntityTracker.getTrackingDistance(entityTracker), CitizensEntityTracker.getUpdateInterval(entityTracker), CitizensEntityTracker.getTrackDelta(entityTracker));
    }

    public void b(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.tracker.dJ() && !this.f.contains(entityPlayer.c) && this.tracker instanceof NPCHolder) {
            boolean bl;
            NPC nPC = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (bl = Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent nPCSeenByPlayerEvent = new NPCSeenByPlayerEvent(nPC, (Player)entityPlayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)nPCSeenByPlayerEvent);
                }
                catch (IllegalStateException illegalStateException) {
                    REQUIRES_SYNC = true;
                    throw illegalStateException;
                }
                if (nPCSeenByPlayerEvent.isCancelled()) {
                    return true;
                }
                Integer n = (Integer)nPC.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && n != null && nPC.data().get("last-tracking-range", Integer.valueOf(-1)).intValue() != n.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, n);
                        nPC.data().set("last-tracking-range", (Object)n);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                return false;
            }, REQUIRES_SYNC).booleanValue()) {
                return;
            }
        }
        super.b(entityPlayer);
    }

    public static Collection<Entity> getSeenBy(PlayerChunkMap.EntityTracker entityTracker) {
        return entityTracker.f.stream().map(serverPlayerConnection -> serverPlayerConnection.o().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static boolean getTrackDelta(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return TRACK_DELTA.invoke(TRACKER_ENTRY.invoke(entityTracker));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static net.minecraft.world.entity.Entity getTracker(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return TRACKER.invoke(entityTracker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return TRACKING_RANGE.invoke(entityTracker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    private static int getUpdateInterval(PlayerChunkMap.EntityTracker entityTracker) {
        try {
            return UPDATE_INTERVAL.invoke(TRACKER_ENTRY.invoke(entityTracker));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    static {
        TRACK_DELTA = NMS.getGetter(EntityTrackerEntry.class, "i");
        TRACKER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, net.minecraft.world.entity.Entity.class);
        TRACKER_ENTRY = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
        TRACKING_RANGE = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        TRACKING_SET_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Set.class);
        UPDATE_INTERVAL = NMS.getGetter(EntityTrackerEntry.class, "h");
    }
}

