/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.EntityArmorStand;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.Vec3D;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.util.Vector;

public class ArmorStandController
extends MobEntityController {
    public ArmorStandController() {
        super(EntityArmorStandNPC.class);
    }

    public ArmorStand getBukkitEntity() {
        return (ArmorStand)super.getBukkitEntity();
    }

    public static class EntityArmorStandNPC
    extends EntityArmorStand
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityArmorStandNPC(World world) {
            this(world, null);
        }

        public EntityArmorStandNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public boolean a(EntityHuman entityHuman, Vec3D vec3D) {
            if (this.npc == null) {
                return super.a(entityHuman, vec3D);
            }
            PlayerInteractEntityEvent playerInteractEntityEvent = new PlayerInteractEntityEvent((Player)entityHuman.getBukkitEntity(), (Entity)this.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)playerInteractEntityEvent);
            return !playerInteractEntityEvent.isCancelled();
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new ArmorStandNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setSize(float f, float f2) {
            if (this.npc == null) {
                super.setSize(f, f2);
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_8_R3.Entity)this, f, f2, this.justCreated);
            }
        }

        public void t_() {
            super.t_();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }

    public static class ArmorStandNPC
    extends CraftArmorStand
    implements NPCHolder {
        private final CitizensNPC npc;

        public ArmorStandNPC(EntityArmorStandNPC entityArmorStandNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityArmorStand)entityArmorStandNPC);
            this.npc = entityArmorStandNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

