/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.EntityEnderSignal;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EnderSignalController
extends MobEntityController {
    public EnderSignalController() {
        super(EntityEnderSignalNPC.class);
    }

    public EnderSignal getBukkitEntity() {
        return (EnderSignal)super.getBukkitEntity();
    }

    public static class EntityEnderSignalNPC
    extends EntityEnderSignal
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderSignalNPC(World world) {
            this(world, null);
        }

        public EntityEnderSignalNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new EnderSignalNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }

    public static class EnderSignalNPC
    extends CraftEnderSignal
    implements NPCHolder {
        private final CitizensNPC npc;

        public EnderSignalNPC(EntityEnderSignalNPC entityEnderSignalNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderSignal)entityEnderSignalNPC);
            this.npc = entityEnderSignalNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

