/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class StraightLineNavigationStrategy
extends AbstractPathStrategy {
    private Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Entity target;

    public StraightLineNavigationStrategy(NPC nPC, Entity entity, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        this.params = navigatorParameters;
        this.target = entity;
        this.npc = nPC;
        this.destination = navigatorParameters.entityTargetLocationMapper().apply(entity);
    }

    public StraightLineNavigationStrategy(NPC nPC, Location location, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        this.params = navigatorParameters;
        this.destination = location;
        this.npc = nPC;
    }

    @Override
    public Location getCurrentDestination() {
        return this.destination;
    }

    @Override
    public Iterable<Vector> getPath() {
        return null;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null || this.npc.getStoredLocation().getWorld() != this.destination.getWorld()) {
            return true;
        }
        Location location = this.npc.getEntity().getLocation();
        if (location.distance(this.destination) <= this.params.distanceMargin()) {
            if (this.npc.isFlyable()) {
                this.npc.getEntity().setVelocity(new Vector(0, 0, 0));
            }
            return true;
        }
        if (this.target != null) {
            this.destination = this.params.entityTargetLocationMapper().apply(this.target);
        }
        Vector vector = location.toVector().add(this.destination.toVector().subtract(location.toVector()).normalize());
        Location location2 = vector.toLocation(this.destination.getWorld());
        if (!this.npc.isFlyable() && vector.getBlockY() > location.getBlockY()) {
            Block block = location2.getBlock();
            while (block.getY() > location.getBlockY() && !MinecraftBlockExaminer.canStandOn(block.getRelative(BlockFace.DOWN))) {
                if ((block = block.getRelative(BlockFace.DOWN)).getY() > 0) continue;
                block = location2.getBlock();
                break;
            }
            location2 = block.getLocation();
            vector = location2.toVector();
        }
        double d = vector.getX() - location.getX();
        double d2 = vector.getZ() - location.getZ();
        double d3 = vector.getY() - location.getY();
        double d4 = d * d + d2 * d2;
        double d5 = d4 + d3 * d3;
        if (this.npc.isFlyable()) {
            float f;
            Vector vector2 = this.npc.getEntity().getVelocity();
            double d6 = vector2.getX();
            double d7 = vector2.getY();
            double d8 = vector2.getZ();
            d6 += (Math.signum(d) * 0.5 - d6) * 0.1;
            d7 += (Math.signum(d3) - d7) * 0.1;
            d8 += (Math.signum(d2) * 0.5 - d8) * 0.1;
            vector2.setX(d6).setY(d7).setZ(d8).multiply(this.params.speed());
            this.npc.getEntity().setVelocity(vector2);
            float f2 = (float)(Math.atan2(d8, d6) * 180.0 / Math.PI) - 90.0f;
            for (f = f2 - location.getYaw(); f >= 180.0f; f -= 360.0f) {
            }
            while (f < -180.0f) {
                f += 360.0f;
            }
            if (this.npc.getEntity().getType() != EntityType.ENDER_DRAGON) {
                NMS.setVerticalMovement(this.npc.getEntity(), 0.5);
                NMS.setHeadAndBodyYaw(this.npc.getEntity(), location.getYaw() + f);
            }
        } else if (this.npc.getEntity() instanceof LivingEntity) {
            NMS.setDestination(this.npc.getEntity(), vector.getX(), vector.getY(), vector.getZ(), this.params.speed());
        } else {
            Vector vector3 = vector.subtract(location.toVector()).normalize().multiply(0.2);
            Block block = location.getBlock();
            if (d5 > 0.0 && d3 >= 1.0 && d4 <= 2.75 || d3 >= 0.2 && MinecraftBlockExaminer.isLiquidOrInLiquid(block)) {
                vector3.add(new Vector(0.0, 0.75, 0.0));
            }
            Util.faceLocation(this.npc.getEntity(), location2);
            this.npc.getEntity().setVelocity(vector3);
        }
        return false;
    }
}

