/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.profile.ProfileFetcher;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.SkinProperty;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.scheduler.BukkitTask;

public class Skin {
    private boolean fetching;
    private int fetchRetries = -1;
    private boolean hasFetched;
    private volatile boolean isValid = true;
    private final Map<SkinnableEntity, Void> pending = new WeakHashMap<SkinnableEntity, Void>(15);
    private BukkitTask retryTask;
    private volatile SkinProperty skinData;
    private volatile UUID skinId;
    private final String skinName;
    private static Map<String, Skin> CACHE = new HashMap<String, Skin>(20);
    public static String CACHED_SKIN_UUID_METADATA = "cached-skin-uuid";
    public static String CACHED_SKIN_UUID_NAME_METADATA = "cached-skin-uuid-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Skin(String string) {
        this.skinName = string.toLowerCase();
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            if (CACHE.containsKey(this.skinName)) {
                throw new IllegalArgumentException("There is already a skin named " + string);
            }
            CACHE.put(this.skinName, this);
        }
    }

    public boolean apply(SkinnableEntity skinnableEntity) {
        Objects.requireNonNull(skinnableEntity);
        NPC nPC = skinnableEntity.getNPC();
        SkinTrait skinTrait = nPC.getOrAddTrait(SkinTrait.class);
        String string = (String)nPC.data().get(CACHED_SKIN_UUID_NAME_METADATA);
        String string2 = skinTrait.getTexture();
        if (this.skinName.equals(string) && string2 != null && !string2.equals("cache")) {
            Skin.setNPCTexture(skinnableEntity, new SkinProperty("textures", string2, skinTrait.getSignature()));
            if (skinnableEntity.getNPC().data().has("player-skin-use-latest")) {
                skinnableEntity.getNPC().data().remove("player-skin-use-latest");
            }
            if (!skinTrait.shouldUpdateSkins()) {
                return true;
            }
        }
        if (!this.hasSkinData()) {
            String string3 = ChatColor.stripColor((String)nPC.getName()).toLowerCase();
            if (nPC.hasTrait(SkinTrait.class) && this.skinName.equals(string3) && !nPC.getOrAddTrait(SkinTrait.class).fetchDefaultSkin()) {
                return false;
            }
            if (this.hasFetched) {
                return true;
            }
            if (!this.fetching) {
                this.fetch();
            }
            this.pending.put(skinnableEntity, null);
            return false;
        }
        Skin.setNPCSkinData(skinnableEntity, this.skinName, this.skinId, this.skinData);
        return true;
    }

    public void applyAndRespawn(SkinnableEntity skinnableEntity) {
        Objects.requireNonNull(skinnableEntity);
        if (!this.apply(skinnableEntity)) {
            return;
        }
        NPC nPC = skinnableEntity.getNPC();
        if (!nPC.isSpawned()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            nPC.despawn(DespawnReason.PENDING_RESPAWN);
            nPC.spawn(nPC.getStoredLocation(), SpawnReason.RESPAWN);
        });
    }

    private void fetch() {
        int n = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (n > -1 && this.fetchRetries >= n) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Reached max skin fetch retries for '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Skin name invalid length '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.toLowerCase().startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetch(this.skinName, profileRequest -> {
            this.hasFetched = true;
            switch (profileRequest.getResult()) {
                case NOT_FOUND: {
                    this.isValid = false;
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    if (n == 0) break;
                    ++this.fetchRetries;
                    long l = Settings.Setting.NPC_SKIN_RETRY_DELAY.asTicks();
                    this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), this::fetch, l);
                    Messaging.idebug(() -> "Retrying skin fetch for '" + this.skinName + "' in " + l + " ticks.");
                    break;
                }
                case SUCCESS: {
                    GameProfile gameProfile = profileRequest.getProfile();
                    this.setData(gameProfile);
                    break;
                }
            }
        });
    }

    private void fetchForced() {
        int n = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (n > -1 && this.fetchRetries >= n) {
            Messaging.idebug(() -> "Reached max skin fetch retries for '" + this.skinName + "'");
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            Messaging.idebug(() -> "Skin name invalid length '" + this.skinName + "'");
            return;
        }
        if (this.skinName.toLowerCase().startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetchForced(this.skinName, profileRequest -> {
            this.hasFetched = true;
            switch (profileRequest.getResult()) {
                case NOT_FOUND: {
                    this.isValid = false;
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    if (n == 0) break;
                    ++this.fetchRetries;
                    int n2 = Settings.Setting.NPC_SKIN_RETRY_DELAY.asTicks();
                    this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), this::fetchForced, (long)n2);
                    Messaging.idebug(() -> "Retrying skin fetch for '" + this.skinName + "' in " + n2 + " ticks.");
                    break;
                }
                case SUCCESS: {
                    GameProfile gameProfile = profileRequest.getProfile();
                    this.setData(gameProfile);
                    break;
                }
            }
        });
    }

    @Nullable
    public UUID getSkinId() {
        return this.skinId;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public boolean hasSkinData() {
        return this.skinData != null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void setData(@Nullable GameProfile gameProfile) {
        if (gameProfile == null) {
            this.isValid = false;
            return;
        }
        if (!gameProfile.getName().toLowerCase().equals(this.skinName)) {
            Messaging.debug("GameProfile name (" + gameProfile.getName() + ") and skin name (" + this.skinName + ") do not match. Has the user renamed recently?");
        }
        this.skinId = gameProfile.getId();
        this.skinData = SkinProperty.fromMojangProfile(gameProfile);
        ArrayList<SkinnableEntity> arrayList = new ArrayList<SkinnableEntity>(this.pending.keySet());
        for (SkinnableEntity skinnableEntity : arrayList) {
            this.applyAndRespawn(skinnableEntity);
        }
        this.pending.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            for (Skin skin : CACHE.values()) {
                skin.pending.clear();
                if (skin.retryTask == null) continue;
                skin.retryTask.cancel();
            }
            CACHE.clear();
        }
    }

    public static Skin get(SkinnableEntity skinnableEntity) {
        return Skin.get(skinnableEntity, false);
    }

    public static Skin get(SkinnableEntity skinnableEntity, boolean bl) {
        Objects.requireNonNull(skinnableEntity);
        String string = skinnableEntity.getSkinName().toLowerCase();
        return Skin.get(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin get(String string, boolean bl) {
        Skin skin;
        Objects.requireNonNull(string);
        string = string.toLowerCase();
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            skin = CACHE.get(string);
        }
        if (skin == null) {
            skin = new Skin(string);
        } else if (bl) {
            skin.fetchForced();
        }
        return skin;
    }

    private static void setNPCSkinData(SkinnableEntity skinnableEntity, String string, UUID uUID, SkinProperty skinProperty) {
        NPC nPC = skinnableEntity.getNPC();
        SkinTrait skinTrait = nPC.getOrAddTrait(SkinTrait.class);
        nPC.data().setPersistent(CACHED_SKIN_UUID_NAME_METADATA, (Object)string);
        nPC.data().setPersistent(CACHED_SKIN_UUID_METADATA, (Object)uUID.toString());
        if (skinProperty.value != null) {
            skinTrait.setTexture(skinProperty.value, skinProperty.signature == null ? "" : skinProperty.signature);
            Skin.setNPCTexture(skinnableEntity, skinProperty);
        } else {
            skinTrait.clearTexture();
        }
    }

    private static void setNPCTexture(SkinnableEntity skinnableEntity, SkinProperty skinProperty) {
        GameProfile gameProfile = skinnableEntity.getProfile();
        SkinProperty skinProperty2 = SkinProperty.fromMojangProfile(gameProfile);
        if (skinProperty2 != null && skinProperty2.value.equals(skinProperty.value) && skinProperty2.signature != null && skinProperty2.signature.equals(skinProperty.signature)) {
            return;
        }
        skinProperty.apply(gameProfile);
    }
}

