/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.ClickRedirectTrait;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;

@TraitName(value="armorstandtrait")
public class ArmorStandTrait
extends Trait {
    @Persist
    private EulerAngle body;
    @Persist
    private boolean gravity = true;
    @Persist
    private boolean hasarms = true;
    @Persist
    private boolean hasbaseplate = true;
    @Persist
    private EulerAngle head;
    @Persist
    private EulerAngle leftArm;
    @Persist
    private EulerAngle leftLeg;
    @Persist
    private boolean marker;
    @Persist
    private EulerAngle rightArm;
    @Persist
    private EulerAngle rightLeg;
    @Persist
    private boolean small;
    @Persist
    private boolean visible = true;

    public ArmorStandTrait() {
        super("armorstandtrait");
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public boolean getHasArms() {
        return this.hasarms;
    }

    public boolean getHasBaseplate() {
        return this.hasbaseplate;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public boolean isSmall() {
        return this.small;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onPreSpawn() {
        this.onSpawn();
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)this.npc.getEntity();
        if (this.leftArm != null) {
            armorStand.setLeftArmPose(this.leftArm);
        }
        if (this.leftLeg != null) {
            armorStand.setLeftLegPose(this.leftLeg);
        }
        if (this.rightArm != null) {
            armorStand.setRightArmPose(this.rightArm);
        }
        if (this.rightLeg != null) {
            armorStand.setRightLegPose(this.rightLeg);
        }
        if (this.body != null) {
            armorStand.setBodyPose(this.body);
        }
        if (this.head != null) {
            armorStand.setHeadPose(this.head);
        }
        armorStand.setVisible(this.visible);
        armorStand.setGravity(this.gravity);
        armorStand.setArms(this.hasarms);
        armorStand.setBasePlate(this.hasbaseplate);
        armorStand.setSmall(this.small);
        armorStand.setMarker(this.marker);
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)this.npc.getEntity();
        this.body = armorStand.getBodyPose();
        this.leftArm = armorStand.getLeftArmPose();
        this.leftLeg = armorStand.getLeftLegPose();
        this.rightArm = armorStand.getRightArmPose();
        this.rightLeg = armorStand.getRightLegPose();
        this.head = armorStand.getHeadPose();
        armorStand.setVisible(this.visible);
        armorStand.setGravity(this.gravity);
        armorStand.setArms(this.hasarms);
        armorStand.setBasePlate(this.hasbaseplate);
        armorStand.setSmall(this.small);
        armorStand.setMarker(this.marker);
    }

    public void setAsHelperEntity(NPC nPC) {
        this.npc.addTrait(new ClickRedirectTrait(nPC));
        this.setAsPointEntity();
    }

    public void setAsHelperEntityWithName(NPC nPC) {
        this.npc.addTrait(new ClickRedirectTrait(nPC));
        this.setAsPointEntityWithName();
    }

    public void setAsPointEntity() {
        this.setGravity(false);
        this.setHasArms(false);
        this.setHasBaseplate(false);
        this.setSmall(true);
        this.setMarker(true);
        this.setVisible(false);
        this.npc.setProtected(true);
        this.npc.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
    }

    public void setAsPointEntityWithName() {
        this.setAsPointEntity();
        this.npc.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)true);
    }

    public void setGravity(boolean bl) {
        this.gravity = bl;
    }

    public void setHasArms(boolean bl) {
        this.hasarms = bl;
    }

    public void setHasBaseplate(boolean bl) {
        this.hasbaseplate = bl;
    }

    public void setMarker(boolean bl) {
        this.marker = bl;
    }

    public void setSmall(boolean bl) {
        this.small = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

