/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.event.EventHandler;

@TraitName(value="clickredirecttrait")
public class ClickRedirectTrait
extends Trait {
    private NPC redirectNPC;

    public ClickRedirectTrait() {
        super("clickredirecttrait");
    }

    public ClickRedirectTrait(NPC nPC) {
        this();
        this.redirectNPC = nPC;
        if (this.redirectNPC != null && this.redirectNPC.hasTrait(PlayerFilter.class)) {
            this.redirectNPC.getOrAddTrait(PlayerFilter.class).addChildNPC(nPC);
        }
    }

    public NPC getRedirectNPC() {
        return this.redirectNPC;
    }

    @Override
    public void load(DataKey dataKey) {
        this.redirectNPC = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(UUID.fromString(dataKey.getString("uuid")));
    }

    @EventHandler
    public void onTraitAdd(NPCAddTraitEvent nPCAddTraitEvent) {
        if (nPCAddTraitEvent.getNPC() == this.redirectNPC && nPCAddTraitEvent.getTrait() instanceof PlayerFilter) {
            ((PlayerFilter)nPCAddTraitEvent.getTrait()).addChildNPC(this.npc);
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.removeKey("uuid");
        if (this.redirectNPC == null) {
            return;
        }
        dataKey.setString("uuid", this.redirectNPC.getUniqueId().toString());
    }
}

