/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;

@TraitName(value="mounttrait")
public class MountTrait
extends Trait {
    private UUID currentMount;
    @Persist(value="mountedon")
    private UUID uuid;

    public MountTrait() {
        super("mounttrait");
    }

    public void checkMounted() {
        if (this.uuid == null || this.uuid.equals(this.currentMount)) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(this.uuid);
        if (nPC != null && nPC.isSpawned()) {
            NMS.mount(nPC.getEntity(), this.npc.getEntity());
            this.currentMount = this.uuid;
        }
    }

    public UUID getMountedOn() {
        return this.currentMount;
    }

    @Override
    public void onDespawn() {
        if (NMS.getVehicle(this.npc.getEntity()) != null) {
            this.npc.getEntity().leaveVehicle();
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        this.checkMounted();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        Entity entity = NMS.getVehicle(this.npc.getEntity());
        if (entity == null && this.currentMount != null) {
            this.currentMount = null;
        } else if (entity instanceof NPCHolder) {
            this.setMountedOn(((NPCHolder)entity).getNPC().getUniqueId());
        }
        this.checkMounted();
    }

    public void setMountedOn(UUID uUID) {
        this.uuid = uUID;
        if (this.npc.isSpawned()) {
            this.checkMounted();
        }
    }

    public void unmount() {
        if (this.currentMount == null) {
            return;
        }
        if (NMS.getVehicle(this.npc.getEntity()) != null) {
            this.npc.getEntity().leaveVehicle();
        }
        this.uuid = null;
        this.currentMount = null;
    }
}

