/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;

@TraitName(value="pausepathfinding")
public class PausePathfindingTrait
extends Trait {
    @Persist(value="pauseticks")
    private int pauseTicks;
    @Persist(value="playerrange")
    private double playerRange = -1.0;
    @Persist(value="rightclick")
    private boolean rightclick;
    private int unpauseTaskId = -1;

    public PausePathfindingTrait() {
        super("pausepathfinding");
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(NPCRightClickEvent nPCRightClickEvent) {
        if (!this.rightclick || nPCRightClickEvent.getNPC() != this.npc) {
            return;
        }
        this.pause();
        nPCRightClickEvent.setDelayedCancellation(true);
    }

    private void pause() {
        if (this.unpauseTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.unpauseTaskId);
        }
        this.npc.getNavigator().cancelNavigation();
        this.npc.getNavigator().setPaused(true);
        this.unpauseTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.npc.getNavigator().setPaused(false), this.pauseTicks <= 0 ? 20L : (long)this.pauseTicks);
    }

    @Override
    public void run() {
        if (this.playerRange == -1.0 || !this.npc.isSpawned() || this.unpauseTaskId == -1 && !this.npc.getNavigator().isNavigating()) {
            return;
        }
        if (CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(this.npc.getEntity(), this.npc.getStoredLocation(), this.playerRange).iterator().hasNext()) {
            this.pause();
        }
    }

    public void setPauseTicks(int n) {
        this.pauseTicks = n;
    }

    public void setPlayerRangeBlocks(double d) {
        this.playerRange = d;
    }

    public void setRightClick(boolean bl) {
        this.rightclick = bl;
    }
}

