/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.Pose;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

@TraitName(value="poses")
public class Poses
extends Trait {
    @Persist
    private String defaultPose;
    private final Map<String, Pose> poses = Maps.newHashMap();

    public Poses() {
        super("poses");
    }

    public boolean addPose(String string, Location location) {
        return this.addPose(string, location, false);
    }

    public boolean addPose(String string, Location location, boolean bl) {
        string = string.toLowerCase();
        Pose pose = new Pose(string, location.getPitch(), location.getYaw());
        if (this.poses.containsKey(string)) {
            return false;
        }
        this.poses.put(string, pose);
        if (bl) {
            this.defaultPose = string;
        }
        return true;
    }

    private void assumePose(float f, float f2) {
        if (!this.npc.isSpawned()) {
            this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.COMMAND);
        }
        this.npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(f, f2);
    }

    public void assumePose(Location location) {
        this.assumePose(location.getYaw(), location.getPitch());
    }

    public void assumePose(String string) {
        if (string == null) {
            return;
        }
        Pose pose = this.poses.get(string.toLowerCase());
        this.assumePose(pose.getYaw(), pose.getPitch());
    }

    public void describe(CommandSender commandSender, int n) {
        Paginator paginator = new Paginator().header("Pose").console(commandSender instanceof ConsoleCommandSender);
        paginator.addLine("<green>ID  <yellow>Name  <red>Pitch/Yaw");
        int n2 = 0;
        for (Pose pose : this.poses.values()) {
            String string = "<green>" + n2 + "<yellow>  " + pose.getName() + "<red>  " + pose.getPitch() + " " + pose.getYaw();
            paginator.addLine(string);
            ++n2;
        }
        if (!paginator.sendPage(commandSender, n)) {
            throw new CommandException("citizens.commands.page-missing", n);
        }
    }

    public Pose getPose(String string) {
        return string == null ? null : this.poses.get(string.toLowerCase());
    }

    public boolean hasPose(String string) {
        if (string == null) {
            return false;
        }
        return this.poses.containsKey(string.toLowerCase());
    }

    @Override
    public void load(DataKey dataKey) {
        this.poses.clear();
        for (DataKey dataKey2 : dataKey.getRelative("list").getIntegerSubKeys()) {
            try {
                String[] stringArray = dataKey2.getString("").split(";");
                this.poses.put(stringArray[0].toLowerCase(), new Pose(stringArray[0], Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])));
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.logTr("citizens.notifications.skipping-invalid-pose", dataKey2.name(), numberFormatException.getMessage());
            }
        }
    }

    public boolean removePose(String string) {
        return string == null ? false : this.poses.remove(string.toLowerCase()) != null;
    }

    @Override
    public void run() {
        LookClose lookClose;
        if (!this.hasPose(this.defaultPose) || this.npc.getNavigator().isNavigating()) {
            return;
        }
        if (this.npc.hasTrait(LookClose.class) && (lookClose = this.npc.getOrAddTrait(LookClose.class)).isEnabled() && lookClose.canSeeTarget()) {
            return;
        }
        this.assumePose(this.defaultPose);
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.removeKey("list");
        int n = 0;
        for (Pose pose : this.poses.values()) {
            dataKey.setString("list." + n, pose.stringValue());
            ++n;
        }
    }

    public void setDefaultPose(String string) {
        this.defaultPose = string;
    }
}

