/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@TraitName(value="rotationtrait")
public class RotationTrait
extends Trait {
    @Persist(reify=true)
    private final RotationParams globalParameters = new RotationParams();
    private final RotationSession globalSession = new RotationSession(this.globalParameters);
    private List<PacketRotationSession> packetSessions = Lists.newCopyOnWriteArrayList();
    private final Map<UUID, PacketRotationSession> packetSessionsByUUID = Maps.newConcurrentMap();

    public RotationTrait() {
        super("rotationtrait");
    }

    public void clearPacketSessions() {
        this.packetSessions.clear();
        this.packetSessionsByUUID.clear();
    }

    public PacketRotationSession createPacketSession(RotationParams rotationParams) {
        if (rotationParams.filter == null && rotationParams.uuidFilter == null) {
            throw new IllegalStateException();
        }
        RotationSession rotationSession = new RotationSession(rotationParams);
        PacketRotationSession packetRotationSession = new PacketRotationSession(rotationSession);
        if (rotationParams.uuidFilter != null) {
            for (UUID uUID : rotationParams.uuidFilter) {
                this.packetSessionsByUUID.put(uUID, packetRotationSession);
            }
        } else {
            this.packetSessions.add(packetRotationSession);
        }
        return packetRotationSession;
    }

    private Location getEyeLocation() {
        return this.npc.getEntity() instanceof LivingEntity ? ((LivingEntity)this.npc.getEntity()).getEyeLocation() : this.npc.getEntity().getLocation();
    }

    public RotationParams getGlobalParameters() {
        return this.globalParameters;
    }

    public PacketRotationSession getPacketSession(Player player) {
        PacketRotationSession packetRotationSession = this.packetSessionsByUUID.get(player.getUniqueId());
        if (packetRotationSession != null && packetRotationSession.triple != null) {
            return packetRotationSession;
        }
        for (PacketRotationSession packetRotationSession2 : this.packetSessions) {
            if (!packetRotationSession2.accepts(player) || packetRotationSession2.triple == null) continue;
            return packetRotationSession2;
        }
        return null;
    }

    public RotationSession getPhysicalSession() {
        return this.globalSession;
    }

    public void resetPlayerToPhysicalSession(UUID uUID) {
        PacketRotationSession packetRotationSession = this.packetSessionsByUUID.remove(uUID);
        if (packetRotationSession == null || !this.npc.isSpawned()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            return;
        }
        NMS.sendPositionUpdate(this.npc.getEntity(), (Collection<Player>)ImmutableList.of((Object)player), false);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.npc.data().get(NPC.Metadata.RESET_PITCH_ON_TICK, Boolean.valueOf(false)).booleanValue()) {
            NMS.setPitch(this.npc.getEntity(), 0.0f);
        }
        HashSet hashSet = Sets.newHashSet();
        for (PacketRotationSession packetRotationSession2 : Iterables.concat(this.packetSessions, this.packetSessionsByUUID.values())) {
            if (hashSet.contains(packetRotationSession2)) continue;
            hashSet.add(packetRotationSession2);
            packetRotationSession2.run(this.npc.getEntity());
        }
        this.packetSessions = Lists.newCopyOnWriteArrayList((Iterable)this.packetSessions.stream().filter(packetRotationSession -> packetRotationSession.isActive()).collect(Collectors.toCollection(CopyOnWriteArrayList::new)));
        this.packetSessionsByUUID.values().removeIf(packetRotationSession -> !packetRotationSession.isActive());
        if (this.npc.getNavigator().isNavigating()) {
            return;
        }
        this.globalSession.run(new EntityRotation(this.npc.getEntity()));
    }

    private static float clamp(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f3, f));
    }

    public static class RotationParams
    implements Persistable,
    Cloneable {
        private Function<Player, Boolean> filter;
        private boolean headOnly = false;
        private boolean immediate = false;
        private boolean linkedBody;
        private float maxPitchPerTick = 10.0f;
        private float maxYawPerTick = 40.0f;
        private volatile boolean persist = false;
        private float[] pitchRange = new float[]{-180.0f, 180.0f};
        private List<UUID> uuidFilter;
        private float[] yawRange = new float[]{-180.0f, 180.0f};

        public boolean accepts(Player player) {
            return this.filter.apply(player);
        }

        public RotationParams clone() {
            try {
                return (RotationParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public RotationParams filter(Function<Player, Boolean> function) {
            this.filter = function;
            return this;
        }

        public RotationParams headOnly(boolean bl) {
            this.headOnly = bl;
            return this;
        }

        public RotationParams immediate(boolean bl) {
            this.immediate = bl;
            return this;
        }

        public RotationParams linkedBody(boolean bl) {
            this.linkedBody = bl;
            return this;
        }

        @Override
        public void load(DataKey dataKey) {
            String[] stringArray;
            if (dataKey.keyExists("headOnly")) {
                this.headOnly = dataKey.getBoolean("headOnly");
            }
            if (dataKey.keyExists("immediate")) {
                this.immediate = dataKey.getBoolean("immediate");
            }
            if (dataKey.keyExists("maxPitchPerTick")) {
                this.maxPitchPerTick = (float)dataKey.getDouble("maxPitchPerTick");
            }
            if (dataKey.keyExists("maxYawPerTick")) {
                this.maxYawPerTick = (float)dataKey.getDouble("maxYawPerTick");
            }
            if (dataKey.keyExists("linkedBody")) {
                this.linkedBody = dataKey.getBoolean("linkedBody");
            }
            if (dataKey.keyExists("yawRange")) {
                stringArray = dataKey.getString("yawRange").split(",");
                this.yawRange = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1])};
            }
            if (dataKey.keyExists("pitchRange")) {
                stringArray = dataKey.getString("pitchRange").split(",");
                this.pitchRange = new float[]{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1])};
            }
        }

        public RotationParams maxPitchPerTick(float f) {
            this.maxPitchPerTick = f;
            return this;
        }

        public RotationParams maxYawPerTick(float f) {
            this.maxYawPerTick = f;
            return this;
        }

        public RotationParams persist(boolean bl) {
            this.persist = bl;
            return this;
        }

        public RotationParams pitchRange(float[] fArray) {
            this.pitchRange = fArray;
            return this;
        }

        public float rotateHeadYawTowards(int n, float f, float f2) {
            float f3 = this.rotateTowards(f, f2, this.maxYawPerTick);
            return Util.clamp(f3, this.yawRange[0], this.yawRange[1], 360.0f);
        }

        public float rotatePitchTowards(int n, float f, float f2) {
            float f3 = this.rotateTowards(f, f2, this.maxPitchPerTick);
            return Util.clamp(f3, this.pitchRange[0], this.pitchRange[1], 360.0f);
        }

        private float rotateTowards(float f, float f2, float f3) {
            float f4 = Util.clamp(f2 - f);
            return f + RotationTrait.clamp(f4, -f3, f3);
        }

        @Override
        public void save(DataKey dataKey) {
            if (this.headOnly) {
                dataKey.setBoolean("headOnly", this.headOnly);
            }
            if (this.immediate) {
                dataKey.setBoolean("immediate", this.immediate);
            }
            if (this.maxPitchPerTick != 10.0f) {
                dataKey.setDouble("maxPitchPerTick", this.maxPitchPerTick);
            } else {
                dataKey.removeKey("maxPitchPerTick");
            }
            if (this.maxYawPerTick != 40.0f) {
                dataKey.setDouble("maxYawPerTick", this.maxYawPerTick);
            } else {
                dataKey.removeKey("maxYawPerTick");
            }
            if (this.pitchRange[0] != -180.0f || this.pitchRange[1] != 180.0f) {
                dataKey.setString("pitchRange", this.pitchRange[0] + "," + this.pitchRange[1]);
            } else {
                dataKey.removeKey("pitchRange");
            }
            if (this.yawRange[0] != -180.0f || this.yawRange[1] != 180.0f) {
                dataKey.setString("yawRange", this.yawRange[0] + "," + this.yawRange[1]);
            } else {
                dataKey.removeKey("yawRange");
            }
        }

        public RotationParams uuidFilter(List<UUID> list) {
            this.uuidFilter = list;
            return this;
        }

        public RotationParams uuidFilter(UUID ... uUIDArray) {
            return this.uuidFilter(Arrays.asList(uUIDArray));
        }

        public RotationParams yawRange(float[] fArray) {
            this.yawRange = fArray;
            return this;
        }
    }

    public class RotationSession {
        private final RotationParams params;
        private volatile int t = -1;
        private Supplier<Float> targetPitch = () -> Float.valueOf(0.0f);
        private Supplier<Float> targetYaw = this.targetPitch;

        public RotationSession(RotationParams rotationParams) {
            this.params = rotationParams;
        }

        public float getTargetPitch() {
            return this.targetPitch.get().floatValue();
        }

        public float getTargetYaw() {
            switch (RotationTrait.this.npc.getEntity().getType()) {
                case PHANTOM: {
                    return Util.clamp(this.targetYaw.get().floatValue() + 45.0f);
                }
                case ENDER_DRAGON: {
                    return Util.clamp(this.targetYaw.get().floatValue() - 180.0f);
                }
            }
            return this.targetYaw.get().floatValue();
        }

        public boolean isActive() {
            return this.params.persist || this.t >= 0;
        }

        public void rotateToFace(Entity entity) {
            this.rotateToFace(entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation());
        }

        public void rotateToFace(Location location) {
            this.t = 0;
            this.targetPitch = () -> {
                Location location2 = RotationTrait.this.getEyeLocation();
                double d = location.getX() - location2.getX();
                double d2 = location.getY() - location2.getY();
                double d3 = location.getZ() - location2.getZ();
                double d4 = Math.sqrt((float)(d * d + d3 * d3));
                return Float.valueOf((float)(-Math.toDegrees(Math.atan2(d2, d4))));
            };
            this.targetYaw = () -> {
                Location location2 = RotationTrait.this.getEyeLocation();
                return Float.valueOf((float)Math.toDegrees(Math.atan2(location.getZ() - location2.getZ(), location.getX() - location2.getX())) - 90.0f);
            };
        }

        public void rotateToHave(float f, float f2) {
            this.t = 0;
            this.targetYaw = () -> Float.valueOf(f);
            this.targetPitch = () -> Float.valueOf(f2);
        }

        private void run(RotationTriple rotationTriple) {
            if (!this.isActive()) {
                return;
            }
            float f = rotationTriple.headYaw = this.params.immediate ? this.getTargetYaw() : Util.clamp(this.params.rotateHeadYawTowards(this.t, rotationTriple.headYaw, this.getTargetYaw()));
            if (!this.params.headOnly) {
                float f2 = Util.clamp(rotationTriple.headYaw - 20.0f);
                float f3 = Util.clamp(rotationTriple.headYaw + 20.0f);
                if (f3 < 0.0f && f2 > 0.0f) {
                    float f4 = f3;
                    f3 = f2;
                    f2 = f4;
                }
                boolean bl = false;
                float f5 = Util.clamp(rotationTriple.bodyYaw);
                if (f3 > 0.0f && f2 < 0.0f) {
                    bl = f5 >= f3 || f5 <= f2;
                } else {
                    boolean bl2 = bl = f5 >= f2 && f5 <= f3;
                }
                if (!bl) {
                    rotationTriple.bodyYaw = Math.abs(f5 - f2) > Math.abs(f5 - f3) ? f3 : f2;
                }
            }
            rotationTriple.pitch = this.params.immediate ? this.getTargetPitch() : this.params.rotatePitchTowards(this.t, rotationTriple.pitch, this.getTargetPitch());
            ++this.t;
            if (this.params.linkedBody) {
                rotationTriple.bodyYaw = rotationTriple.headYaw;
            }
            if ((double)(Math.abs(rotationTriple.pitch - this.getTargetPitch()) + Math.abs(rotationTriple.headYaw - this.getTargetYaw())) < 0.1) {
                this.t = -1;
                if (!this.params.headOnly) {
                    rotationTriple.bodyYaw = rotationTriple.headYaw;
                }
            }
            rotationTriple.apply();
        }
    }

    public static class PacketRotationSession {
        private volatile boolean ended;
        private final RotationSession session;
        private volatile PacketRotationTriple triple;

        public PacketRotationSession(RotationSession rotationSession) {
            this.session = rotationSession;
        }

        public boolean accepts(Player player) {
            return this.session.params.accepts(player);
        }

        public void end() {
            this.ended = true;
        }

        public float getBodyYaw() {
            return this.triple.bodyYaw;
        }

        public float getHeadYaw() {
            return this.triple.headYaw;
        }

        public float getPitch() {
            return this.triple.pitch;
        }

        public RotationSession getSession() {
            return this.session;
        }

        public boolean isActive() {
            return !this.ended && this.session.isActive();
        }

        public void onPacketOverwritten() {
            if (this.triple == null) {
                return;
            }
            this.triple.record();
        }

        public void run(Entity entity) {
            if (this.triple == null) {
                this.triple = new PacketRotationTriple(entity);
            }
            this.session.run(this.triple);
            if (!this.session.isActive()) {
                this.triple = null;
            }
        }
    }

    private static class PacketRotationTriple
    extends EntityRotation {
        private volatile float lastBodyYaw;
        private volatile float lastHeadYaw;
        private volatile float lastPitch;

        public PacketRotationTriple(Entity entity) {
            super(entity);
        }

        @Override
        public void apply() {
            if (Math.abs(this.lastBodyYaw - this.bodyYaw) + Math.abs(this.lastHeadYaw - this.headYaw) + Math.abs(this.pitch - this.lastPitch) > 1.0f) {
                NMS.sendPositionUpdateNearby(this.entity, false, Float.valueOf(this.bodyYaw), Float.valueOf(this.pitch), Float.valueOf(this.headYaw));
            }
        }

        public void record() {
            this.lastBodyYaw = this.bodyYaw;
            this.lastHeadYaw = this.headYaw;
            this.lastPitch = this.pitch;
        }
    }

    private static class EntityRotation
    extends RotationTriple {
        protected Entity entity;

        public EntityRotation(Entity entity) {
            super(NMS.getYaw(entity), NMS.getHeadYaw(entity), entity.getLocation().getPitch());
            this.entity = entity;
        }

        @Override
        public void apply() {
            NMS.setBodyYaw(this.entity, this.bodyYaw);
            NMS.setHeadYaw(this.entity, this.headYaw);
            NMS.setPitch(this.entity, this.pitch);
        }
    }

    private static abstract class RotationTriple
    implements Cloneable {
        public float bodyYaw;
        public float headYaw;
        public float pitch;

        public RotationTriple(float f, float f2, float f3) {
            this.bodyYaw = f;
            this.headYaw = f2;
            this.pitch = f3;
        }

        public abstract void apply();

        public RotationTriple clone() {
            try {
                return (RotationTriple)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }
}

