/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.trait.shop.CommandAction;
import net.citizensnpcs.trait.shop.ExperienceAction;
import net.citizensnpcs.trait.shop.ItemAction;
import net.citizensnpcs.trait.shop.MoneyAction;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.trait.shop.PermissionAction;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;

@TraitName(value="shop")
public class ShopTrait
extends Trait {
    @Persist
    private String rightClickShop;
    private StoredShops shops;

    public ShopTrait() {
        super("shop");
    }

    public ShopTrait(StoredShops storedShops) {
        this();
        this.shops = storedShops;
    }

    public NPCShop getDefaultShop() {
        return this.shops.npcShops.computeIfAbsent(this.npc.getUniqueId().toString(), NPCShop::new);
    }

    public NPCShop getShop(String string) {
        return this.shops.globalShops.computeIfAbsent(string, NPCShop::new);
    }

    @Override
    public void onRemove() {
        this.shops.deleteShop(this.getDefaultShop());
    }

    public void onRightClick(Player player) {
        if (this.rightClickShop == null || this.rightClickShop.isEmpty()) {
            return;
        }
        String string = Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString();
        if (!string.isEmpty() && !player.hasPermission(string)) {
            return;
        }
        NPCShop nPCShop = this.shops.globalShops.getOrDefault(this.rightClickShop, this.getDefaultShop());
        nPCShop.display(player);
    }

    public void setDefaultShop(NPCShop nPCShop) {
        this.shops.npcShops.put(this.npc.getUniqueId().toString(), nPCShop);
    }

    static {
        NPCShopAction.register(ItemAction.class, "items", new ItemAction.ItemActionGUI());
        NPCShopAction.register(PermissionAction.class, "permissions", new PermissionAction.PermissionActionGUI());
        NPCShopAction.register(MoneyAction.class, "money", new MoneyAction.MoneyActionGUI());
        NPCShopAction.register(CommandAction.class, "command", new CommandAction.CommandActionGUI());
        NPCShopAction.register(ExperienceAction.class, "experience", new ExperienceAction.ExperienceActionGUI());
    }

    public static class NPCShop {
        @Persist(value="")
        private String name;
        @Persist(reify=true)
        private final List<NPCShopPage> pages = Lists.newArrayList();
        @Persist
        private String title;
        @Persist
        private ShopType type = ShopType.DEFAULT;
        @Persist
        private String viewPermission;

        private NPCShop() {
        }

        public NPCShop(String string) {
            this.name = string;
        }

        public boolean canEdit(NPC nPC, Player player) {
            return player.hasPermission("citizens.admin") || player.hasPermission("citizens.npc.shop.edit") || player.hasPermission("citizens.npc.shop.edit." + this.getName()) || nPC.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player);
        }

        public void display(Player player) {
            if (this.viewPermission != null && !player.hasPermission(this.viewPermission) || !Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString().isEmpty() && !player.hasPermission(Settings.Setting.SHOP_GLOBAL_VIEW_PERMISSION.asString())) {
                return;
            }
            if (this.pages.size() == 0) {
                Messaging.sendError((CommandSender)player, "Empty shop");
                return;
            }
            if (this.type == ShopType.TRADER) {
                CitizensAPI.registerEvents(new NPCTraderShopViewer(this, player));
            } else {
                InventoryMenu.createSelfRegistered(new NPCShopViewer(this, player)).present((HumanEntity)player);
            }
        }

        public void displayEditor(ShopTrait shopTrait, Player player) {
            InventoryMenu.createSelfRegistered(new NPCShopSettings(shopTrait, this)).present((HumanEntity)player);
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public NPCShopPage getOrCreatePage(int n) {
            while (this.pages.size() <= n) {
                this.pages.add(new NPCShopPage(n));
            }
            return this.pages.get(n);
        }

        public String getRequiredPermission() {
            return this.viewPermission;
        }

        public ShopType getShopType() {
            return this.type == null ? (this.type = ShopType.DEFAULT) : this.type;
        }

        public String getTitle() {
            return this.title == null ? "" : this.title;
        }

        public void removePage(int n) {
            for (int i = 0; i < this.pages.size(); ++i) {
                if (this.pages.get(i).index == n) {
                    this.pages.remove(i--);
                    n = -1;
                    continue;
                }
                if (n != -1) continue;
                this.pages.get(i).index--;
            }
        }

        public void setPermission(String string) {
            this.viewPermission = string;
            if (this.viewPermission != null && this.viewPermission.isEmpty()) {
                this.viewPermission = null;
            }
        }

        public void setShopType(ShopType shopType) {
            this.type = shopType;
        }

        public void setTitle(String string) {
            this.title = string;
        }
    }

    public static enum ShopType {
        CHEST_1X9(9, 7, 6, 8),
        CHEST_2X9(18),
        CHEST_3X9(27),
        CHEST_4X9(36),
        DEFAULT(45),
        TRADER(45);

        private final int editSlotIndex;
        private final int inventorySize;
        private final int nextSlotIndex;
        private final int prevSlotIndex;

        private ShopType(int n2) {
            this(n2, n2 - 9 + 3, n2 - 9 + 4, n2 - 9 + 5);
        }

        private ShopType(int n2, int n3, int n4, int n5) {
            this.inventorySize = n2;
            this.prevSlotIndex = n3;
            this.editSlotIndex = n4;
            this.nextSlotIndex = n5;
        }
    }

    public static class NPCTraderShopViewer
    implements Listener {
        private int lastClickedTrade = -1;
        private final Player player;
        private int selectedTrade = -1;
        private final NPCShop shop;
        private final Map<Integer, NPCShopItem> trades;
        private final InventoryView view;

        public NPCTraderShopViewer(NPCShop nPCShop, Player player) {
            this.shop = nPCShop;
            this.player = player;
            HashMap hashMap = Maps.newHashMap();
            Merchant merchant = Bukkit.createMerchant((String)nPCShop.getTitle());
            ArrayList arrayList = Lists.newArrayList();
            for (NPCShopPage nPCShopPage : nPCShop.pages) {
                for (NPCShopItem nPCShopItem : nPCShopPage.items.values()) {
                    ItemStack itemStack = nPCShopItem.getDisplayItem(player);
                    if (itemStack == null) continue;
                    MerchantRecipe merchantRecipe = new MerchantRecipe(itemStack.clone(), 100000000);
                    block2: for (NPCShopAction nPCShopAction : nPCShopItem.cost) {
                        if (!(nPCShopAction instanceof ItemAction)) continue;
                        for (ItemStack itemStack2 : ((ItemAction)nPCShopAction).items) {
                            merchantRecipe.addIngredient(itemStack2.clone());
                            if (merchantRecipe.getIngredients().size() != 2) continue;
                            continue block2;
                        }
                    }
                    if (merchantRecipe.getIngredients().size() == 0) continue;
                    hashMap.put(arrayList.size(), nPCShopItem);
                    arrayList.add(merchantRecipe);
                }
            }
            merchant.setRecipes((List)arrayList);
            this.trades = hashMap;
            this.view = player.openMerchant(merchant, true);
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
            if (!inventoryClickEvent.getView().equals((Object)this.view)) {
                return;
            }
            inventoryClickEvent.setCancelled(true);
            if (inventoryClickEvent.getSlotType() != InventoryType.SlotType.RESULT || !inventoryClickEvent.getAction().name().contains("PICKUP")) {
                return;
            }
            Inventory inventory = Bukkit.createInventory(null, (int)9);
            inventory.setItem(0, inventoryClickEvent.getClickedInventory().getItem(0));
            inventory.setItem(1, inventoryClickEvent.getClickedInventory().getItem(1));
            InventoryMultiplexer inventoryMultiplexer = new InventoryMultiplexer(new Inventory[]{this.player.getInventory(), inventory});
            this.trades.get(this.selectedTrade).onClick(this.shop, this.player, inventoryMultiplexer, inventoryClickEvent.getClick().isShiftClick(), this.lastClickedTrade == this.selectedTrade);
            inventoryClickEvent.getClickedInventory().setItem(0, inventory.getItem(0));
            inventoryClickEvent.getClickedInventory().setItem(1, inventory.getItem(1));
            this.lastClickedTrade = this.selectedTrade;
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
            if (!inventoryCloseEvent.getPlayer().equals((Object)this.player)) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
        }

        @EventHandler
        public void onTradeSelect(TradeSelectEvent tradeSelectEvent) {
            if (!tradeSelectEvent.getView().equals((Object)this.view)) {
                return;
            }
            this.selectedTrade = tradeSelectEvent.getIndex();
            this.lastClickedTrade = -1;
        }
    }

    @Menu(title="Shop", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopViewer
    extends InventoryMenuPage {
        private MenuContext ctx;
        private int currentPage = 0;
        private NPCShopItem lastClickedItem;
        private final Player player;
        private final NPCShop shop;

        public NPCShopViewer(NPCShop nPCShop, Player player) {
            this.shop = nPCShop;
            this.player = player;
        }

        public void changePage(int n) {
            Object object;
            this.currentPage = n;
            NPCShopPage nPCShopPage = (NPCShopPage)this.shop.pages.get(this.currentPage);
            if (nPCShopPage.title != null && !nPCShopPage.title.isEmpty()) {
                Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> this.ctx.setTitle(Placeholders.replace(nPCShopPage.title, (OfflinePlayer)this.player)), 1L);
            }
            for (int i = 0; i < this.ctx.getInventory().getSize(); ++i) {
                this.ctx.getSlot(i).clear();
                object = nPCShopPage.getItem(i);
                if (object == null) continue;
                this.ctx.getSlot(i).setItemStack(((NPCShopItem)object).getDisplayItem(this.player));
                this.ctx.getSlot(i).setClickHandler(arg_0 -> this.lambda$changePage$1((NPCShopItem)object, arg_0));
            }
            InventoryMenuSlot inventoryMenuSlot = this.ctx.getSlot(this.shop.getShopType().prevSlotIndex);
            object = this.ctx.getSlot(this.shop.getShopType().nextSlotIndex);
            if (this.currentPage > 0) {
                inventoryMenuSlot.clear();
                inventoryMenuSlot.setItemStack(nPCShopPage.getPreviousPageItem(this.player, this.shop.getShopType().prevSlotIndex), "Previous page (" + n + ")");
                inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> {
                    citizensInventoryClickEvent.setCancelled(true);
                    this.changePage(this.currentPage - 1);
                });
            }
            if (this.currentPage + 1 < this.shop.pages.size()) {
                ((InventoryMenuSlot)object).clear();
                ((InventoryMenuSlot)object).setItemStack(nPCShopPage.getNextPageItem(this.player, this.shop.getShopType().nextSlotIndex), "Next page (" + (n + 1) + ")");
                ((InventoryMenuSlot)object).setClickHandler(citizensInventoryClickEvent -> {
                    citizensInventoryClickEvent.setCancelled(true);
                    this.changePage(this.currentPage + 1);
                });
            }
        }

        @Override
        public Inventory createInventory(String string) {
            return Bukkit.createInventory(null, (int)this.shop.getShopType().inventorySize, (String)(this.shop.getTitle().isEmpty() ? "Shop" : Messaging.parseComponents(Placeholders.replace(this.shop.getTitle(), (OfflinePlayer)this.player))));
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            this.changePage(this.currentPage);
        }

        private /* synthetic */ void lambda$changePage$1(NPCShopItem nPCShopItem, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            nPCShopItem.onClick(this.shop, (Player)citizensInventoryClickEvent.getWhoClicked(), new InventoryMultiplexer(new Inventory[]{((Player)citizensInventoryClickEvent.getWhoClicked()).getInventory()}), citizensInventoryClickEvent.isShiftClick(), this.lastClickedItem == nPCShopItem);
            this.lastClickedItem = nPCShopItem;
        }
    }

    @Menu(title="NPC Shop Editor", type=InventoryType.CHEST, dimensions={1, 9})
    public static class NPCShopSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShop shop;
        private final ShopTrait trait;

        public NPCShopSettings(ShopTrait shopTrait, NPCShop nPCShop) {
            this.trait = shopTrait;
            this.shop = nPCShop;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            menuContext.getSlot(0).setDescription("<f>Edit permission required to view shop<br>" + this.shop.getRequiredPermission());
            menuContext.getSlot(4).setDescription("<f>Edit shop title<br>" + this.shop.getTitle());
            if (this.trait != null) {
                menuContext.getSlot(6).setDescription("<f>Show shop on right click<br>" + this.shop.getName().equals(this.trait.rightClickShop));
            }
        }

        @MenuSlot(slot={0, 2}, material=Material.FEATHER, amount=1, title="<f>Edit shop items")
        public void onEditItems(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transition(new NPCShopContentsEditor(this.shop));
        }

        @MenuSlot(slot={0, 0}, compatMaterial={"OAK_SIGN", "SIGN"}, amount=1)
        public void onPermissionChange(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(this.shop::getRequiredPermission, this.shop::setPermission));
        }

        @MenuSlot(slot={0, 8}, material=Material.CHEST, amount=1, title="<f>Set shop type")
        public void onSetInventoryType(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transition(InputMenus.picker("Set shop type", choice -> this.shop.setShopType((ShopType)((Object)((Object)choice.getValue()))), InputMenus.Choice.of(ShopType.DEFAULT, Material.CHEST, "Default (5x9 chest)", this.shop.getShopType() == ShopType.DEFAULT), InputMenus.Choice.of(ShopType.CHEST_4X9, Material.CHEST, "4x9 chest", this.shop.getShopType() == ShopType.CHEST_4X9), InputMenus.Choice.of(ShopType.CHEST_3X9, Material.CHEST, "3x9 chest", this.shop.getShopType() == ShopType.CHEST_3X9), InputMenus.Choice.of(ShopType.CHEST_2X9, Material.CHEST, "2x9 chest", this.shop.getShopType() == ShopType.CHEST_2X9), InputMenus.Choice.of(ShopType.CHEST_1X9, Material.CHEST, "1x9 chest", this.shop.getShopType() == ShopType.CHEST_1X9), InputMenus.Choice.of(ShopType.TRADER, Material.EMERALD, "Trader", this.shop.getShopType() == ShopType.TRADER)));
        }

        @MenuSlot(slot={0, 4}, material=Material.NAME_TAG, amount=1)
        public void onSetTitle(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(this.shop::getTitle, this.shop::setTitle));
        }

        @MenuSlot(slot={0, 6}, compatMaterial={"COMMAND_BLOCK", "COMMAND"}, amount=1)
        public void onToggleRightClick(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            if (this.trait == null) {
                return;
            }
            if (this.shop.getName().equals(this.trait.rightClickShop)) {
                this.trait.rightClickShop = null;
            } else {
                this.trait.rightClickShop = this.shop.name;
            }
            this.ctx.getSlot(6).setDescription("<f>Show shop on right click<br>" + this.shop.getName().equals(this.trait.rightClickShop));
        }
    }

    @Menu(title="NPC Shop Page Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopPageSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShopPage page;

        public NPCShopPageSettings(NPCShopPage nPCShopPage) {
            this.page = nPCShopPage;
        }

        @MenuSlot(slot={0, 4}, material=Material.FEATHER, amount=1)
        public void editPageTitle(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.page.title, string -> this.page.title = string.isEmpty() ? null : string));
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            menuContext.getSlot(4).setDescription("Set page title<br>Currently: " + this.page.title);
        }

        @MenuSlot(slot={4, 4}, material=Material.TNT, amount=1, title="<c>Remove page")
        public void removePage(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.data().put("removePage", this.page.index);
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopPage {
        @Persist(value="$key")
        private int index;
        @Persist(keyType=Integer.class, reify=true)
        private final Map<Integer, NPCShopItem> items = Maps.newHashMap();
        @Persist
        private String title;

        private NPCShopPage() {
        }

        public NPCShopPage(int n) {
            this.index = n;
        }

        public NPCShopItem getItem(int n) {
            return this.items.get(n);
        }

        public ItemStack getNextPageItem(Player player, int n) {
            return this.items.containsKey(n) ? this.items.get(n).getDisplayItem(player) : new ItemStack(Material.FEATHER, 1);
        }

        public ItemStack getPreviousPageItem(Player player, int n) {
            return this.items.containsKey(n) ? this.items.get(n).getDisplayItem(player) : new ItemStack(Material.FEATHER, 1);
        }

        public void removeItem(int n) {
            this.items.remove(n);
        }

        public void setItem(int n, NPCShopItem nPCShopItem) {
            this.items.put(n, nPCShopItem);
        }
    }

    @Menu(title="NPC Shop Item Editor", type=InventoryType.CHEST, dimensions={6, 9})
    public static class NPCShopItemEditor
    extends InventoryMenuPage {
        @MenuPattern(offset={0, 6}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="xxx\nxxx\nxxx")
        private InventoryMenuPattern actionItems;
        private NPCShopItem base;
        private final Consumer<NPCShopItem> callback;
        @MenuPattern(offset={0, 0}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="xxx\nxxx\nxxx")
        private InventoryMenuPattern costItems;
        private MenuContext ctx;
        private final NPCShopItem modified;

        public NPCShopItemEditor(NPCShopItem nPCShopItem, Consumer<NPCShopItem> consumer) {
            this.base = nPCShopItem;
            this.modified = this.base.clone();
            this.callback = consumer;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            if (this.modified.display != null) {
                menuContext.getSlot(40).setItemStack(this.modified.getDisplayItem(null));
            }
            menuContext.getSlot(29).setItemStack(new ItemStack(Material.EGG), "Only purchasable once per player", "Times purchasable: " + this.modified.timesPurchasable + (this.modified.timesPurchasable == 0 ? " (no limit)" : ""));
            menuContext.getSlot(29).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> String.valueOf(this.modified.timesPurchasable), string -> {
                this.modified.timesPurchasable = Integer.parseInt(string);
                menuContext.getSlot(38).setDescription("Times purchasable: " + this.modified.timesPurchasable + (this.modified.timesPurchasable == 0 ? " (no limit)" : ""));
            })));
            menuContext.getSlot(38).setItemStack(new ItemStack(Util.getFallbackMaterial("OAK_SIGN", "SIGN")), "Set already purchased message, currently:\n", this.modified.alreadyPurchasedMessage == null ? "Unset" : this.modified.alreadyPurchasedMessage);
            menuContext.getSlot(38).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> this.modified.alreadyPurchasedMessage, string -> {
                this.modified.alreadyPurchasedMessage = string;
                menuContext.getSlot(38).setDescription(this.modified.alreadyPurchasedMessage);
            })));
            menuContext.getSlot(30).setItemStack(new ItemStack(Util.getFallbackMaterial("GREEN_WOOL", "EMERALD", "OAK_SIGN", "SIGN")), "Set successful click message, currently:\n", this.modified.resultMessage == null ? "Unset" : this.modified.resultMessage);
            menuContext.getSlot(30).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> this.modified.resultMessage, string -> {
                this.modified.resultMessage = string;
                menuContext.getSlot(30).setDescription(this.modified.resultMessage);
            })));
            menuContext.getSlot(33).setItemStack(new ItemStack(Util.getFallbackMaterial("RED_WOOL", "OAK_SIGN", "SIGN")), "Set unsuccessful click message, currently:\n", this.modified.costMessage == null ? "Unset" : this.modified.costMessage);
            menuContext.getSlot(33).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> this.modified.costMessage, string -> {
                this.modified.costMessage = string;
                menuContext.getSlot(33).setDescription(this.modified.costMessage);
            })));
            menuContext.getSlot(32).setItemStack(new ItemStack(Util.getFallbackMaterial("FEATHER", "OAK_SIGN", "SIGN")), "Set click to confirm message.", "For example, 'click again to buy this item'\nYou can use <cost> or <result> placeholders.\nCurrently:\n" + (this.modified.clickToConfirmMessage == null ? "Unset" : this.modified.clickToConfirmMessage));
            menuContext.getSlot(32).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> this.modified.clickToConfirmMessage, string -> {
                this.modified.clickToConfirmMessage = string;
                menuContext.getSlot(32).setDescription(this.modified.clickToConfirmMessage);
            })));
            menuContext.getSlot(31).setItemStack(new ItemStack(Material.REDSTONE), "Sell as many times as possible on shift click\n", "Currently: " + this.modified.maxRepeatsOnShiftClick);
            menuContext.getSlot(31).setClickHandler(InputMenus.toggler(bl -> this.modified.maxRepeatsOnShiftClick = bl, this.modified.maxRepeatsOnShiftClick));
            int n = 0;
            for (NPCShopAction.GUI gUI : NPCShopAction.getGUIs()) {
                if (gUI.createMenuItem(null) == null) continue;
                NPCShopAction nPCShopAction = this.modified.cost.stream().filter(gUI::manages).findFirst().orElse(null);
                this.costItems.getSlots().get(n).setItemStack(Util.editTitle(gUI.createMenuItem(nPCShopAction), string -> string + " Cost"));
                this.costItems.getSlots().get(n).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(gUI.createEditor(nPCShopAction, nPCShopAction -> this.modified.changeCost(gUI::manages, (NPCShopAction)nPCShopAction))));
                NPCShopAction nPCShopAction2 = this.modified.result.stream().filter(gUI::manages).findFirst().orElse(null);
                this.actionItems.getSlots().get(n).setItemStack(Util.editTitle(gUI.createMenuItem(nPCShopAction2), string -> string + " Result"));
                this.actionItems.getSlots().get(n).setClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(gUI.createEditor(nPCShopAction2, nPCShopAction -> this.modified.changeResult(gUI::manages, (NPCShopAction)nPCShopAction))));
                ++n;
            }
        }

        @MenuSlot(slot={5, 3}, material=Material.REDSTONE_BLOCK, amount=1, title="<7>Cancel")
        public void onCancel(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.ctx.getMenu().transitionBack();
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            if (this.base != null && this.base.display == null) {
                this.base = null;
            }
            this.callback.accept(this.base);
        }

        @MenuSlot(slot={4, 5}, material=Material.BOOK, amount=1, title="<f>Set description")
        public void onEditDescription(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.modified.display.getItemMeta().hasLore() ? Joiner.on((String)"<br>").skipNulls().join((Iterable)this.modified.display.getItemMeta().getLore()) : "", string -> {
                ItemMeta itemMeta = this.modified.display.getItemMeta();
                itemMeta.setLore((List)Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)Messaging.parseComponents(string))));
                this.modified.display.setItemMeta(itemMeta);
            }));
        }

        @MenuSlot(slot={4, 3}, material=Material.NAME_TAG, amount=1, title="<f>Set name")
        public void onEditName(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> ((ItemMeta)this.modified.display.getItemMeta()).getDisplayName(), string -> {
                ItemMeta itemMeta = this.modified.display.getItemMeta();
                itemMeta.setDisplayName(ChatColor.RESET + Messaging.parseComponents(string));
                this.modified.display.setItemMeta(itemMeta);
            }));
        }

        @ClickHandler(slot={4, 4})
        public void onModifyDisplayItem(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            citizensInventoryClickEvent.setCancelled(true);
            if (citizensInventoryClickEvent.getCursor() != null) {
                citizensInventoryClickEvent.setCurrentItem(citizensInventoryClickEvent.getCursor());
                this.modified.display = citizensInventoryClickEvent.getCursor().clone();
            } else {
                citizensInventoryClickEvent.setCurrentItem(null);
                this.modified.display = null;
            }
        }

        @MenuSlot(slot={5, 4}, material=Material.TNT, amount=1, title="<c>Remove")
        public void onRemove(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.base = null;
            this.ctx.getMenu().transitionBack();
        }

        @MenuSlot(slot={5, 5}, material=Material.EMERALD_BLOCK, amount=1, title="<a>Save")
        public void onSave(InventoryMenuSlot inventoryMenuSlot, CitizensInventoryClickEvent citizensInventoryClickEvent) {
            this.base = this.modified;
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopItem
    implements Cloneable,
    Persistable {
        @Persist
        private String alreadyPurchasedMessage;
        @Persist
        private String clickToConfirmMessage;
        @Persist
        private final List<NPCShopAction> cost = Lists.newArrayList();
        @Persist
        private String costMessage;
        @Persist
        private ItemStack display;
        @Persist
        private boolean maxRepeatsOnShiftClick;
        @Persist(keyType=UUID.class)
        private final Map<UUID, Integer> purchases = Maps.newHashMap();
        @Persist
        private final List<NPCShopAction> result = Lists.newArrayList();
        @Persist
        private String resultMessage;
        @Persist
        private int timesPurchasable = 0;
        private static Pattern PLACEHOLDER_REGEX = Pattern.compile("<(cost|result)>", 2);

        public List<NPCShopAction.Transaction> apply(List<NPCShopAction> list, Function<NPCShopAction, NPCShopAction.Transaction> function) {
            ArrayList arrayList = Lists.newArrayList();
            for (NPCShopAction nPCShopAction : list) {
                NPCShopAction.Transaction transaction = function.apply(nPCShopAction);
                if (!transaction.isPossible()) {
                    arrayList.forEach(NPCShopAction.Transaction::rollback);
                    return null;
                }
                transaction.run();
                arrayList.add(transaction);
            }
            return arrayList;
        }

        private void changeAction(List<NPCShopAction> list, Function<NPCShopAction, Boolean> function, NPCShopAction nPCShopAction) {
            for (int i = 0; i < list.size(); ++i) {
                if (!function.apply(list.get(i)).booleanValue()) continue;
                if (nPCShopAction == null) {
                    list.remove(i);
                } else {
                    list.set(i, nPCShopAction);
                }
                return;
            }
            if (nPCShopAction != null) {
                list.add(nPCShopAction);
            }
        }

        public void changeCost(Function<NPCShopAction, Boolean> function, NPCShopAction nPCShopAction) {
            this.changeAction(this.cost, function, nPCShopAction);
        }

        public void changeResult(Function<NPCShopAction, Boolean> function, NPCShopAction nPCShopAction) {
            this.changeAction(this.result, function, nPCShopAction);
        }

        public NPCShopItem clone() {
            try {
                return (NPCShopItem)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error(cloneNotSupportedException);
            }
        }

        public ItemStack getDisplayItem(Player player) {
            if (this.display == null) {
                return null;
            }
            ItemStack itemStack = this.display.clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasDisplayName()) {
                itemMeta.setDisplayName(this.placeholders(itemMeta.getDisplayName(), player));
            }
            if (!itemMeta.hasLore()) {
                ArrayList arrayList = Lists.newArrayList();
                this.cost.forEach(nPCShopAction -> arrayList.add(nPCShopAction.describe()));
                this.result.forEach(nPCShopAction -> {
                    if (!(nPCShopAction instanceof CommandAction)) {
                        arrayList.add(nPCShopAction.describe());
                    }
                });
                if (this.timesPurchasable > 0) {
                    arrayList.add("Times purchasable: " + this.timesPurchasable);
                }
                itemMeta.setLore((List)arrayList);
            }
            if (itemMeta.hasLore()) {
                itemMeta.setLore(Lists.transform((List)itemMeta.getLore(), string -> this.placeholders((String)string, player)));
            }
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }

        @Override
        public void load(DataKey dataKey) {
            if (dataKey.keyExists("message")) {
                this.resultMessage = dataKey.getString("message");
                dataKey.removeKey("message");
            }
            if (dataKey.keyExists("clickMessage")) {
                this.resultMessage = dataKey.getString("clickMessage");
                dataKey.removeKey("clickMessage");
            }
        }

        public void onClick(NPCShop nPCShop, Player player, InventoryMultiplexer inventoryMultiplexer, boolean bl, boolean bl2) {
            int n;
            List<NPCShopAction.Transaction> list;
            if (this.timesPurchasable > 0 && this.purchases.getOrDefault(player.getUniqueId(), 0) == this.timesPurchasable) {
                if (this.alreadyPurchasedMessage != null) {
                    Messaging.sendColorless((CommandSender)player, this.placeholders(this.alreadyPurchasedMessage, player));
                }
                return;
            }
            if (this.clickToConfirmMessage != null && !bl2) {
                Messaging.sendColorless((CommandSender)player, this.placeholders(this.clickToConfirmMessage, player));
                return;
            }
            int n2 = Integer.MAX_VALUE;
            if (this.maxRepeatsOnShiftClick && bl) {
                for (NPCShopAction object2 : this.cost) {
                    int n3 = object2.getMaxRepeats((Entity)player, inventoryMultiplexer);
                    if (n3 == -1) continue;
                    n2 = Math.min(n2, n3);
                }
                if (n2 == 0) {
                    return;
                }
            }
            if ((list = this.apply(this.cost, arg_0 -> NPCShopItem.lambda$onClick$3(player, inventoryMultiplexer, n = n2 == Integer.MAX_VALUE ? 1 : n2, arg_0))) == null) {
                if (this.costMessage != null) {
                    Messaging.sendColorless((CommandSender)player, this.placeholders(this.costMessage, player));
                }
                return;
            }
            if (this.apply(this.result, nPCShopAction -> nPCShopAction.grant((Entity)player, inventoryMultiplexer, n)) == null) {
                list.forEach(NPCShopAction.Transaction::rollback);
                return;
            }
            if (this.resultMessage != null) {
                Messaging.sendColorless((CommandSender)player, this.placeholders(this.resultMessage, player));
            }
            if (this.timesPurchasable > 0) {
                this.purchases.put(player.getUniqueId(), this.purchases.getOrDefault(player.getUniqueId(), 0) + 1);
            }
        }

        private String placeholders(String string, Player player) {
            string = Placeholders.replace(string, (OfflinePlayer)player);
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = PLACEHOLDER_REGEX.matcher(string);
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, Joiner.on((String)", ").join(Iterables.transform(matcher.group(1).equalsIgnoreCase("cost") ? this.cost : this.result, NPCShopAction::describe)).replace("$", "\\$").replace("{", "\\{"));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        @Override
        public void save(DataKey dataKey) {
        }

        private static /* synthetic */ NPCShopAction.Transaction lambda$onClick$3(Player player, InventoryMultiplexer inventoryMultiplexer, int n, NPCShopAction nPCShopAction) {
            return nPCShopAction.take((Entity)player, inventoryMultiplexer, n);
        }
    }

    @Menu(title="NPC Shop Contents Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopContentsEditor
    extends InventoryMenuPage {
        private NPCShopItem copying;
        private MenuContext ctx;
        private int page = 0;
        private final NPCShop shop;

        public NPCShopContentsEditor(NPCShop nPCShop) {
            this.shop = nPCShop;
        }

        public void changePage(int n) {
            Consumer<CitizensInventoryClickEvent> consumer;
            InventoryMenuSlot inventoryMenuSlot;
            this.page = n;
            this.ctx.setTitle("NPC Shop Contents Editor (" + (n + 1) + "/" + (this.shop.pages.size() + 1) + ")");
            NPCShopPage nPCShopPage = this.shop.getOrCreatePage(this.page);
            int n2 = 0;
            while (n2 < this.ctx.getInventory().getSize()) {
                inventoryMenuSlot = this.ctx.getSlot(n2);
                inventoryMenuSlot.clear();
                if (nPCShopPage.getItem(n2) != null) {
                    inventoryMenuSlot.setItemStack(nPCShopPage.getItem(n2).getDisplayItem(null));
                }
                int n3 = n2++;
                inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> {
                    NPCShopItem nPCShopItem2 = nPCShopPage.getItem(n3);
                    if (nPCShopItem2 != null && citizensInventoryClickEvent.isShiftClick() && citizensInventoryClickEvent.getCursorNonNull().getType() == Material.AIR && nPCShopItem2.display != null) {
                        this.copying = nPCShopItem2.clone();
                        citizensInventoryClickEvent.setCursor(nPCShopItem2.getDisplayItem(null));
                        citizensInventoryClickEvent.setCancelled(true);
                        return;
                    }
                    if (nPCShopItem2 == null) {
                        if (this.copying != null && citizensInventoryClickEvent.getCursorNonNull().getType() != Material.AIR && citizensInventoryClickEvent.getCursorNonNull().equals((Object)this.copying.getDisplayItem(null))) {
                            nPCShopPage.setItem(n3, this.copying);
                            this.copying = null;
                            return;
                        }
                        nPCShopItem2 = new NPCShopItem();
                        if (citizensInventoryClickEvent.getCursor() != null) {
                            nPCShopItem2.display = citizensInventoryClickEvent.getCursor().clone();
                        }
                    }
                    this.ctx.clearSlots();
                    this.ctx.getMenu().transition(new NPCShopItemEditor(nPCShopItem2, nPCShopItem -> {
                        if (nPCShopItem == null) {
                            nPCShopPage.removeItem(n3);
                        } else {
                            nPCShopPage.setItem(n3, (NPCShopItem)nPCShopItem);
                        }
                    }));
                });
            }
            InventoryMenuSlot inventoryMenuSlot2 = this.ctx.getSlot(this.shop.getShopType().prevSlotIndex);
            inventoryMenuSlot = this.ctx.getSlot(this.shop.getShopType().editSlotIndex);
            InventoryMenuSlot inventoryMenuSlot3 = this.ctx.getSlot(this.shop.getShopType().nextSlotIndex);
            if (this.page > 0) {
                inventoryMenuSlot2.setItemStack(nPCShopPage.getNextPageItem(null, this.shop.getShopType().prevSlotIndex), "Previous page (" + n + ")");
                consumer = inventoryMenuSlot2.getClickHandlers().get(0);
                inventoryMenuSlot2.setClickHandler(citizensInventoryClickEvent -> {
                    if (citizensInventoryClickEvent.isShiftClick()) {
                        consumer.accept((CitizensInventoryClickEvent)((Object)citizensInventoryClickEvent));
                        return;
                    }
                    citizensInventoryClickEvent.setCancelled(true);
                    this.changePage(this.page - 1);
                });
            }
            inventoryMenuSlot3.setItemStack(nPCShopPage.getNextPageItem(null, this.shop.getShopType().nextSlotIndex), this.page + 1 >= this.shop.pages.size() ? "New page" : "Next page (" + (n + 1) + ")");
            consumer = inventoryMenuSlot3.getClickHandlers().get(0);
            inventoryMenuSlot3.setClickHandler(citizensInventoryClickEvent -> {
                if (citizensInventoryClickEvent.isShiftClick()) {
                    consumer.accept((CitizensInventoryClickEvent)((Object)citizensInventoryClickEvent));
                    return;
                }
                citizensInventoryClickEvent.setCancelled(true);
                this.changePage(this.page + 1);
            });
            Consumer<CitizensInventoryClickEvent> consumer2 = inventoryMenuSlot.getClickHandlers().get(0);
            inventoryMenuSlot.setItemStack(new ItemStack(Material.BOOK), "Edit page");
            inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> {
                if (citizensInventoryClickEvent.isShiftClick()) {
                    consumer2.accept((CitizensInventoryClickEvent)((Object)citizensInventoryClickEvent));
                    return;
                }
                this.ctx.getMenu().transition(new NPCShopPageSettings(this.shop.getOrCreatePage(this.page)));
            });
        }

        @Override
        public Inventory createInventory(String string) {
            return Bukkit.createInventory(null, (int)this.shop.getShopType().inventorySize, (String)"NPC Shop Contents Editor");
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            if (menuContext.data().containsKey("removePage")) {
                int n = (Integer)menuContext.data().remove("removePage");
                this.shop.removePage(n);
                this.page = Math.max(this.page - 1, 0);
            }
            this.changePage(this.page);
        }
    }
}

