/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sittable;
import org.bukkit.event.player.PlayerTeleportEvent;

@TraitName(value="sittrait")
public class SitTrait
extends Trait {
    private NPC chair;
    private int delay;
    @Persist
    private Location sittingAt;
    private static boolean SUPPORT_SITTABLE = true;

    public SitTrait() {
        super("sittrait");
    }

    public boolean isSitting() {
        return this.sittingAt != null;
    }

    @Override
    public void onDespawn() {
        if (SUPPORT_SITTABLE && this.npc.getEntity() instanceof Sittable) {
            ((Sittable)this.npc.getEntity()).setSitting(false);
            return;
        }
        if (this.chair != null) {
            if (this.chair.getEntity() != null) {
                this.chair.getEntity().eject();
                Location location = this.npc.getEntity().getLocation().clone();
                if (this.requiresPassengerOffsetCorrection()) {
                    location = location.add(0.0, 0.3, 0.0);
                }
                this.npc.getEntity().teleport(location);
            }
            this.chair.destroy();
            this.chair = null;
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    private boolean requiresPassengerOffsetCorrection() {
        return SpigotUtil.getVersion() != null && SpigotUtil.getVersion().length >= 2 && SpigotUtil.getVersion()[1] <= 19;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.isSitting() || this.delay-- > 0) {
            return;
        }
        if (SUPPORT_SITTABLE && this.npc.getEntity() instanceof Sittable) {
            ((Sittable)this.npc.getEntity()).setSitting(true);
            if (this.npc.getEntity().getLocation().distance(this.sittingAt) >= 0.03) {
                this.npc.teleport(this.sittingAt, PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            return;
        }
        if (this.chair == null) {
            NPCRegistry nPCRegistry = CitizensAPI.getNamedNPCRegistry("SitRegistry");
            if (nPCRegistry == null) {
                nPCRegistry = CitizensAPI.createNamedNPCRegistry("SitRegistry", new MemoryNPCDataStore());
            }
            this.chair = nPCRegistry.createNPC(EntityType.ARMOR_STAND, "");
            this.chair.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntity(this.npc);
            if (!this.chair.spawn(this.sittingAt.clone())) {
                this.chair = null;
                this.delay = 20;
                Messaging.debug("Unable to spawn chair NPC");
                return;
            }
        }
        if (this.chair.isSpawned() && !NMS.getPassengers(this.chair.getEntity()).contains(this.npc.getEntity())) {
            NMS.mount(this.chair.getEntity(), this.npc.getEntity());
        }
        if (this.chair.getStoredLocation() != null && this.chair.getStoredLocation().distance(this.sittingAt) >= 0.03) {
            this.chair.teleport(this.sittingAt.clone(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    public void setSitting(Location location) {
        Location location2 = this.sittingAt = location != null ? location.clone() : null;
        if (this.requiresPassengerOffsetCorrection()) {
            this.sittingAt = this.sittingAt.add(0.0, 0.3, 0.0);
        }
        if (location == null) {
            this.onDespawn();
        }
    }

    static {
        try {
            Class.forName("org.bukkit.entity.Sittable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            SUPPORT_SITTABLE = false;
        }
    }
}

