/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.SheepDyeWoolEvent;

@TraitName(value="woolcolor")
public class WoolColor
extends Trait {
    private DyeColor color = DyeColor.WHITE;
    boolean sheep = false;

    public WoolColor() {
        super("woolcolor");
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void load(DataKey dataKey) {
        try {
            this.color = DyeColor.valueOf((String)dataKey.getString(""));
        }
        catch (Exception exception) {
            this.color = DyeColor.WHITE;
        }
    }

    @EventHandler
    private void onSheepDyeWool(SheepDyeWoolEvent sheepDyeWoolEvent) {
        if (this.npc.equals(CitizensAPI.getNPCRegistry().getNPC((Entity)sheepDyeWoolEvent.getEntity()))) {
            sheepDyeWoolEvent.setCancelled(true);
        }
    }

    @Override
    public void onSpawn() {
        if (this.npc.getEntity() instanceof Sheep) {
            ((Sheep)this.npc.getEntity()).setColor(this.color);
            this.sheep = true;
        } else {
            this.sheep = false;
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.setString("", this.color.name());
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.sheep) {
            ((Sheep)this.npc.getEntity()).setColor(dyeColor);
        }
    }

    public String toString() {
        return "WoolColor{" + this.color.name() + "}";
    }
}

