/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PermissionAction
extends NPCShopAction {
    @Persist
    public List<String> permissions = Lists.newArrayList();

    public PermissionAction() {
    }

    public PermissionAction(List<String> list) {
        this.permissions = list;
    }

    @Override
    public String describe() {
        String string = this.permissions.size() + " permissions";
        for (int i = 0; i < this.permissions.size(); ++i) {
            string = string + "\n" + this.permissions.get(i);
            if (i != 3) continue;
            string = string + "...";
            break;
        }
        return string;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventoryMultiplexer) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        Permission permission = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (String string : this.permissions) {
                permission.playerAdd(null, (OfflinePlayer)player, Placeholders.replace(string, (OfflinePlayer)player));
            }
        }, () -> {
            for (String string : this.permissions) {
                permission.playerRemove(null, (OfflinePlayer)player, Placeholders.replace(string, (OfflinePlayer)player));
            }
        });
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        Permission permission = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
        return NPCShopAction.Transaction.create(() -> {
            for (String string : this.permissions) {
                if (permission.playerHas(player, Placeholders.replace(string, (OfflinePlayer)player))) continue;
                return false;
            }
            return true;
        }, () -> {
            for (String string : this.permissions) {
                permission.playerRemove(null, (OfflinePlayer)player, Placeholders.replace(string, (OfflinePlayer)player));
            }
        }, () -> {
            for (String string : this.permissions) {
                permission.playerAdd(null, (OfflinePlayer)player, Placeholders.replace(string, (OfflinePlayer)player));
            }
        });
    }

    public static class PermissionActionGUI
    implements NPCShopAction.GUI {
        private Boolean supported;

        @Override
        public InventoryMenuPage createEditor(NPCShopAction nPCShopAction, Consumer<NPCShopAction> consumer) {
            return new PermissionActionEditor(nPCShopAction == null ? new PermissionAction() : (PermissionAction)nPCShopAction, consumer);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction nPCShopAction) {
            if (this.supported == null) {
                try {
                    this.supported = Bukkit.getServicesManager().getRegistration(Permission.class).getProvider() != null;
                }
                catch (Throwable throwable) {
                    this.supported = false;
                }
            }
            if (!this.supported.booleanValue()) {
                return null;
            }
            String string = null;
            if (nPCShopAction != null) {
                PermissionAction permissionAction = (PermissionAction)nPCShopAction;
                string = permissionAction.describe();
            }
            return Util.createItem(Material.PAPER, "Permission", string);
        }

        @Override
        public boolean manages(NPCShopAction nPCShopAction) {
            return nPCShopAction instanceof PermissionAction;
        }
    }

    @Menu(title="Permissions editor", dimensions={3, 9})
    public static class PermissionActionEditor
    extends InventoryMenuPage {
        private PermissionAction base;
        private Consumer<NPCShopAction> callback;

        public PermissionActionEditor() {
        }

        public PermissionActionEditor(PermissionAction permissionAction, Consumer<NPCShopAction> consumer) {
            this.base = permissionAction;
            this.callback = consumer;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            for (int i = 0; i < 27; ++i) {
                int n = i;
                menuContext.getSlot(i).clear();
                if (i < this.base.permissions.size()) {
                    menuContext.getSlot(i).setItemStack(new ItemStack(Material.FEATHER), "<f>Set permission", "Right click to remove\nCurrently: " + this.base.permissions.get(i));
                }
                menuContext.getSlot(i).setClickHandler(citizensInventoryClickEvent -> {
                    if (citizensInventoryClickEvent.isRightClick()) {
                        citizensInventoryClickEvent.setCancelled(true);
                        if (n < this.base.permissions.size()) {
                            this.base.permissions.remove(n);
                            menuContext.getSlot(n).setItemStack(null);
                        }
                        return;
                    }
                    menuContext.getMenu().transition(InputMenus.stringSetter(() -> n < this.base.permissions.size() ? this.base.permissions.get(n) : "", string -> {
                        if (string == null) {
                            if (n < this.base.permissions.size()) {
                                this.base.permissions.remove(n);
                            }
                            return;
                        }
                        if (n < this.base.permissions.size()) {
                            this.base.permissions.set(n, (String)string);
                        } else {
                            this.base.permissions.add((String)string);
                        }
                    }));
                });
            }
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            this.callback.accept(this.base.permissions.isEmpty() ? null : this.base);
        }
    }
}

