/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;

@TraitName(value="axolotltrait")
public class AxolotlTrait
extends Trait {
    @Persist
    private boolean playingDead = false;
    @Persist
    private Axolotl.Variant variant = null;

    public AxolotlTrait() {
        super("axolotltrait");
    }

    public Axolotl.Variant getVariant() {
        return this.variant;
    }

    public boolean isPlayingDead() {
        return this.playingDead;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)this.npc.getEntity();
            if (this.variant != null) {
                axolotl.setVariant(this.variant);
            }
            axolotl.setPlayingDead(this.playingDead);
        }
    }

    public void setPlayingDead(boolean bl) {
        this.playingDead = bl;
    }

    public void setVariant(Axolotl.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="axolotl (-d) (--variant variant)", desc="", modifiers={"axolotl"}, min=1, max=1, flags="d", permission="citizens.npc.axolotl")
    @Requirements(selected=true, ownership=true, types={EntityType.AXOLOTL})
    public static void axolotl(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"variant"}) Axolotl.Variant variant) {
        AxolotlTrait axolotlTrait = nPC.getOrAddTrait(AxolotlTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.axolotl.invalid-variant", Util.listValuesPretty(Axolotl.Variant.values()));
            }
            axolotlTrait.setVariant(variant);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.axolotl.variant-set", commandContext.getFlag("variant"));
        }
        if (commandContext.hasFlag('d')) {
            axolotlTrait.setPlayingDead(!axolotlTrait.isPlayingDead());
            string = string + ' ' + (axolotlTrait.isPlayingDead() ? Messaging.tr("citizens.commands.npc.axolotl.playing-dead", nPC.getName()) : Messaging.tr("citizens.commands.npc.axolotl.playing-dead-stopped", nPC.getName()));
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

