/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;

@TraitName(value="beetrait")
public class BeeTrait
extends Trait {
    @Persist
    private int anger;
    @Persist
    private boolean nectar = false;
    @Persist
    private boolean stung = false;

    public BeeTrait() {
        super("beetrait");
    }

    public boolean hasNectar() {
        return this.nectar;
    }

    public boolean hasStung() {
        return this.stung;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Bee) {
            Bee bee = (Bee)this.npc.getEntity();
            bee.setHasStung(this.stung);
            bee.setAnger(this.anger);
            bee.setHasNectar(this.nectar);
        }
    }

    public void setAnger(int n) {
        this.anger = n;
    }

    public void setNectar(boolean bl) {
        this.nectar = bl;
    }

    public void setStung(boolean bl) {
        this.stung = bl;
    }

    @Command(aliases={"npc"}, usage="bee (-s/-n) --anger anger", desc="", modifiers={"bee"}, min=1, max=1, flags="sn", permission="citizens.npc.bee")
    @Requirements(selected=true, ownership=true, types={EntityType.BEE})
    public static void bee(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"anger"}) Integer n) {
        BeeTrait beeTrait = nPC.getOrAddTrait(BeeTrait.class);
        String string = "";
        if (n != null) {
            if (n < 0) {
                throw new CommandException("citizens.commands.npc.bee.invalid-anger");
            }
            beeTrait.setAnger(n);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.bee.anger-set", commandContext.getFlag("anger"));
        }
        if (commandContext.hasFlag('s')) {
            beeTrait.setStung(!beeTrait.hasStung());
            string = string + ' ' + (beeTrait.hasStung() ? Messaging.tr("citizens.commands.npc.bee.bee-stung", nPC.getName()) : Messaging.tr("citizens.commands.npc.bee.not-stung", nPC.getName()));
        }
        if (commandContext.hasFlag('n')) {
            beeTrait.setNectar(!beeTrait.hasNectar());
            string = string + ' ' + (beeTrait.hasNectar() ? Messaging.tr("citizens.commands.npc.bee.has-nectar", nPC.getName()) : Messaging.tr("citizens.commands.npc.bee.no-nectar", nPC.getName()));
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

