/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;

@TraitName(value="cattrait")
public class CatTrait
extends Trait {
    @Persist
    private DyeColor collarColor = null;
    @Persist
    private boolean lying = false;
    @Persist
    private boolean sitting = false;
    @Persist
    private Cat.Type type = Cat.Type.BLACK;

    public CatTrait() {
        super("cattrait");
    }

    public boolean isLyingDown() {
        return this.lying;
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)this.npc.getEntity();
        cat.setSitting(this.sitting);
        cat.setCatType(this.type);
        if (this.collarColor != null) {
            cat.setCollarColor(this.collarColor);
        }
        NMS.setLyingDown((Entity)cat, this.lying);
    }

    public void setCollarColor(DyeColor dyeColor) {
        this.collarColor = dyeColor;
    }

    public void setLyingDown(boolean bl) {
        this.lying = bl;
    }

    public void setSitting(boolean bl) {
        this.sitting = bl;
    }

    public void setType(Cat.Type type) {
        if (type == null) {
            type = Cat.Type.BLACK;
        }
        this.type = type;
    }

    public void setType(Ocelot.Type type) {
        if (type == null) {
            this.type = Cat.Type.BLACK;
            return;
        }
        switch (type) {
            case WILD_OCELOT: {
                this.type = Cat.Type.CALICO;
                break;
            }
            case BLACK_CAT: {
                this.type = Cat.Type.BLACK;
                break;
            }
            case RED_CAT: {
                this.type = Cat.Type.RED;
                break;
            }
            case SIAMESE_CAT: {
                this.type = Cat.Type.SIAMESE;
            }
        }
    }

    @Command(aliases={"npc"}, usage="cat (-s/-n/-l) --type type --ccolor collar color", desc="", modifiers={"cat"}, min=1, max=1, flags="snl", permission="citizens.npc.cat")
    @Requirements(selected=true, ownership=true, types={EntityType.CAT})
    public static void cat(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"ccolor"}) DyeColor dyeColor, @Flag(value={"type"}) Cat.Type type) {
        CatTrait catTrait = nPC.getOrAddTrait(CatTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-type", Util.listValuesPretty(Cat.Type.values()));
            }
            catTrait.setType(type);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.cat.type-set", commandContext.getFlag("type"));
        }
        if (commandContext.hasValueFlag("ccolor")) {
            if (dyeColor == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-collar-color", Util.listValuesPretty(DyeColor.values()));
            }
            catTrait.setCollarColor(dyeColor);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.cat.collar-color-set", commandContext.getFlag("ccolor"));
        }
        if (commandContext.hasFlag('s')) {
            catTrait.setSitting(true);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.cat.sitting-start", nPC.getName());
        } else if (commandContext.hasFlag('n')) {
            catTrait.setSitting(false);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.cat.sitting-stop", nPC.getName());
        }
        if (commandContext.hasFlag('l')) {
            catTrait.setLyingDown(!catTrait.isLyingDown());
            string = string + ' ' + Messaging.tr(catTrait.isLyingDown() ? "citizens.commands.npc.cat.lying-start" : "citizens.commands.npc.cat.lying-stop", nPC.getName());
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

