/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;

@TraitName(value="enderdragontrait")
public class EnderDragonTrait
extends Trait {
    @Persist
    private boolean destroyWalls;
    @Persist
    private EnderDragon.Phase phase;

    public EnderDragonTrait() {
        super("enderdragontrait");
    }

    public EnderDragon.Phase getPhase() {
        return this.phase;
    }

    public boolean isDestroyWalls() {
        return this.destroyWalls;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setDestroyWalls(boolean bl) {
        this.destroyWalls = bl;
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.phase = phase;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (!(this.npc.getEntity() instanceof EnderDragon)) {
            return;
        }
        EnderDragon enderDragon = (EnderDragon)this.npc.getEntity();
        if (this.phase != null) {
            enderDragon.setPhase(this.phase);
        }
    }

    @Command(aliases={"npc"}, usage="enderdragon --phase [phase] --destroywalls [true|false]", desc="", modifiers={"enderdragon"}, min=1, max=1, permission="citizens.npc.enderdragon")
    @Requirements(ownership=true, selected=true, types={EntityType.ENDER_DRAGON})
    public static void enderdragon(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"phase"}) EnderDragon.Phase phase, @Flag(value={"destroywalls"}) Boolean bl) {
        EnderDragonTrait enderDragonTrait = nPC.getOrAddTrait(EnderDragonTrait.class);
        if (phase != null) {
            enderDragonTrait.setPhase(phase);
        }
        if (bl != null) {
            enderDragonTrait.setDestroyWalls(bl);
        }
    }
}

