/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;

@TraitName(value="pandatrait")
public class PandaTrait
extends Trait {
    @Persist
    private boolean eating;
    @Persist
    private Panda.Gene hiddenGene;
    @Persist
    private Panda.Gene mainGene = Panda.Gene.NORMAL;
    @Persist
    private boolean rolling;
    @Persist
    private boolean sitting;
    @Persist
    private boolean sneezing;
    private static boolean SUPPORT_ROLLING_SNEEZING = true;

    public PandaTrait() {
        super("pandatrait");
    }

    public Panda.Gene getHiddenGene() {
        return this.hiddenGene;
    }

    public Panda.Gene getMainGene() {
        return this.mainGene;
    }

    public boolean isEating() {
        return this.eating;
    }

    public boolean isRolling() {
        return this.rolling;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isSneezing() {
        return this.sneezing;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Panda) {
            Panda panda = (Panda)this.npc.getEntity();
            panda.setMainGene(this.mainGene);
            NMS.setPandaSitting(this.npc.getEntity(), this.sitting);
            if (SUPPORT_ROLLING_SNEEZING) {
                try {
                    panda.setRolling(this.rolling);
                    panda.setSneezing(this.sneezing);
                    panda.setEating(this.eating);
                }
                catch (Throwable throwable) {
                    SUPPORT_ROLLING_SNEEZING = false;
                }
            }
            if (this.hiddenGene != null) {
                panda.setHiddenGene(this.hiddenGene);
            }
        }
    }

    public void setEating(boolean bl) {
        this.eating = bl;
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.hiddenGene = gene;
    }

    public void setMainGene(Panda.Gene gene) {
        this.mainGene = gene;
    }

    public void setRolling(boolean bl) {
        this.rolling = bl;
    }

    public void setSitting(boolean bl) {
        this.sitting = bl;
    }

    public void setSneezing(boolean bl) {
        this.sneezing = bl;
    }

    public boolean toggleEating() {
        this.eating = !this.eating;
        return this.eating;
    }

    public boolean toggleRolling() {
        this.rolling = !this.rolling;
        return this.rolling;
    }

    public boolean toggleSitting() {
        this.sitting = !this.sitting;
        return this.sitting;
    }

    public boolean toggleSneezing() {
        this.sneezing = !this.sneezing;
        return this.sneezing;
    }

    @Command(aliases={"npc"}, usage="panda --gene (main gene) --hiddengene (hidden gene) -e(ating) -s(itting) -n (sneezing) -r(olling)", desc="", modifiers={"panda"}, flags="srne", min=1, max=1, permission="citizens.npc.panda")
    @Requirements(selected=true, ownership=true, types={EntityType.PANDA})
    public static void panda(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"gene"}) Panda.Gene gene, @Flag(value={"hiddengene"}) Panda.Gene gene2) {
        boolean bl;
        PandaTrait pandaTrait = nPC.getOrAddTrait(PandaTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("gene")) {
            if (gene == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty(Panda.Gene.values()));
            }
            pandaTrait.setMainGene(gene);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.panda.main-gene-set", commandContext.getFlag("gene"));
        }
        if (commandContext.hasValueFlag("hiddengene")) {
            if (gene2 == null) {
                throw new CommandUsageException("citizens.commands.npc.panda.invalid-gene", Util.listValuesPretty(Panda.Gene.values()));
            }
            pandaTrait.setHiddenGene(gene2);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.panda.hidden-gene-set", gene2);
        }
        if (commandContext.hasFlag('e')) {
            bl = pandaTrait.toggleEating();
            string = string + ' ' + Messaging.tr(bl ? "citizens.commands.npc.panda.eating-set" : "citizens.commands.npc.panda.eating-unset", nPC.getName());
        }
        if (commandContext.hasFlag('s')) {
            bl = pandaTrait.toggleSitting();
            string = string + ' ' + Messaging.tr(bl ? "citizens.commands.npc.panda.sitting" : "citizens.commands.npc.panda.stopped-sitting", nPC.getName());
        }
        if (commandContext.hasFlag('r')) {
            bl = pandaTrait.toggleRolling();
            string = string + ' ' + Messaging.tr(bl ? "citizens.commands.npc.panda.rolling" : "citizens.commands.npc.panda.rolling-stopped", nPC.getName());
        }
        if (commandContext.hasFlag('n')) {
            bl = pandaTrait.toggleSneezing();
            string = string + ' ' + Messaging.tr(bl ? "citizens.commands.npc.panda.sneezing" : "citizens.commands.npc.panda.sneezing-stopped", nPC.getName());
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

