/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.base.Joiner;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

@TraitName(value="villagertrait")
public class VillagerTrait
extends Trait {
    @Persist
    private int level = 1;
    @Persist
    private Villager.Type type;

    public VillagerTrait() {
        super("villagertrait");
    }

    public int getLevel() {
        return this.level;
    }

    public Villager.Type getType() {
        return this.type;
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof Villager)) {
            return;
        }
        if (this.type != null) {
            ((Villager)this.npc.getEntity()).setVillagerType(this.type);
        }
        this.level = Math.min(5, Math.max(1, this.level));
        ((Villager)this.npc.getEntity()).setVillagerLevel(this.level);
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setType(Villager.Type type) {
        this.type = type;
    }

    @Command(aliases={"npc"}, usage="villager (--level level) (--type type) (--profession profession) -s(hake head)", desc="", modifiers={"villager"}, min=1, max=1, flags="s", permission="citizens.npc.villager")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER})
    public static void villager(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"profession"}) Villager.Profession profession, @Flag(value={"type"}) Villager.Type type, @Flag(value={"level"}) Integer n) {
        VillagerTrait villagerTrait = nPC.getOrAddTrait(VillagerTrait.class);
        String string = "";
        if (n != null) {
            if (n < 0) {
                throw new CommandUsageException();
            }
            villagerTrait.setLevel(n);
            string = string + " " + Messaging.tr("citizens.commands.npc.villager.level-set", n);
        }
        if (commandContext.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException("citizens.commands.npc.villager.invalid-type", Util.listValuesPretty(Villager.Type.values()));
            }
            villagerTrait.setType(type);
            string = string + " " + Messaging.tr("citizens.commands.npc.villager.type-set", commandContext.getFlag("type"));
        }
        if (commandContext.hasValueFlag("profession")) {
            if (profession == null) {
                throw new CommandException("citizens.commands.npc.profession.invalid-profession", commandContext.getFlag("profession"), Joiner.on((char)',').join((Object[])Villager.Profession.values()));
            }
            nPC.getOrAddTrait(VillagerProfession.class).setProfession(profession);
            string = string + " " + Messaging.tr("citizens.commands.npc.profession.set", nPC.getName(), commandContext.getFlag("profession"));
        }
        if (commandContext.hasFlag('s')) {
            ((Villager)nPC.getEntity()).shakeHead();
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }
}

