/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Warden;

@TraitName(value="wardentrait")
public class WardenTrait
extends Trait {
    private final Map<UUID, Integer> anger = Maps.newHashMap();

    public WardenTrait() {
        super("wardentrait");
    }

    private void addAnger(Entity entity, int n) {
        this.anger.put(entity.getUniqueId(), n);
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Warden) {
            Warden warden = (Warden)this.npc.getEntity();
            for (Map.Entry<UUID, Integer> entry : this.anger.entrySet()) {
                warden.setAnger(Bukkit.getEntity((UUID)entry.getKey()), entry.getValue().intValue());
            }
        }
    }

    @Command(aliases={"npc"}, usage="warden dig|emerge|roar|anger [entity uuid/player name] [anger]", desc="", modifiers={"warden"}, min=1, max=4, permission="citizens.npc.warden")
    @Requirements(selected=true, ownership=true, types={EntityType.WARDEN})
    public static void warden(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Arg(value=1, completions={"anger", "dig", "emerge", "roar"}) String string, @Arg(value=2) String string2, @Arg(value=3) Integer n) {
        WardenTrait wardenTrait = nPC.getOrAddTrait(WardenTrait.class);
        String string3 = "";
        if (string.equalsIgnoreCase("anger")) {
            if (n == null) {
                throw new CommandUsageException();
            }
            Entity entity = null;
            try {
                UUID uUID = UUID.fromString(string2);
                entity = Bukkit.getEntity((UUID)uUID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                entity = Bukkit.getOfflinePlayer((String)string2).getPlayer();
            }
            if (entity != null) {
                wardenTrait.addAnger(entity, n);
                string3 = Messaging.tr("citizens.commands.npc.warden.anger-added", entity, n);
            }
        } else if (string.equalsIgnoreCase("dig")) {
            NMS.setWardenPose(nPC.getEntity(), Pose.DIGGING);
            string3 = Messaging.tr("citizens.commands.npc.warden.pose-set", nPC.getName(), "dig");
        } else if (string.equalsIgnoreCase("emerge")) {
            NMS.setWardenPose(nPC.getEntity(), Pose.EMERGING);
            string3 = Messaging.tr("citizens.commands.npc.warden.pose-set", nPC.getName(), "emerge");
        } else if (string.equalsIgnoreCase("roar")) {
            NMS.setWardenPose(nPC.getEntity(), Pose.ROARING);
            string3 = Messaging.tr("citizens.commands.npc.warden.pose-set", nPC.getName(), "roar");
        }
        if (string3.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string3.trim());
    }
}

