/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class AnimationTrigger
implements WaypointTrigger {
    @Persist(required=true)
    private List<PlayerAnimation> animations = Lists.newArrayList();
    @Persist
    private Location at;

    public AnimationTrigger() {
    }

    public AnimationTrigger(Collection<PlayerAnimation> collection, Location location) {
        this.animations = Lists.newArrayList(collection);
        this.at = location;
    }

    @Override
    public String description() {
        return String.format("[[Animation]] animating %s", Joiner.on((String)", ").join(this.animations));
    }

    @Override
    public void onWaypointReached(NPC nPC, Location location) {
        if (nPC.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        if (this.at != null) {
            nPC.teleport(this.at, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
        Player player = (Player)nPC.getEntity();
        for (PlayerAnimation playerAnimation : this.animations) {
            playerAnimation.play(player);
        }
    }
}

