/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.AnimationTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class AnimationTriggerPrompt
extends StringPrompt
implements WaypointTriggerPrompt {
    private final List<PlayerAnimation> animations = Lists.newArrayList();
    private Location at;

    public Prompt acceptInput(ConversationContext conversationContext, String string) {
        if (string.equalsIgnoreCase("back")) {
            return (Prompt)conversationContext.getSessionData((Object)"previous");
        }
        if (string.startsWith("at ")) {
            try {
                this.at = CommandContext.parseLocation(conversationContext.getForWhom() instanceof Player ? ((Player)conversationContext.getForWhom()).getLocation() : null, string.replaceFirst("at ", ""));
                Messaging.send((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.animation.at-set", Util.prettyPrintLocation(this.at));
            }
            catch (CommandException commandException) {
                Messaging.send((CommandSender)conversationContext.getForWhom(), commandException.getMessage());
            }
            return this;
        }
        if (string.equalsIgnoreCase("finish")) {
            conversationContext.setSessionData((Object)"created-trigger", (Object)new AnimationTrigger(this.animations, this.at));
            return (Prompt)conversationContext.getSessionData((Object)"return-to");
        }
        PlayerAnimation playerAnimation = (PlayerAnimation)Util.matchEnum((Enum[])PlayerAnimation.values(), (String)string);
        if (playerAnimation == null) {
            Messaging.sendErrorTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.animation.invalid-animation", string, this.getValidAnimations());
        }
        this.animations.add(playerAnimation);
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.animation.added", string);
        return this;
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext conversationContext, String string) {
        PlayerAnimation playerAnimation = (PlayerAnimation)Util.matchEnum((Enum[])PlayerAnimation.values(), (String)string);
        if (playerAnimation == null) {
            return null;
        }
        return new AnimationTrigger(Lists.newArrayList((Object[])new PlayerAnimation[]{playerAnimation}), this.at);
    }

    public String getPromptText(ConversationContext conversationContext) {
        Messaging.sendTr((CommandSender)conversationContext.getForWhom(), "citizens.editors.waypoints.triggers.animation.prompt", this.getValidAnimations());
        return "";
    }

    private String getValidAnimations() {
        return Joiner.on((String)", ").join((Object[])PlayerAnimation.values());
    }
}

