/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class Anchor {
    private Location location;
    private final String name;
    private final String unloaded_value;

    public Anchor(String string, Location location) {
        this.location = location;
        this.name = string;
        this.unloaded_value = location.getWorld().getName() + ';' + location.getX() + ';' + location.getY() + ';' + location.getZ();
    }

    public Anchor(String string, String string2) {
        this.location = null;
        this.unloaded_value = string2;
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Anchor anchor = (Anchor)object;
        return new EqualsBuilder().append((Object)this.name, (Object)anchor.name).isEquals();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String[] getUnloadedValue() {
        return this.unloaded_value.split(";");
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.name).toHashCode();
    }

    public boolean isLoaded() {
        return this.location != null;
    }

    public boolean load() {
        try {
            String[] stringArray = this.getUnloadedValue();
            this.location = new Location(Bukkit.getWorld((String)stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.location != null;
    }

    public String stringValue() {
        return this.name + ';' + this.unloaded_value;
    }

    public String toString() {
        String[] stringArray = this.getUnloadedValue();
        return "Anchor{Name='" + this.name + "';World='" + stringArray[0] + "';Location='" + stringArray[1] + ',' + stringArray[2] + ',' + stringArray[3] + "';}";
    }
}

