/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.versioned.ArmadilloTrait;
import net.citizensnpcs.trait.versioned.CamelTrait;
import net.citizensnpcs.trait.versioned.SnifferTrait;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMS {
    private static Method ADD_OPENS;
    private static NMSBridge BRIDGE;
    private static MethodHandle FIND_PROFILES_BY_NAMES;
    private static Method GET_MODULE;
    private static MethodHandles.Lookup LOOKUP;
    private static Field MODIFIERS_FIELD;
    private static boolean PAPER_KNOCKBACK_EVENT_EXISTS;
    private static boolean SUPPORT_KNOCKBACK_RESISTANCE;
    private static Object UNSAFE;
    private static MethodHandle UNSAFE_FIELD_OFFSET;
    private static MethodHandle UNSAFE_PUT_BOOLEAN;
    private static MethodHandle UNSAFE_PUT_DOUBLE;
    private static MethodHandle UNSAFE_PUT_FLOAT;
    private static MethodHandle UNSAFE_PUT_INT;
    private static MethodHandle UNSAFE_PUT_LONG;
    private static MethodHandle UNSAFE_PUT_OBJECT;
    private static MethodHandle UNSAFE_STATIC_FIELD_OFFSET;

    private NMS() {
    }

    public static void activate(Entity entity) {
        BRIDGE.activate(entity);
    }

    public static boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        return BRIDGE.addEntityToWorld(entity, spawnReason);
    }

    public static void addOrRemoveFromPlayerList(Entity entity, boolean bl) {
        BRIDGE.addOrRemoveFromPlayerList(entity, bl);
    }

    public static void attack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        BRIDGE.attack(livingEntity, livingEntity2);
    }

    public static float[][] calculateDragonPositions(float f, double[][] dArray) {
        float[][] fArrayArray = new float[8][];
        float f2 = (float)(dArray[1][1] - dArray[2][1]) * 10.0f * ((float)Math.PI / 180);
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        float f5 = f * ((float)Math.PI / 180);
        float f6 = (float)Math.sin(f5);
        float f7 = (float)Math.cos(f5);
        fArrayArray[2] = new float[]{f6 * 0.5f, 0.0f, -f7 * 0.5f};
        fArrayArray[6] = new float[]{f7 * 4.5f, 2.0f, f6 * 4.5f};
        fArrayArray[7] = new float[]{f7 * -4.5f, 2.0f, f6 * -4.5f};
        float f8 = (float)(dArray[1][1] - dArray[0][1]);
        fArrayArray[0] = new float[]{f6 * 6.5f * f3, f8 + f4 * 6.5f, -f7 * 6.5f * f3};
        fArrayArray[1] = new float[]{f6 * 5.5f * f3, f8 + f4 * 5.5f, -f7 * 5.5f * f3};
        for (int i = 3; i < 6; ++i) {
            float f9 = f5 + Util.clamp((float)(dArray[i][0] - dArray[1][0])) * ((float)Math.PI / 180);
            float f10 = (float)Math.sin(f9);
            float f11 = (float)Math.cos(f9);
            float f12 = (float)(i - 2) * 2.0f;
            fArrayArray[i] = new float[]{-(f6 * 1.5f + f10 * f12) * f3, (float)(dArray[i][1] - dArray[1][1] - (double)((f12 + 1.5f) * f4) + 1.5), (f7 * 1.5f + f11 * f12) * f3};
        }
        return fArrayArray;
    }

    public static void callKnockbackEvent(NPC nPC, float f, double d, double d2, Consumer<NPCKnockbackEvent> consumer) {
        Vector vector;
        if (nPC.getEntity() == null) {
            return;
        }
        if (SUPPORT_KNOCKBACK_RESISTANCE && nPC.getEntity() instanceof LivingEntity) {
            try {
                vector = ((LivingEntity)nPC.getEntity()).getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                if (vector != null) {
                    f = (float)((double)f * (1.0 - vector.getValue()));
                }
            }
            catch (Throwable throwable) {
                SUPPORT_KNOCKBACK_RESISTANCE = false;
            }
        }
        vector = nPC.getEntity().getVelocity();
        Vector vector2 = new Vector(d, 0.0, d2).normalize().multiply(f);
        Vector vector3 = new Vector(vector.getX() / 2.0 - vector2.getX() - vector.getX(), -vector.getY() + (nPC.getEntity().isOnGround() ? Math.min(0.4, vector.getY() / 2.0 + (double)f) : vector.getY()), vector.getZ() / 2.0 - vector2.getZ() - vector.getZ());
        NPCKnockbackEvent nPCKnockbackEvent = new NPCKnockbackEvent(nPC, f, vector3, null);
        Bukkit.getPluginManager().callEvent((Event)nPCKnockbackEvent);
        if (!PAPER_KNOCKBACK_EVENT_EXISTS) {
            nPCKnockbackEvent.getKnockbackVector().multiply(new Vector(-1, 0, -1));
        }
        if (!nPCKnockbackEvent.isCancelled()) {
            consumer.accept(nPCKnockbackEvent);
        }
    }

    public static void cancelMoveDestination(Entity entity) {
        BRIDGE.cancelMoveDestination(entity);
    }

    public static Iterable<Object> createBundlePacket(List<Object> list) {
        return BRIDGE.createBundlePacket(list);
    }

    public static EntityPacketTracker createPacketTracker(Entity entity) {
        return NMS.createPacketTracker(entity, new EntityPacketTracker.PacketAggregator());
    }

    public static EntityPacketTracker createPacketTracker(Entity entity, EntityPacketTracker.PacketAggregator packetAggregator) {
        return BRIDGE.createPacketTracker(entity, packetAggregator);
    }

    public static GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        return BRIDGE.fillProfileProperties(gameProfile, bl);
    }

    public static void findProfilesByNames(String[] stringArray, ProfileLookupCallback profileLookupCallback) {
        if (FIND_PROFILES_BY_NAMES == null) {
            try {
                Class<?> clazz = Class.forName("com.mojang.authlib.Agent");
                Object object = clazz.getField("MINECRAFT").get(null);
                MethodHandle methodHandle = NMS.getMethodHandle(BRIDGE.getGameProfileRepository().getClass(), "findProfilesByNames", false, String[].class, clazz, ProfileLookupCallback.class);
                FIND_PROFILES_BY_NAMES = MethodHandles.insertArguments(methodHandle, 2, object);
            }
            catch (Exception exception) {
                FIND_PROFILES_BY_NAMES = NMS.getMethodHandle(BRIDGE.getGameProfileRepository().getClass(), "findProfilesByNames", false, String[].class, ProfileLookupCallback.class);
            }
        }
        try {
            FIND_PROFILES_BY_NAMES.invoke(BRIDGE.getGameProfileRepository(), stringArray, profileLookupCallback);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static BlockBreaker getBlockBreaker(Entity entity, Block block, BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration) {
        return BRIDGE.getBlockBreaker(entity, block, blockBreakerConfiguration);
    }

    public static Object getBossBar(Entity entity) {
        return BRIDGE.getBossBar(entity);
    }

    public static BoundingBox getBoundingBox(Entity entity) {
        return BRIDGE.getBoundingBox(entity);
    }

    public static double getBoundingBoxHeight(Entity entity) {
        return BRIDGE.getBoundingBoxHeight(entity);
    }

    public static BoundingBox getCollisionBox(Block block) {
        if (block.getType() == Material.AIR) {
            return BoundingBox.EMPTY;
        }
        return BRIDGE.getCollisionBox(block).add(block.getX(), block.getY(), block.getZ());
    }

    public static Map<String, Object> getComponentMap(ItemStack itemStack) {
        return BRIDGE.getComponentMap(itemStack);
    }

    public static Location getDestination(Entity entity) {
        return BRIDGE.getDestination(entity);
    }

    public static int getFallDistance(NPC nPC, int n) {
        return nPC == null ? n : nPC.data().get(NPC.Metadata.PATHFINDER_FALL_DISTANCE, Integer.valueOf(Settings.Setting.PATHFINDER_FALL_DISTANCE.asInt() != -1 ? Settings.Setting.PATHFINDER_FALL_DISTANCE.asInt() : n));
    }

    public static Field getField(Class<?> clazz, String string) {
        return NMS.getField(clazz, string, true);
    }

    public static Field getField(Class<?> clazz, String string, boolean bl) {
        if (clazz == null) {
            return null;
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-field", string, exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    private static List<Field> getFieldsMatchingType(Class<?> clazz, Class<?> clazz2, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            if (bl ^ Modifier.isStatic(field.getModifiers()) || field.getType() != clazz2) continue;
            arrayList.add(field);
            field.setAccessible(true);
        }
        return arrayList;
    }

    public static List<MethodHandle> getFieldsOfType(Class<?> clazz, Class<?> clazz2) {
        List<Field> list = NMS.getFieldsMatchingType(clazz, clazz2, false);
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().map(field -> {
            try {
                return LOOKUP.unreflectGetter((Field)field);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }).filter(methodHandle -> methodHandle != null).collect(Collectors.toList());
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String string) {
        return NMS.getFinalSetter(clazz, string, true);
    }

    public static MethodHandle getFinalSetter(Class<?> clazz, String string, boolean bl) {
        return NMS.getFinalSetter(NMS.getField(clazz, string, bl), bl);
    }

    public static MethodHandle getFinalSetter(Field field, boolean bl) {
        if (field == null) {
            return null;
        }
        if (MODIFIERS_FIELD == null) {
            if (UNSAFE == null) {
                try {
                    UNSAFE = NMS.getField(Class.forName("sun.misc.Unsafe"), "theUnsafe").get(null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (bl) {
                        Messaging.logTr("citizens.nms-errors.getting-field", field.getName(), exception.getLocalizedMessage());
                    }
                    return null;
                }
                UNSAFE_STATIC_FIELD_OFFSET = NMS.getMethodHandle(UNSAFE.getClass(), "staticFieldOffset", true, Field.class).bindTo(UNSAFE);
                UNSAFE_FIELD_OFFSET = NMS.getMethodHandle(UNSAFE.getClass(), "objectFieldOffset", true, Field.class).bindTo(UNSAFE);
                UNSAFE_PUT_OBJECT = NMS.getMethodHandle(UNSAFE.getClass(), "putObject", true, Object.class, Long.TYPE, Object.class).bindTo(UNSAFE);
                UNSAFE_PUT_INT = NMS.getMethodHandle(UNSAFE.getClass(), "putInt", true, Object.class, Long.TYPE, Integer.TYPE).bindTo(UNSAFE);
                UNSAFE_PUT_FLOAT = NMS.getMethodHandle(UNSAFE.getClass(), "putFloat", true, Object.class, Long.TYPE, Float.TYPE).bindTo(UNSAFE);
                UNSAFE_PUT_DOUBLE = NMS.getMethodHandle(UNSAFE.getClass(), "putDouble", true, Object.class, Long.TYPE, Double.TYPE).bindTo(UNSAFE);
                UNSAFE_PUT_BOOLEAN = NMS.getMethodHandle(UNSAFE.getClass(), "putBoolean", true, Object.class, Long.TYPE, Boolean.TYPE).bindTo(UNSAFE);
                UNSAFE_PUT_LONG = NMS.getMethodHandle(UNSAFE.getClass(), "putLong", true, Object.class, Long.TYPE, Long.TYPE).bindTo(UNSAFE);
            }
            try {
                boolean bl2 = Modifier.isStatic(field.getModifiers());
                long l = (Long)(bl2 ? UNSAFE_STATIC_FIELD_OFFSET.invoke(field) : UNSAFE_FIELD_OFFSET.invoke(field));
                MethodHandle methodHandle = field.getType() == Integer.TYPE ? UNSAFE_PUT_INT : (field.getType() == Boolean.TYPE ? UNSAFE_PUT_BOOLEAN : (field.getType() == Double.TYPE ? UNSAFE_PUT_DOUBLE : (field.getType() == Float.TYPE ? UNSAFE_PUT_FLOAT : (field.getType() == Long.TYPE ? UNSAFE_PUT_LONG : UNSAFE_PUT_OBJECT))));
                return bl2 ? MethodHandles.insertArguments(methodHandle, 0, field.getDeclaringClass(), l) : MethodHandles.insertArguments(methodHandle, 1, l);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (bl) {
                    Messaging.logTr("citizens.nms-errors.getting-field", field.getName(), throwable.getLocalizedMessage());
                }
                return null;
            }
        }
        try {
            MODIFIERS_FIELD.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-field", field.getName(), exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-field", field.getName(), exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    public static MethodHandle getFirstFinalSetter(Class<?> clazz, Class<?> clazz2) {
        try {
            List<Field> list = NMS.getFieldsMatchingType(clazz, clazz2, false);
            if (list.isEmpty()) {
                return null;
            }
            return NMS.getFinalSetter(list.get(0), true);
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.getting-field", clazz2, exception.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getFirstGetter(Class<?> clazz, Class<?> clazz2) {
        try {
            List<Field> list = NMS.getFieldsMatchingType(clazz, clazz2, false);
            if (list.isEmpty()) {
                return null;
            }
            return LOOKUP.unreflectGetter(list.get(0));
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.getting-field", clazz2, exception.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getFirstMethodHandle(Class<?> clazz, boolean bl, Class<?> ... classArray) {
        return NMS.getFirstMethodHandleWithReturnType(clazz, bl, null, classArray);
    }

    public static MethodHandle getFirstMethodHandleWithReturnType(Class<?> clazz, boolean bl, Class<?> clazz2, Class<?> ... classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = null;
            for (Method method2 : clazz.getDeclaredMethods()) {
                Class<?>[] classArray2;
                if (clazz2 != null && !clazz2.equals(method2.getReturnType()) || (classArray2 = method2.getParameterTypes()).length != classArray.length) continue;
                method = method2;
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i] == classArray[i]) continue;
                    method = null;
                    break;
                }
                if (method != null) break;
            }
            if (method == null) {
                return null;
            }
            method.setAccessible(true);
            return LOOKUP.unreflect(method);
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-method", exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    public static MethodHandle getFirstSetter(Class<?> clazz, Class<?> clazz2) {
        try {
            List<Field> list = NMS.getFieldsMatchingType(clazz, clazz2, false);
            if (list.isEmpty()) {
                return null;
            }
            return LOOKUP.unreflectSetter(list.get(0));
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.getting-field", clazz2, exception.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getFirstStaticGetter(Class<?> clazz, Class<?> clazz2) {
        try {
            List<Field> list = NMS.getFieldsMatchingType(clazz, clazz2, true);
            if (list.isEmpty()) {
                return null;
            }
            return LOOKUP.unreflectGetter(list.get(0));
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.getting-field", clazz2, exception.getLocalizedMessage());
            return null;
        }
    }

    public static MethodHandle getGetter(Class<?> clazz, String string) {
        return NMS.getGetter(clazz, string, true);
    }

    public static MethodHandle getGetter(Class<?> clazz, String string, boolean bl) {
        try {
            return LOOKUP.unreflectGetter(NMS.getField(clazz, string, bl));
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-field", string, exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    public static float getHeadYaw(Entity entity) {
        return BRIDGE.getHeadYaw(entity);
    }

    public static float getHorizontalMovement(Entity entity) {
        return BRIDGE.getHorizontalMovement(entity);
    }

    public static float getJumpPower(NPC nPC, float f) {
        if (nPC == null) {
            return f;
        }
        if (nPC.data().has(NPC.Metadata.JUMP_POWER_SUPPLIER)) {
            return ((Float)((Function)nPC.data().get(NPC.Metadata.JUMP_POWER_SUPPLIER)).apply(nPC)).floatValue();
        }
        return f;
    }

    public static Method getMethod(Class<?> clazz, String string, boolean bl, Class<?> ... classArray) {
        Method method;
        block3: {
            if (clazz == null) {
                return null;
            }
            method = null;
            try {
                method = clazz.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
            }
            catch (Exception exception) {
                if (!bl) break block3;
                Messaging.logTr("citizens.nms-errors.getting-method", string, exception.getLocalizedMessage());
                if (!Messaging.isDebugging()) break block3;
                exception.printStackTrace();
            }
        }
        return method;
    }

    public static MethodHandle getMethodHandle(Class<?> clazz, String string, boolean bl, Class<?> ... classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            return LOOKUP.unreflect(NMS.getMethod(clazz, string, bl, classArray));
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-method", string, exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    private static Collection<Player> getNearbyPlayers(Entity entity) {
        return NMS.getNearbyPlayers(entity, entity.getLocation(), 64.0);
    }

    private static Collection<Player> getNearbyPlayers(Entity entity, Location location, double d) {
        return Lists.newArrayList(CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(entity, location, d));
    }

    public static NPC getNPC(Entity entity) {
        return BRIDGE.getNPC(entity);
    }

    public static EntityPacketTracker getPacketTracker(Entity entity) {
        NPC nPC;
        if (entity == null) {
            return null;
        }
        if (entity instanceof NPCHolder && (nPC = ((NPCHolder)entity).getNPC()).hasTrait(PacketNPC.class)) {
            return nPC.getOrAddTrait(PacketNPC.class).getPacketTracker();
        }
        if (!entity.isValid()) {
            return null;
        }
        return BRIDGE.getPacketTracker(entity);
    }

    public static List<Entity> getPassengers(Entity entity) {
        return BRIDGE.getPassengers(entity);
    }

    public static GameProfile getProfile(Player player) {
        return BRIDGE.getProfile(player);
    }

    public static GameProfile getProfile(SkullMeta skullMeta) {
        return BRIDGE.getProfile(skullMeta);
    }

    public static float getRidingHeightOffset(Entity entity, Entity entity2) {
        return BRIDGE.getRidingHeightOffset(entity, entity2);
    }

    public static MethodHandle getSetter(Class<?> clazz, String string) {
        return NMS.getSetter(clazz, string, true);
    }

    public static MethodHandle getSetter(Class<?> clazz, String string, boolean bl) {
        try {
            return LOOKUP.unreflectSetter(NMS.getField(clazz, string, bl));
        }
        catch (Exception exception) {
            if (bl) {
                Messaging.logTr("citizens.nms-errors.getting-field", string, exception.getLocalizedMessage());
                if (Messaging.isDebugging()) {
                    exception.printStackTrace();
                }
            }
            return null;
        }
    }

    public static String getSoundPath(Sound sound) {
        return BRIDGE.getSoundPath(sound);
    }

    public static Entity getSource(BlockCommandSender blockCommandSender) {
        return BRIDGE.getSource(blockCommandSender);
    }

    public static float getSpeedFor(NPC nPC) {
        return BRIDGE.getSpeedFor(nPC);
    }

    public static float getStepHeight(Entity entity) {
        return BRIDGE.getStepHeight(entity);
    }

    public static MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        return BRIDGE.getTargetNavigator(entity, iterable, navigatorParameters);
    }

    public static MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location location, NavigatorParameters navigatorParameters) {
        return BRIDGE.getTargetNavigator(entity, location, navigatorParameters);
    }

    public static MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity entity2, NavigatorParameters navigatorParameters) {
        return BRIDGE.getTargetNavigator(entity, entity2, navigatorParameters);
    }

    public static Entity getVehicle(Entity entity) {
        return BRIDGE.getVehicle(entity);
    }

    public static float getVerticalMovement(Entity entity) {
        return BRIDGE.getVerticalMovement(entity);
    }

    public static Collection<Player> getViewingPlayers(Entity entity) {
        return BRIDGE.getViewingPlayers(entity);
    }

    public static double getWidth(Entity entity) {
        return BRIDGE.getWidth(entity);
    }

    public static float getYaw(Entity entity) {
        return BRIDGE.getYaw(entity);
    }

    public static void giveReflectiveAccess(Class<?> clazz, Class<?> clazz2) {
        try {
            if (GET_MODULE == null) {
                Class<?> clazz3 = Class.forName("java.lang.Module");
                GET_MODULE = Class.class.getMethod("getModule", new Class[0]);
                ADD_OPENS = clazz3.getMethod("addOpens", String.class, clazz3);
            }
            ADD_OPENS.invoke(GET_MODULE.invoke(clazz, new Object[0]), clazz.getPackage().getName(), GET_MODULE.invoke(clazz2, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isLeashed(NPC nPC, Supplier<Boolean> supplier, Runnable runnable) {
        if (nPC == null) {
            return supplier.get();
        }
        boolean bl = nPC.isProtected();
        if (!bl || !nPC.data().get(NPC.Metadata.LEASH_PROTECTED, Boolean.valueOf(bl)).booleanValue()) {
            return supplier.get();
        }
        if (supplier.get().booleanValue()) {
            runnable.run();
        }
        return false;
    }

    public static boolean isOnGround(Entity entity) {
        return BRIDGE.isOnGround(entity);
    }

    public static boolean isSneaking(Entity entity) {
        return BRIDGE.isSneaking(entity);
    }

    public static boolean isSolid(Block block) {
        return BRIDGE.isSolid(block);
    }

    public static boolean isValid(Entity entity) {
        return BRIDGE.isValid(entity);
    }

    public static void linkTextInteraction(Player player, Entity entity, Entity entity2, double d) {
        BRIDGE.linkTextInteraction(player, entity, entity2, d);
    }

    public static void load(CommandManager commandManager) {
        BRIDGE.load(commandManager);
    }

    public static void loadBridge(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("net.minecraft.server." + string + ".Entity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName("net.minecraft.world.entity.Entity");
        }
        NMS.giveReflectiveAccess(clazz, NMS.class);
        BRIDGE = (NMSBridge)Class.forName("net.citizensnpcs.nms." + string + ".util.NMSImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void look(Entity entity, float f, float f2) {
        BRIDGE.look(entity, f, f2);
    }

    public static void look(Entity entity, Location location, boolean bl, boolean bl2) {
        BRIDGE.look(entity, location, bl, bl2);
    }

    public static void look(Entity entity, Entity entity2) {
        BRIDGE.look(entity, entity2);
    }

    public static void mount(Entity entity, Entity entity2) {
        BRIDGE.mount(entity, entity2);
    }

    public static void onPlayerInfoAdd(Player player, Object object, Function<UUID, MirrorTrait> function) {
        BRIDGE.onPlayerInfoAdd(player, object, function);
    }

    public static InventoryView openAnvilInventory(Player player, Inventory inventory, String string) {
        return BRIDGE.openAnvilInventory(player, inventory, string);
    }

    public static void openHorseScreen(Tameable tameable, Player player) {
        BRIDGE.openHorseInventory(tameable, player);
    }

    public static void playAnimation(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        BRIDGE.playAnimation(playerAnimation, player, iterable);
    }

    public static Runnable playerTicker(Player player) {
        return BRIDGE.playerTicker(player instanceof NPCHolder ? ((NPCHolder)player).getNPC() : null, player);
    }

    public static void registerEntityClass(Class<?> clazz) {
        BRIDGE.registerEntityClass(clazz);
    }

    public static void remove(Entity entity) {
        BRIDGE.remove(entity);
    }

    public static void removeFromServerPlayerList(Player player) {
        BRIDGE.removeFromServerPlayerList(player);
    }

    public static void removeFromWorld(Entity entity) {
        BRIDGE.removeFromWorld(entity);
    }

    public static void removeHookIfNecessary(FishHook fishHook) {
        BRIDGE.removeHookIfNecessary(fishHook);
    }

    public static void replaceTracker(Entity entity) {
        BRIDGE.replaceTrackerEntry(entity);
    }

    public static void sendPositionUpdate(Entity entity, Collection<Player> collection, boolean bl) {
        NMS.sendPositionUpdate(entity, collection, bl, Float.valueOf(NMS.getYaw(entity)), Float.valueOf(entity.getLocation().getPitch()), Float.valueOf(NMS.getHeadYaw(entity)));
    }

    public static void sendPositionUpdate(Entity entity, Collection<Player> collection, boolean bl, Float f, Float f2, Float f3) {
        BRIDGE.sendPositionUpdate(entity, collection, bl, f, f2, f3);
    }

    public static void sendPositionUpdateNearby(Entity entity, boolean bl) {
        NMS.sendPositionUpdate(entity, NMS.getNearbyPlayers(entity), bl, Float.valueOf(NMS.getYaw(entity)), Float.valueOf(entity.getLocation().getPitch()), Float.valueOf(NMS.getHeadYaw(entity)));
    }

    public static void sendPositionUpdateNearby(Entity entity, boolean bl, Float f, Float f2, Float f3) {
        NMS.sendPositionUpdate(entity, NMS.getNearbyPlayers(entity), bl, f, f2, f3);
    }

    public static boolean sendTabListAdd(Player player, Player player2) {
        return BRIDGE.sendTabListAdd(player, player2);
    }

    public static void sendTabListRemove(Player player, Collection<Player> collection) {
        BRIDGE.sendTabListRemove(player, collection);
    }

    public static void sendTabListRemove(Player player, Player player2) {
        NMS.sendTabListRemove(player, (Collection<Player>)ImmutableList.of((Object)player2));
    }

    public static void sendTeamPacket(Player player, Team team, int n) {
        BRIDGE.sendTeamPacket(player, team, n);
    }

    public static void setAggressive(Entity entity, boolean bl) {
        BRIDGE.setAggressive(entity, bl);
    }

    public static void setAllayDancing(Entity entity, boolean bl) {
        BRIDGE.setAllayDancing(entity, bl);
    }

    public static void setArmadilloState(Entity entity, ArmadilloTrait.ArmadilloState armadilloState) {
        BRIDGE.setArmadilloState(entity, armadilloState);
    }

    public static void setBodyYaw(Entity entity, float f) {
        BRIDGE.setBodyYaw(entity, f);
    }

    public static void setBoundingBox(Entity entity, BoundingBox boundingBox) {
        BRIDGE.setBoundingBox(entity, boundingBox);
    }

    public static void setCamelPose(Entity entity, CamelTrait.CamelPose camelPose) {
        BRIDGE.setCamelPose(entity, camelPose);
    }

    public static void setCustomName(Entity entity, Object object, String string) {
        BRIDGE.setCustomName(entity, object, string);
    }

    public static void setDestination(Entity entity, double d, double d2, double d3, float f) {
        BRIDGE.setDestination(entity, d, d2, d3, f);
    }

    public static void setDimensions(Entity entity, EntityDim entityDim) {
        BRIDGE.setDimensions(entity, entityDim);
    }

    public static void setEndermanAngry(Enderman enderman, boolean bl) {
        BRIDGE.setEndermanAngry(enderman, bl);
    }

    public static void setHeadAndBodyYaw(Entity entity, float f) {
        BRIDGE.setHeadAndBodyYaw(entity, f);
    }

    public static void setHeadYaw(Entity entity, float f) {
        BRIDGE.setHeadYaw(entity, f);
    }

    public static void setKnockbackResistance(LivingEntity livingEntity, double d) {
        BRIDGE.setKnockbackResistance(livingEntity, d);
    }

    public static void setLocationDirectly(Entity entity, Location location) {
        BRIDGE.setLocationDirectly(entity, location);
    }

    public static void setLyingDown(Entity entity, boolean bl) {
        BRIDGE.setLyingDown(entity, bl);
    }

    public static void setNavigationTarget(Entity entity, Entity entity2, float f) {
        BRIDGE.setNavigationTarget(entity, entity2, f);
    }

    public static void setNavigationType(Entity entity, MinecraftNavigationType minecraftNavigationType) {
        BRIDGE.setNavigationType(entity, minecraftNavigationType);
    }

    public static void setNoGravity(Entity entity, boolean bl) {
        BRIDGE.setNoGravity(entity, bl);
    }

    public static void setPandaSitting(Entity entity, boolean bl) {
        BRIDGE.setPandaSitting(entity, bl);
    }

    public static void setPeekShulker(Entity entity, int n) {
        if (!entity.getType().name().equals("SHULKER")) {
            throw new IllegalArgumentException("entity must be a shulker");
        }
        BRIDGE.setPeekShulker(entity, n);
    }

    public static void setPiglinDancing(Entity entity, boolean bl) {
        BRIDGE.setPiglinDancing(entity, bl);
    }

    public static void setPitch(Entity entity, float f) {
        BRIDGE.setPitch(entity, f);
    }

    public static void setPolarBearRearing(Entity entity, boolean bl) {
        BRIDGE.setPolarBearRearing(entity, bl);
    }

    public static void setPose(Entity entity, EntityPoseTrait.EntityPose entityPose) {
        BRIDGE.setPose(entity, entityPose);
    }

    public static void setProfile(SkullMeta skullMeta, GameProfile gameProfile) {
        BRIDGE.setProfile(skullMeta, gameProfile);
    }

    public static void setShouldJump(Entity entity) {
        BRIDGE.setShouldJump(entity);
    }

    public static void setSitting(Ocelot ocelot, boolean bl) {
        BRIDGE.setSitting(ocelot, bl);
    }

    public static void setSitting(Tameable tameable, boolean bl) {
        BRIDGE.setSitting(tameable, bl);
    }

    public static void setSneaking(Entity entity, boolean bl) {
        BRIDGE.setSneaking(entity, bl);
    }

    public static void setSnifferState(Entity entity, SnifferTrait.SnifferState snifferState) {
        BRIDGE.setSnifferState(entity, snifferState);
    }

    public static void setStepHeight(Entity entity, float f) {
        BRIDGE.setStepHeight(entity, f);
    }

    public static void setTeamNameTagVisible(Team team, boolean bl) {
        BRIDGE.setTeamNameTagVisible(team, bl);
    }

    public static void setTextDisplayComponent(Entity entity, Object object) {
        BRIDGE.setTextDisplayComponent(entity, object);
    }

    public static void setVerticalMovement(Entity entity, double d) {
        BRIDGE.setVerticalMovement(entity, d);
    }

    public static void setWardenPose(Entity entity, Object object) {
        BRIDGE.setWardenPose(entity, object);
    }

    public static void setWitherInvulnerableTicks(Wither wither, int n) {
        BRIDGE.setWitherInvulnerableTicks(wither, n);
    }

    public static boolean shouldJump(Entity entity) {
        return BRIDGE.shouldJump(entity);
    }

    public static void shutdown() {
        if (BRIDGE != null) {
            BRIDGE.shutdown();
            BRIDGE = null;
        }
    }

    public static void sleep(Player player, boolean bl) {
        BRIDGE.sleep(player, bl);
    }

    public static void trySwim(Entity entity) {
        NMS.trySwim(entity, SwimmingExaminer.isWaterMob(entity) ? 0.02f : 0.04f);
    }

    public static void trySwim(Entity entity, float f) {
        BRIDGE.trySwim(entity, f);
    }

    public static void updateInventoryTitle(Player player, InventoryView inventoryView, String string) {
        BRIDGE.updateInventoryTitle(player, inventoryView, string);
    }

    public static void updateNavigationWorld(Entity entity, World world) {
        BRIDGE.updateNavigationWorld(entity, world);
    }

    public static void updatePathfindingRange(NPC nPC, float f) {
        BRIDGE.updatePathfindingRange(nPC, f);
    }

    static {
        FIND_PROFILES_BY_NAMES = null;
        LOOKUP = MethodHandles.lookup();
        PAPER_KNOCKBACK_EVENT_EXISTS = true;
        SUPPORT_KNOCKBACK_RESISTANCE = true;
        try {
            Class.forName("com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            PAPER_KNOCKBACK_EVENT_EXISTS = false;
        }
        NMS.giveReflectiveAccess(Field.class, NMS.class);
        MODIFIERS_FIELD = NMS.getField(Field.class, "modifiers", false);
    }

    public static enum MinecraftNavigationType {
        GROUND,
        WALL_CLIMB;

    }
}

