/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.api.ComplexTurretsAPI;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretItemType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Comando
implements CommandExecutor,
TabCompleter {
    private ComplexTurrets plugin;

    public Comando(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        FileConfiguration fileConfiguration = this.plugin.getMessages();
        MensajesManager mensajesManager = this.plugin.getMensajesManager();
        if (!(commandSender instanceof Player)) {
            if (stringArray.length >= 1) {
                if (stringArray[0].equalsIgnoreCase("reload")) {
                    this.reload(commandSender, fileConfiguration, mensajesManager);
                } else if (stringArray[0].equalsIgnoreCase("give")) {
                    if (this.plugin.isPluginDisabled()) {
                        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("pluginDisabledError"), true);
                        return true;
                    }
                    this.give(commandSender, fileConfiguration, mensajesManager, stringArray);
                } else if (stringArray[0].equalsIgnoreCase("giveammo")) {
                    if (this.plugin.isPluginDisabled()) {
                        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("pluginDisabledError"), true);
                        return true;
                    }
                    this.giveAmmo(commandSender, fileConfiguration, mensajesManager, stringArray);
                } else if (stringArray[0].equalsIgnoreCase("migrate")) {
                    this.migrate(commandSender, fileConfiguration, mensajesManager);
                } else {
                    this.help(commandSender);
                }
            } else {
                this.help(commandSender);
            }
            return false;
        }
        Player player = (Player)commandSender;
        if (stringArray.length >= 1 && stringArray[0].equalsIgnoreCase("list")) {
            if (player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.command.list")) {
                this.list(player, fileConfiguration, mensajesManager, stringArray);
            } else {
                mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("noPermissions"), true);
            }
            return true;
        }
        if (player.isOp() || player.hasPermission("complexturrets.admin")) {
            if (stringArray.length >= 1) {
                if (stringArray[0].equalsIgnoreCase("reload")) {
                    this.reload(commandSender, fileConfiguration, mensajesManager);
                } else if (stringArray[0].equalsIgnoreCase("give")) {
                    if (this.plugin.isPluginDisabled()) {
                        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("pluginDisabledError"), true);
                        return true;
                    }
                    this.give(commandSender, fileConfiguration, mensajesManager, stringArray);
                } else if (stringArray[0].equalsIgnoreCase("giveammo")) {
                    if (this.plugin.isPluginDisabled()) {
                        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("pluginDisabledError"), true);
                        return true;
                    }
                    this.giveAmmo(commandSender, fileConfiguration, mensajesManager, stringArray);
                } else if (stringArray[0].equalsIgnoreCase("verify")) {
                    this.plugin.getErrorManager().sendMessage(player);
                } else if (stringArray[0].equalsIgnoreCase("migrate")) {
                    this.migrate(commandSender, fileConfiguration, mensajesManager);
                } else if (stringArray[0].equalsIgnoreCase("autofix")) {
                    try {
                        String string2 = stringArray[1];
                        if (string2.equals("invalid_turret_type")) {
                            String string3 = stringArray[2];
                            String string4 = stringArray[3];
                            this.plugin.getErrorManager().fixInvalidTurretType(player, string3, string4);
                        } else if (string2.equals("invalid_sound")) {
                            String string5 = stringArray[2];
                            String string6 = stringArray[3];
                            this.plugin.getErrorManager().fixInvalidSound(player, string5, string6);
                        } else if (string2.equals("invalid_material")) {
                            String string7 = stringArray[2];
                            String string8 = stringArray[3];
                            String string9 = stringArray[4];
                            this.plugin.getErrorManager().fixInvalidMaterial(player, string7, string8, string9);
                        } else if (string2.equals("invalid_particle")) {
                            String string10 = stringArray[2];
                            String string11 = stringArray[3];
                            this.plugin.getErrorManager().fixInvalidParticle(player, string10, string11);
                        } else if (string2.equals("invalid_world")) {
                            this.plugin.getErrorManager().fixInvalidWorld(player);
                        }
                    }
                    catch (Exception exception) {}
                } else if (stringArray[0].equalsIgnoreCase("setdamage")) {
                    this.setDamage(player, fileConfiguration, mensajesManager, stringArray);
                } else {
                    this.help(commandSender);
                }
            } else {
                this.help(commandSender);
            }
        } else {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("noPermissions"), true);
        }
        return true;
    }

    public void reload(CommandSender commandSender, FileConfiguration fileConfiguration, MensajesManager mensajesManager) {
        this.plugin.recargarConfigs();
        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("configReloaded"), true);
    }

    public void give(CommandSender commandSender, FileConfiguration fileConfiguration, MensajesManager mensajesManager, String[] stringArray) {
        if (stringArray.length < 3) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveCommandError"), true);
            return;
        }
        Turret turret = this.plugin.getTurretsManager().getTurret(stringArray[1]);
        if (turret == null) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("turretDoesNotExist"), true);
            return;
        }
        Player player = Bukkit.getPlayer((String)stringArray[2]);
        if (player == null) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("playerNotOnline"), true);
            return;
        }
        if (player.getInventory().firstEmpty() == -1) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveCommandNotEnoughSpace"), true);
            return;
        }
        ItemStack itemStack = this.plugin.getItemManager().createTurretItem(player, turret, TurretItemType.BLOCK, 1, null);
        String string = itemStack.getItemMeta().getDisplayName();
        player.getInventory().addItem(new ItemStack[]{itemStack});
        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveCommandSuccessSender").replace("%player%", stringArray[2]).replace("%name%", string), true);
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("giveCommandSuccessPlayer").replace("%name%", string), true);
    }

    public void giveAmmo(CommandSender commandSender, FileConfiguration fileConfiguration, MensajesManager mensajesManager, String[] stringArray) {
        if (stringArray.length < 4) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveAmmoCommandError"), true);
            return;
        }
        Turret turret = this.plugin.getTurretsManager().getTurret(stringArray[1]);
        if (turret == null) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("turretDoesNotExist"), true);
            return;
        }
        Player player = Bukkit.getPlayer((String)stringArray[2]);
        if (player == null) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("playerNotOnline"), true);
            return;
        }
        int n = 0;
        try {
            n = Integer.valueOf(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveAmmoCommandAmountError"), true);
            return;
        }
        ItemStack itemStack = this.plugin.getItemManager().createTurretItem(player, turret, TurretItemType.AMMUNITION, 0, null);
        int n2 = 0;
        while (n2 < n) {
            player.getInventory().addItem(new ItemStack[]{itemStack});
            ++n2;
        }
        String string = itemStack.getItemMeta().getDisplayName();
        mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("giveammoCommandSuccessSender").replace("%player%", stringArray[2]).replace("%name%", string), true);
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("giveammoCommandSuccessPlayer").replace("%name%", string), true);
    }

    public void migrate(CommandSender commandSender, FileConfiguration fileConfiguration, MensajesManager mensajesManager) {
        if (!this.plugin.getDependencyManager().hasDefensiveTurrets()) {
            mensajesManager.enviarMensaje(commandSender, fileConfiguration.getString("migrateError"), true);
            return;
        }
        this.plugin.getDependencyManager().migrateFromDefensiveTurrets(commandSender);
    }

    public void list(Player player, FileConfiguration fileConfiguration, MensajesManager mensajesManager, String[] stringArray) {
        ArrayList<PlayerTurret> arrayList = ComplexTurretsAPI.getPlayerTurrets(player);
        if (arrayList.isEmpty()) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("commandListError"), true);
            return;
        }
        int n = 1;
        if (stringArray.length >= 2) {
            try {
                n = Integer.valueOf(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("commandListPageError"), true);
                return;
            }
        }
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        int n2 = arrayList.size();
        int n3 = 1 + n2 / 8;
        if (n > n3) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("commandListPageError"), true);
            return;
        }
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("commandListTitle").replace("%current_page%", String.valueOf(n)).replace("%max_pages%", String.valueOf(n3)), false);
        int n4 = 1;
        int n5 = 8 * (n - 1);
        while (n5 < n2) {
            PlayerTurret playerTurret = arrayList.get(n5);
            Location location = playerTurret.getLocation();
            Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("commandListLine").replace("%turret_alias%", turret.getAlias()).replace("%x_coord%", String.valueOf(location.getBlockX())).replace("%y_coord%", String.valueOf(location.getBlockY())).replace("%z_coord%", String.valueOf(location.getBlockZ())).replace("%world%", location.getWorld().getName()).replace("%number%", String.valueOf(n5 + 1)).replace("%level%", String.valueOf(playerTurret.getTurretLevel())), false);
            if (++n4 >= 9) break;
            ++n5;
        }
    }

    public void setDamage(Player player, FileConfiguration fileConfiguration, MensajesManager mensajesManager, String[] stringArray) {
        if (stringArray.length < 3) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandError"), true);
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.valueOf(stringArray[1]);
            n2 = Integer.valueOf(stringArray[2]);
            if (n > n2 || n < 0 || n2 < 0) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandInvalidDamage"), true);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandInvalidDamage"), true);
            return;
        }
        ItemStack itemStack = player.getItemInHand();
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandNoItem"), true);
            return;
        }
        if (!itemStack.getType().equals((Object)Material.BOW) && !itemStack.getType().name().equals("CROSSBOW")) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandInvalidItem"), true);
            return;
        }
        ItemManager.removeTagItem(itemStack, "complexturrets_turret_min_damage");
        ItemManager.removeTagItem(itemStack, "complexturrets_turret_max_damage");
        if (n == 0 && n2 == 0) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandRemoved"), true);
            return;
        }
        ItemManager.setTagIntItem(itemStack, "complexturrets_turret_min_damage", n);
        ItemManager.setTagIntItem(itemStack, "complexturrets_turret_max_damage", n2);
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("setDamageCommandCorrect").replace("%min%", String.valueOf(n)).replace("%max%", String.valueOf(n2)), true);
    }

    public void help(CommandSender commandSender) {
        commandSender.sendMessage(MensajesManager.getMensajeColor("&5&m                                                                    "));
        commandSender.sendMessage(MensajesManager.getMensajeColor("      &5&lComplex&9&lTurrets &eCommands"));
        commandSender.sendMessage(MensajesManager.getMensajeColor(" "));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct give <turret> <player> &7Gives a turret to the player."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct giveammo <turret> <player> <amount> &7Gives ammo to the player."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct reload &7Reloads the Config."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct verify &7Checks the plugin for errors."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct migrate &7Migrates data from DefensiveTurrets."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct list &7Lists all of your turrets."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct setdamage <min_damage> <max_damage> &7Sets turret damage to an item."));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&8- &9/ct help &7Shows this message"));
        commandSender.sendMessage(MensajesManager.getMensajeColor(" "));
        commandSender.sendMessage(MensajesManager.getMensajeColor("&5&m                                                                    "));
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender.isOp() || commandSender.hasPermission("complexturrets.admin")) {
            if (stringArray.length == 1) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("give");
                arrayList2.add("giveammo");
                arrayList2.add("reload");
                arrayList2.add("reload");
                arrayList2.add("verify");
                arrayList2.add("migrate");
                arrayList2.add("help");
                arrayList2.add("list");
                arrayList2.add("setdamage");
                for (String string2 : arrayList2) {
                    if (!stringArray[0].isEmpty() && !string2.startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(string2);
                }
                return arrayList;
            }
            if ((stringArray[0].equalsIgnoreCase("give") || stringArray[0].equalsIgnoreCase("giveammo")) && stringArray.length == 2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string3 = stringArray[1];
                ArrayList<Turret> arrayList3 = this.plugin.getTurretsManager().getTurrets();
                for (Turret turret : arrayList3) {
                    if (!string3.toLowerCase().isEmpty() && !turret.getName().toLowerCase().startsWith(string3.toLowerCase())) continue;
                    arrayList.add(turret.getName());
                }
                return arrayList;
            }
        }
        return null;
    }
}

