/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.configs;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.others.ConfigArmorDurability;
import ct.ajneb97.utils.UtilsOthers;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class MainConfigManager {
    private ComplexTurrets plugin;
    private boolean hitHolograms;
    private boolean informationHolograms;
    private boolean informationHologramsAlwaysVisible;
    private boolean enableTurretsOnlyWhenOwnerIsOnline;
    private boolean allyProtection;
    private boolean ignoreDamageToInvisiblePlayers;
    private boolean shootThroughLiquids;
    private boolean wallsBetterCheck;
    private boolean blockMobDropOnTurretKill;
    private boolean removeArrowsOnTurretDamage;
    private int hitHologramsDisappearTime;
    private int turretBlocksNearbyMinDistance;
    private ConfigArmorDurability configArmorDurability;
    private int defaultMaxAmmo;
    private boolean forceParticles;
    private String turretDamageBow;
    private String turretDamageCrossbow;
    private String turretDamageExplosions;
    private List<String> turretAmmoItemLore;
    private boolean firstTime;

    public MainConfigManager(ComplexTurrets complexTurrets, boolean bl) {
        this.plugin = complexTurrets;
        this.firstTime = bl;
    }

    public void configurar() {
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        if (this.firstTime && UtilsOthers.isLegacy()) {
            this.checkAndFix(fileConfiguration);
        }
        this.hitHolograms = fileConfiguration.getBoolean("hit_holograms");
        this.informationHolograms = fileConfiguration.getBoolean("information_holograms");
        this.informationHologramsAlwaysVisible = fileConfiguration.getBoolean("information_holograms_always_visible");
        this.enableTurretsOnlyWhenOwnerIsOnline = fileConfiguration.getBoolean("enable_turrets_only_when_owner_is_online");
        this.allyProtection = fileConfiguration.getBoolean("ally_protection");
        this.ignoreDamageToInvisiblePlayers = fileConfiguration.getBoolean("ignore_damage_to_invisible_players");
        this.shootThroughLiquids = fileConfiguration.getBoolean("shoot_through_liquids");
        this.wallsBetterCheck = fileConfiguration.getBoolean("walls_better_check");
        this.hitHologramsDisappearTime = fileConfiguration.getInt("hit_holograms_disappear_time");
        this.turretDamageBow = fileConfiguration.getString("turret_damage.bow");
        this.turretDamageCrossbow = fileConfiguration.getString("turret_damage.crossbow");
        this.turretDamageExplosions = fileConfiguration.getString("turret_damage.explosions");
        this.turretAmmoItemLore = fileConfiguration.getStringList("items.turret_ammo_item.lore");
        this.blockMobDropOnTurretKill = fileConfiguration.getBoolean("block_mob_drop_on_turret_kill");
        this.turretBlocksNearbyMinDistance = fileConfiguration.getInt("turret_blocks_nearby_min_distance");
        this.defaultMaxAmmo = fileConfiguration.getInt("default_max_ammo");
        this.removeArrowsOnTurretDamage = fileConfiguration.getBoolean("remove_arrows_on_turret_damage");
        this.forceParticles = fileConfiguration.getBoolean("force_particles");
        this.configArmorDurability = new ConfigArmorDurability(fileConfiguration.getBoolean("armor_durability.enabled"), fileConfiguration.getDouble("armor_durability.min_damage_to_reduce_durability"), fileConfiguration.getBoolean("armor_durability.reduce_durability_one_armor_slot_per_hit"));
    }

    public void checkAndFix(FileConfiguration fileConfiguration) {
        fileConfiguration.set("turret_destroy_sound", (Object)"ANVIL_BREAK;10;1");
        fileConfiguration.set("turret_upgrade_sound", (Object)"LEVEL_UP;10;1.5");
        for (String string : fileConfiguration.getConfigurationSection("items").getKeys(false)) {
            String string2;
            if (fileConfiguration.contains("items." + string + ".id") && (string2 = fileConfiguration.getString("items." + string + ".id")).equals("PLAYER_HEAD")) {
                fileConfiguration.set("items." + string + ".id", (Object)"SKULL_ITEM:3");
            }
            if (fileConfiguration.contains("items." + string + ".id_enabled") && (string2 = fileConfiguration.getString("items." + string + ".id_enabled")).equals("GREEN_TERRACOTTA")) {
                fileConfiguration.set("items." + string + ".id_enabled", (Object)"STAINED_CLAY:5");
            }
            if (!fileConfiguration.contains("items." + string + ".id_disabled") || !(string2 = fileConfiguration.getString("items." + string + ".id_disabled")).equals("RED_TERRACOTTA")) continue;
            fileConfiguration.set("items." + string + ".id_disabled", (Object)"STAINED_CLAY:14");
        }
        this.plugin.saveConfig();
        this.firstTime = false;
    }

    public boolean isInformationHolograms() {
        return this.informationHolograms;
    }

    public void setInformationHolograms(boolean bl) {
        this.informationHolograms = bl;
    }

    public boolean isEnableTurretsOnlyWhenOwnerIsOnline() {
        return this.enableTurretsOnlyWhenOwnerIsOnline;
    }

    public void setEnableTurretsOnlyWhenOwnerIsOnline(boolean bl) {
        this.enableTurretsOnlyWhenOwnerIsOnline = bl;
    }

    public boolean isAllyProtection() {
        return this.allyProtection;
    }

    public void setAllyProtection(boolean bl) {
        this.allyProtection = bl;
    }

    public boolean isIgnoreDamageToInvisiblePlayers() {
        return this.ignoreDamageToInvisiblePlayers;
    }

    public void setIgnoreDamageToInvisiblePlayers(boolean bl) {
        this.ignoreDamageToInvisiblePlayers = bl;
    }

    public boolean isShootThroughLiquids() {
        return this.shootThroughLiquids;
    }

    public void setShootThroughLiquids(boolean bl) {
        this.shootThroughLiquids = bl;
    }

    public boolean isWallsBetterCheck() {
        return this.wallsBetterCheck;
    }

    public void setWallsBetterCheck(boolean bl) {
        this.wallsBetterCheck = bl;
    }

    public boolean isHitHolograms() {
        return this.hitHolograms;
    }

    public void setHitHolograms(boolean bl) {
        this.hitHolograms = bl;
    }

    public int getHitHologramsDisappearTime() {
        return this.hitHologramsDisappearTime;
    }

    public void setHitHologramsDisappearTime(int n) {
        this.hitHologramsDisappearTime = n;
    }

    public String getTurretDamageBow() {
        return this.turretDamageBow;
    }

    public String getTurretDamageExplosions() {
        return this.turretDamageExplosions;
    }

    public List<String> getTurretAmmoItemLore() {
        return this.turretAmmoItemLore;
    }

    public boolean isBlockMobDropOnTurretKill() {
        return this.blockMobDropOnTurretKill;
    }

    public ConfigArmorDurability getConfigArmorDurability() {
        return this.configArmorDurability;
    }

    public int getTurretBlocksNearbyMinDistance() {
        return this.turretBlocksNearbyMinDistance;
    }

    public boolean isInformationHologramsAlwaysVisible() {
        return this.informationHologramsAlwaysVisible;
    }

    public int getDefaultMaxAmmo() {
        return this.defaultMaxAmmo;
    }

    public String getTurretDamageCrossbow() {
        return this.turretDamageCrossbow;
    }

    public boolean isRemoveArrowsOnTurretDamage() {
        return this.removeArrowsOnTurretDamage;
    }

    public boolean isForceParticles() {
        return this.forceParticles;
    }
}

