/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.configs;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.MensajesManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MensajesConfigManager {
    private ComplexTurrets plugin;
    private FileConfiguration messages = null;
    private File messagesFile = null;
    private String rutaMessages;

    public MensajesConfigManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public void configurar() {
        this.registerMessages();
        this.plugin.setMensajesManager(new MensajesManager(this.getMessages().getString("prefix")));
    }

    public void registerMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.rutaMessages = this.messagesFile.getPath();
        if (!this.messagesFile.exists()) {
            this.getMessages().options().copyDefaults(true);
            this.saveMessages();
        }
    }

    public void saveMessages() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public FileConfiguration getMessages() {
        if (this.messages == null) {
            this.reloadMessages();
        }
        return this.messages;
    }

    public void reloadMessages() {
        if (this.messages == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.plugin.getResource("messages.yml"), "UTF8");
            if (inputStreamReader != null) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
                this.messages.setDefaults((Configuration)yamlConfiguration);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.plugin.setMensajesManager(new MensajesManager(this.getMessages().getString("prefix")));
    }

    public String getPath() {
        return this.rutaMessages;
    }
}

