/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.configs;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.PlayerConfig;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.PlayerTurretAmmoInventoryPage;
import ct.ajneb97.model.PlayerTurretAmmoInventorySlot;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class PlayerConfigsManager {
    private ArrayList<PlayerConfig> configPlayers;
    private ComplexTurrets plugin;

    public PlayerConfigsManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.configPlayers = new ArrayList();
    }

    public void configurar() {
        this.createPlayersFolder();
        this.registerPlayers();
        this.cargarJugadores();
    }

    public void createPlayersFolder() {
        try {
            File file = new File(this.plugin.getDataFolder() + File.separator + "players");
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            Object var1_2 = null;
        }
    }

    public void savePlayers() {
        int n = 0;
        while (n < this.configPlayers.size()) {
            this.configPlayers.get(n).savePlayerConfig();
            ++n;
        }
    }

    public void registerPlayers() {
        String string = this.plugin.getDataFolder() + File.separator + "players";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                String string2 = fileArray[n].getName();
                PlayerConfig playerConfig = new PlayerConfig(string2, this.plugin);
                playerConfig.registerPlayerConfig();
                this.configPlayers.add(playerConfig);
            }
            ++n;
        }
    }

    public ArrayList<PlayerConfig> getConfigPlayers() {
        return this.configPlayers;
    }

    public boolean archivoYaRegistrado(String string) {
        int n = 0;
        while (n < this.configPlayers.size()) {
            if (this.configPlayers.get(n).getPath().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public PlayerConfig getPlayerConfig(String string) {
        int n = 0;
        while (n < this.configPlayers.size()) {
            if (this.configPlayers.get(n).getPath().equals(string)) {
                return this.configPlayers.get(n);
            }
            ++n;
        }
        return null;
    }

    public ArrayList<PlayerConfig> getPlayerConfigs() {
        return this.configPlayers;
    }

    public boolean registerPlayer(String string) {
        if (!this.archivoYaRegistrado(string)) {
            PlayerConfig playerConfig = new PlayerConfig(string, this.plugin);
            playerConfig.registerPlayerConfig();
            this.configPlayers.add(playerConfig);
            return true;
        }
        return false;
    }

    public void removerConfigPlayer(String string) {
        int n = 0;
        while (n < this.configPlayers.size()) {
            if (this.configPlayers.get(n).getPath().equals(string)) {
                this.configPlayers.remove(n);
            }
            ++n;
        }
    }

    public void cargarJugadores() {
        ArrayList<PlayerData> arrayList = new ArrayList<PlayerData>();
        for (PlayerConfig playerConfig : this.configPlayers) {
            Object object2;
            FileConfiguration fileConfiguration = playerConfig.getConfig();
            String string = fileConfiguration.getString("name");
            String string2 = playerConfig.getPath().replace(".yml", "");
            ArrayList<PlayerTurret> arrayList2 = new ArrayList<PlayerTurret>();
            if (fileConfiguration.contains("turrets")) {
                for (Object object2 : fileConfiguration.getConfigurationSection("turrets").getKeys(false)) {
                    int n;
                    String string3;
                    int n2;
                    String string4 = fileConfiguration.getString("turrets." + (String)object2 + ".type");
                    int n3 = fileConfiguration.getInt("turrets." + (String)object2 + ".level");
                    boolean bl = fileConfiguration.getBoolean("turrets." + (String)object2 + ".enabled");
                    boolean bl2 = fileConfiguration.getBoolean("turrets." + (String)object2 + ".attack_monsters");
                    boolean bl3 = fileConfiguration.getBoolean("turrets." + (String)object2 + ".attack_players");
                    boolean bl4 = fileConfiguration.getBoolean("turrets." + (String)object2 + ".attack_animals");
                    boolean bl5 = fileConfiguration.getBoolean("turrets." + (String)object2 + ".attack_others");
                    TurretAttackPriority turretAttackPriority = TurretAttackPriority.CLOSEST;
                    if (fileConfiguration.contains("turrets." + (String)object2 + ".priority")) {
                        turretAttackPriority = TurretAttackPriority.valueOf(fileConfiguration.getString("turrets." + (String)object2 + ".priority"));
                    }
                    int n4 = fileConfiguration.getInt("turrets." + (String)object2 + ".ammo");
                    List<Object> list = new ArrayList();
                    if (fileConfiguration.contains("turrets." + (String)object2 + ".ammo_inventory")) {
                        for (String string5 : fileConfiguration.getConfigurationSection("turrets." + (String)object2 + ".ammo_inventory").getKeys(false)) {
                            Object object32;
                            n2 = Integer.valueOf(string5);
                            ArrayList<PlayerTurretAmmoInventorySlot> arrayList3 = new ArrayList<PlayerTurretAmmoInventorySlot>();
                            for (Object object32 : fileConfiguration.getConfigurationSection("turrets." + (String)object2 + ".ammo_inventory." + n2).getKeys(false)) {
                                string3 = "turrets." + (String)object2 + ".ammo_inventory." + n2 + "." + (String)object32;
                                n = Integer.valueOf((String)object32);
                                int n5 = fileConfiguration.getInt(String.valueOf(string3) + ".amount");
                                PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot = new PlayerTurretAmmoInventorySlot(n, n5);
                                arrayList3.add(playerTurretAmmoInventorySlot);
                            }
                            object32 = new PlayerTurretAmmoInventoryPage(n2, arrayList3);
                            list.add(object32);
                        }
                    } else if (n4 != 0) {
                        list = PlayerTurret.generateAmmoInventoryFromAmmo(n4);
                        n4 = 0;
                    }
                    boolean bl6 = fileConfiguration.getBoolean("turrets." + (String)object2 + ".infinite_ammo");
                    Object object4 = new ArrayList();
                    if (fileConfiguration.contains("turrets." + (String)object2 + ".whitelisted_players")) {
                        object4 = fileConfiguration.getStringList("turrets." + (String)object2 + ".whitelisted_players");
                    }
                    n2 = fileConfiguration.getInt("turrets." + (String)object2 + ".x");
                    int n6 = fileConfiguration.getInt("turrets." + (String)object2 + ".y");
                    int n7 = fileConfiguration.getInt("turrets." + (String)object2 + ".z");
                    World world = Bukkit.getWorld((String)fileConfiguration.getString("turrets." + (String)object2 + ".world"));
                    if (world == null) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(ComplexTurrets.nombrePlugin) + MensajesManager.getMensajeColor(" &cTurret &7" + (String)object2 + " &cof &7" + string + " &cis placed on an invalid world, it will be deleted!"));
                        continue;
                    }
                    string3 = new Location(world, (double)n2, (double)n6, (double)n7);
                    n = this.plugin.getTurretsManager().getMaxHealthTurret(string4, n3);
                    PlayerTurret playerTurret = new PlayerTurret(string4, n3, (Location)string3, bl2, bl3, bl4, bl5, turretAttackPriority, bl, n4, bl6, (List<String>)object4, string2, string, this.plugin, n, list, 0L);
                    arrayList2.add(playerTurret);
                }
            }
            object2 = new PlayerData(string2, string, arrayList2);
            arrayList.add((PlayerData)object2);
        }
        this.plugin.getJugadorManager().setPlayers(arrayList);
    }

    public void guardarJugadores() {
        for (PlayerData playerData : this.plugin.getJugadorManager().getPlayers()) {
            String string = playerData.getName();
            PlayerConfig playerConfig = this.getPlayerConfig(String.valueOf(playerData.getUuid()) + ".yml");
            if (playerConfig == null) {
                this.registerPlayer(String.valueOf(playerData.getUuid()) + ".yml");
                playerConfig = this.getPlayerConfig(String.valueOf(playerData.getUuid()) + ".yml");
            }
            FileConfiguration fileConfiguration = playerConfig.getConfig();
            fileConfiguration.set("name", (Object)string);
            fileConfiguration.set("turrets", null);
            int n = 1;
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                fileConfiguration.set("turrets." + n + ".type", (Object)playerTurret.getTurretName());
                fileConfiguration.set("turrets." + n + ".level", (Object)playerTurret.getTurretLevel());
                fileConfiguration.set("turrets." + n + ".enabled", (Object)playerTurret.isEnabled());
                Location location = playerTurret.getLocation();
                fileConfiguration.set("turrets." + n + ".x", (Object)location.getBlockX());
                fileConfiguration.set("turrets." + n + ".y", (Object)location.getBlockY());
                fileConfiguration.set("turrets." + n + ".z", (Object)location.getBlockZ());
                fileConfiguration.set("turrets." + n + ".world", (Object)location.getWorld().getName());
                fileConfiguration.set("turrets." + n + ".attack_monsters", (Object)playerTurret.isAttackMonsters());
                fileConfiguration.set("turrets." + n + ".attack_players", (Object)playerTurret.isAttackPlayers());
                fileConfiguration.set("turrets." + n + ".attack_animals", (Object)playerTurret.isAttackAnimals());
                fileConfiguration.set("turrets." + n + ".attack_others", (Object)playerTurret.isAttackOthers());
                fileConfiguration.set("turrets." + n + ".priority", (Object)playerTurret.getPriority().name());
                List<PlayerTurretAmmoInventoryPage> list = playerTurret.getAmmoInventoryPages();
                for (PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage : list) {
                    int n2 = playerTurretAmmoInventoryPage.getPage();
                    List<PlayerTurretAmmoInventorySlot> list2 = playerTurretAmmoInventoryPage.getSlots();
                    for (PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot : list2) {
                        int n3 = playerTurretAmmoInventorySlot.getSlot();
                        String string2 = "turrets." + n + ".ammo_inventory." + n2 + "." + n3;
                        fileConfiguration.set(String.valueOf(string2) + ".amount", (Object)playerTurretAmmoInventorySlot.getAmount());
                    }
                }
                fileConfiguration.set("turrets." + n + ".infinite_ammo", (Object)playerTurret.isInfiniteAmmo());
                if (!playerTurret.getWhitelistedPlayers().isEmpty()) {
                    fileConfiguration.set("turrets." + n + ".whitelisted_players", playerTurret.getWhitelistedPlayers());
                }
                ++n;
            }
        }
        this.savePlayers();
    }
}

