/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.listeners;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.InventoryManager;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.ClosePlayerInventoryReason;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerInventory;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryListener
implements Listener {
    private ComplexTurrets plugin;

    public InventoryListener(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    @EventHandler
    public void closeInventory(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        PlayerInventory playerInventory = this.plugin.getInventoryManager().getPlayerInventory(player);
        if (playerInventory != null && playerInventory.getInventoryType().equals("ammunition") && playerInventory.getCloseReason() == null) {
            this.plugin.getInventoryManager().saveAmmo(playerInventory.getTurret(), inventoryCloseEvent.getView().getTopInventory(), playerInventory);
        }
        this.plugin.getInventoryManager().removePlayerInventory(player);
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        PlayerInventory playerInventory = this.plugin.getInventoryManager().getPlayerInventory(player);
        if (playerInventory != null) {
            String string = playerInventory.getInventoryType();
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            InventoryManager inventoryManager = this.plugin.getInventoryManager();
            PlayerTurret playerTurret = playerInventory.getTurret();
            if (string.equals("ammunition")) {
                return;
            }
            inventoryClickEvent.setCancelled(true);
            if (itemStack == null) {
                return;
            }
            if (inventoryClickEvent.getSlotType() == null) {
                return;
            }
            if (inventoryClickEvent.getClickedInventory().equals(player.getOpenInventory().getTopInventory())) {
                String string2;
                if (itemStack != null) {
                    string2 = ItemManager.getTagStringItem(itemStack, "complex_turrets_open_inventory");
                    if (string2 != null) {
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string2), playerInventory);
                        return;
                    }
                    inventoryManager.executeItemCommands(itemStack, player);
                }
                if ((string2 = ItemManager.getTagStringItem(itemStack, "complex_turrets_item_type")) == null) {
                    return;
                }
                if (string.equals("main")) {
                    if (string2.equals("turret_options_item")) {
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName("options"), playerInventory);
                    } else if (string2.equals("turret_upgrade")) {
                        int n = ItemManager.getTagIntItem(itemStack, "complex_turrets_last_upgrade");
                        if (n == 0 && inventoryManager.upgradeTurret(player, playerTurret)) {
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                        }
                    } else if (string2.equals("delete_turret_item") && inventoryManager.destroyTurret(player, playerTurret)) {
                        player.closeInventory();
                    }
                } else if (string.equals("options")) {
                    FileConfiguration fileConfiguration = this.plugin.getMessages();
                    MensajesManager mensajesManager = this.plugin.getMensajesManager();
                    if (string2.equals("whitelisted_players_item")) {
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName("whitelist"), playerInventory);
                    } else if (string2.equals("turret_status_item")) {
                        playerTurret.setEnabled(!playerTurret.isEnabled());
                        this.plugin.getJugadorManager().updateInformationHologram(playerTurret);
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    } else if (string2.equals("turret_ammo_item")) {
                        TurretsManager turretsManager = this.plugin.getTurretsManager();
                        Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
                        if (turret.isRequireAmmunition()) {
                            playerInventory.setPage(1);
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName("ammunition"), playerInventory);
                        }
                    } else if (string2.equals("attack_players_item")) {
                        if (!(player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.options.attackplayers"))) {
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretAttackOptionNoPermissions"), true);
                            return;
                        }
                        playerTurret.setAttackPlayers(!playerTurret.isAttackPlayers());
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    } else if (string2.equals("attack_monsters_item")) {
                        if (!(player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.options.attackmonsters"))) {
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretAttackOptionNoPermissions"), true);
                            return;
                        }
                        playerTurret.setAttackMonsters(!playerTurret.isAttackMonsters());
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    } else if (string2.equals("attack_animals_item")) {
                        if (!(player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.options.attackanimals"))) {
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretAttackOptionNoPermissions"), true);
                            return;
                        }
                        playerTurret.setAttackAnimals(!playerTurret.isAttackAnimals());
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    } else if (string2.equals("attack_others_item")) {
                        if (!(player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.options.attackothers"))) {
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretAttackOptionNoPermissions"), true);
                            return;
                        }
                        playerTurret.setAttackOthers(!playerTurret.isAttackOthers());
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    } else if (string2.equals("priority_item")) {
                        if (!(player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.options.priority"))) {
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretAttackOptionNoPermissions"), true);
                            return;
                        }
                        if (playerTurret.getPriority().equals((Object)TurretAttackPriority.CLOSEST)) {
                            playerTurret.setPriority(TurretAttackPriority.HEALTH);
                        } else {
                            playerTurret.setPriority(TurretAttackPriority.CLOSEST);
                        }
                        inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                    }
                } else if (string.equals("whitelist")) {
                    String string3 = ItemManager.getTagStringItem(itemStack, "complex_turrets_whitelisted_player_name");
                    if (string2.equals("whitelist_add_player_item")) {
                        player.closeInventory();
                        FileConfiguration fileConfiguration = this.plugin.getMessages();
                        MensajesManager mensajesManager = this.plugin.getMensajesManager();
                        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionPlayersAddPlayerInfo"), true);
                        inventoryManager.addPlayerInventory(new PlayerInventory(player, "whitelist_chat_inventory", playerTurret, 1));
                        return;
                    }
                    if (string2.equals("whitelist_apply_item")) {
                        FileConfiguration fileConfiguration = this.plugin.getMessages();
                        MensajesManager mensajesManager = this.plugin.getMensajesManager();
                        ArrayList<String> arrayList = new ArrayList<String>(playerTurret.getWhitelistedPlayers());
                        PlayerData playerData = this.plugin.getJugadorManager().getPlayerData(player);
                        ArrayList<PlayerTurret> arrayList2 = playerData.getTurrets();
                        for (PlayerTurret playerTurret2 : arrayList2) {
                            playerTurret2.setWhitelistedPlayers(new ArrayList<String>(arrayList));
                        }
                        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("whitelistApply"), true);
                        return;
                    }
                    if (string3 != null) {
                        FileConfiguration fileConfiguration = this.plugin.getConfig();
                        String string4 = fileConfiguration.getString("remove_player_from_whitelist_click_type");
                        ClickType clickType = ClickType.RIGHT;
                        if (string4.equals("LEFT")) {
                            clickType = ClickType.LEFT;
                        }
                        if (inventoryClickEvent.getClick().equals((Object)clickType)) {
                            FileConfiguration fileConfiguration2 = this.plugin.getMessages();
                            MensajesManager mensajesManager = this.plugin.getMensajesManager();
                            playerTurret.getWhitelistedPlayers().remove(string3);
                            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration2.getString("turretOptionPlayerRemoved").replace("%name%", string3), true);
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void inventoryClickAmmunition(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        PlayerInventory playerInventory = this.plugin.getInventoryManager().getPlayerInventory(player);
        if (playerInventory != null && inventoryClickEvent.getClickedInventory() != null) {
            String string = playerInventory.getInventoryType();
            InventoryManager inventoryManager = this.plugin.getInventoryManager();
            PlayerTurret playerTurret = playerInventory.getTurret();
            if (string.equals("ammunition")) {
                ItemStack itemStack = inventoryClickEvent.getCurrentItem();
                if (inventoryClickEvent.getClick().equals((Object)ClickType.NUMBER_KEY) || inventoryClickEvent.getClick().name().equals("SWAP_OFFHAND")) {
                    inventoryClickEvent.setCancelled(true);
                    return;
                }
                if (inventoryClickEvent.getClickedInventory().equals(player.getOpenInventory().getTopInventory())) {
                    String string2;
                    if (itemStack != null) {
                        string2 = ItemManager.getTagStringItem(itemStack, "complex_turrets_open_inventory");
                        if (string2 != null) {
                            inventoryClickEvent.setCancelled(true);
                            inventoryManager.saveAmmo(playerTurret, inventoryClickEvent.getClickedInventory(), playerInventory);
                            playerInventory.setCloseReason(ClosePlayerInventoryReason.ITEM);
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string2), playerInventory);
                            return;
                        }
                        if (inventoryManager.executeItemCommands(itemStack, player)) {
                            inventoryClickEvent.setCancelled(true);
                            inventoryManager.saveAmmo(playerTurret, inventoryClickEvent.getClickedInventory(), playerInventory);
                        }
                    }
                    if ((string2 = ItemManager.getTagStringItem(itemStack, "complex_turrets_item_type")) != null) {
                        if (string2.equals("infinite_ammo_item")) {
                            inventoryClickEvent.setCancelled(true);
                            if (player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.infiniteammo")) {
                                playerTurret.setInfiniteAmmo(!playerTurret.isInfiniteAmmo());
                                inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                            }
                        } else if (string2.equals("ammo_item")) {
                            if (playerTurret.isEnabled()) {
                                inventoryClickEvent.setCancelled(true);
                                FileConfiguration fileConfiguration = this.plugin.getMessages();
                                MensajesManager mensajesManager = this.plugin.getMensajesManager();
                                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAmmunitionDisabledError"), true);
                            }
                        } else if (string2.equals("ammo_next_page")) {
                            inventoryClickEvent.setCancelled(true);
                            this.plugin.getInventoryManager().saveAmmo(playerInventory.getTurret(), inventoryClickEvent.getView().getTopInventory(), playerInventory);
                            playerInventory.setPage(playerInventory.getPage() + 1);
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                        } else if (string2.equals("ammo_previous_page")) {
                            inventoryClickEvent.setCancelled(true);
                            this.plugin.getInventoryManager().saveAmmo(playerInventory.getTurret(), inventoryClickEvent.getView().getTopInventory(), playerInventory);
                            playerInventory.setPage(playerInventory.getPage() - 1);
                            inventoryManager.openInventory(player, playerTurret, inventoryManager.getInventoryByName(string), playerInventory);
                        } else {
                            this.plugin.getInventoryManager().saveAmmo(playerInventory.getTurret(), inventoryClickEvent.getView().getTopInventory(), playerInventory);
                            inventoryClickEvent.setCancelled(true);
                        }
                    } else if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) {
                        inventoryClickEvent.setCancelled(true);
                    }
                } else if (inventoryClickEvent.getClickedInventory().equals(player.getOpenInventory().getBottomInventory()) && itemStack != null && inventoryClickEvent.getSlotType() != null && !itemStack.getType().equals((Object)Material.AIR)) {
                    FileConfiguration fileConfiguration = this.plugin.getMessages();
                    MensajesManager mensajesManager = this.plugin.getMensajesManager();
                    if (playerTurret.isEnabled()) {
                        inventoryClickEvent.setCancelled(true);
                        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAmmunitionDisabledError"), true);
                        return;
                    }
                    String string3 = ItemManager.getTagStringItem(itemStack, "complex_turrets_ammunition_id");
                    if (string3 == null || !string3.equals(playerTurret.getTurretName())) {
                        inventoryClickEvent.setCancelled(true);
                        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAmmunitionError"), true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler
    public void playerWhitelistAdd(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        final Player player = asyncPlayerChatEvent.getPlayer();
        final PlayerInventory playerInventory = this.plugin.getInventoryManager().getPlayerInventory(player);
        if (playerInventory != null && playerInventory.getInventoryType().equals("whitelist_chat_inventory")) {
            FileConfiguration fileConfiguration = this.plugin.getMessages();
            MensajesManager mensajesManager = this.plugin.getMensajesManager();
            asyncPlayerChatEvent.setCancelled(true);
            String string = ChatColor.stripColor((String)asyncPlayerChatEvent.getMessage());
            if (string.contains(" ")) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAddPlayerNotValid"), true);
                return;
            }
            List<String> list = playerInventory.getTurret().getWhitelistedPlayers();
            if (string.equalsIgnoreCase(player.getName())) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAddPlayerOwnName"), true);
                return;
            }
            if (list.contains(string)) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAddPlayerAlreadyAdded"), true);
                return;
            }
            list.add(string);
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretOptionAddPlayerSuccess").replace("%name%", string), true);
            final InventoryManager inventoryManager = this.plugin.getInventoryManager();
            inventoryManager.removePlayerInventory(player);
            new BukkitRunnable(){

                public void run() {
                    inventoryManager.openInventory(player, playerInventory.getTurret(), inventoryManager.getInventoryByName("whitelist"), playerInventory);
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
        }
    }
}

