/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import com.github.rumsfield.konquest.api.KonquestAPI;
import com.github.rumsfield.konquest.api.model.KonquestKingdom;
import com.github.rumsfield.konquest.api.model.KonquestPlayer;
import com.github.rumsfield.konquest.api.model.KonquestTerritory;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.WorldGuardManager;
import ct.ajneb97.model.RegionCompatibility;
import dansplugins.factionsystem.externalapi.MedievalFactionsAPI;
import java.util.List;
import me.angeschossen.lands.api.integration.LandsIntegration;
import me.angeschossen.lands.api.land.Land;
import me.angeschossen.lands.api.player.LandPlayer;
import me.ulrich.clans.interfaces.UClans;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;

public class RegionManager {
    private ComplexTurrets plugin;
    private RegionCompatibility regionCompatibility;
    private LandsIntegration landsIntegration;
    private SimpleClans simpleClanIntegration;
    private UClans ultimateClansIntegration;
    private MedievalFactionsAPI medievalFactionsIntegration;
    private KonquestAPI konquestIntegration;

    public RegionManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.configurar();
    }

    public void configurar() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Factions") != null) {
            List list = Bukkit.getServer().getPluginManager().getPlugin("Factions").getDescription().getAuthors();
            if (list.contains("drtshock") && list.contains("ProSavage")) {
                this.regionCompatibility = RegionCompatibility.SABER_FACTIONS;
            } else if (list.contains("drtshock") && list.contains("mbaxter")) {
                this.regionCompatibility = RegionCompatibility.FACTIONS_UUID;
            }
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Towny") != null) {
            this.regionCompatibility = RegionCompatibility.TOWNY;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Clans") != null) {
            this.regionCompatibility = RegionCompatibility.CLANS;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Lands") != null) {
            this.regionCompatibility = RegionCompatibility.LANDS;
            this.landsIntegration = new LandsIntegration((Plugin)this.plugin);
        } else if (Bukkit.getServer().getPluginManager().getPlugin("BetterTeams") != null) {
            this.regionCompatibility = RegionCompatibility.BETTER_TEAMS;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("GangsPlus") != null) {
            this.regionCompatibility = RegionCompatibility.GANGS_PLUS;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("SimpleClans") != null) {
            this.regionCompatibility = RegionCompatibility.SIMPLE_CLANS;
            this.simpleClanIntegration = (SimpleClans)Bukkit.getServer().getPluginManager().getPlugin("SimpleClans");
        } else if (Bukkit.getServer().getPluginManager().getPlugin("UltimateClans") != null) {
            this.regionCompatibility = RegionCompatibility.ULTIMATE_CLANS;
            this.ultimateClansIntegration = (UClans)Bukkit.getPluginManager().getPlugin("UltimateClans");
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Kingdoms") != null) {
            this.regionCompatibility = RegionCompatibility.KINGDOMS;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("MedievalFactions") != null) {
            this.regionCompatibility = RegionCompatibility.MEDIEVAL_FACTIONS;
            this.medievalFactionsIntegration = new MedievalFactionsAPI();
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Konquest") != null) {
            RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(KonquestAPI.class);
            if (registeredServiceProvider != null) {
                this.konquestIntegration = (KonquestAPI)registeredServiceProvider.getProvider();
                this.regionCompatibility = RegionCompatibility.KONQUEST;
            }
        } else if (Bukkit.getServer().getPluginManager().getPlugin("Residence") != null) {
            this.regionCompatibility = RegionCompatibility.RESIDENCE;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.regionCompatibility = RegionCompatibility.WORLDGUARD;
        }
    }

    public RegionCompatibility getRegionCompatibility() {
        return this.regionCompatibility;
    }

    public boolean isOwnerRegion(Player player, Location location) {
        if (this.regionCompatibility == null) {
            return false;
        }
        switch (this.regionCompatibility) {
            case LANDS: {
                return this.isOwnerRegionLands(player, location);
            }
            case SABER_FACTIONS: {
                return this.isOwnerRegionSaberFactions(player, location);
            }
            case FACTIONS_UUID: {
                return this.isOwnerRegionFactionsUUID(player, location);
            }
            case TOWNY: {
                return this.isOwnerRegionTowny(player, location);
            }
            case GANGS_PLUS: {
                return this.isOwnerRegionGangsPlus(player, location);
            }
            case SIMPLE_CLANS: {
                return this.isOwnerRegionSimpleClans(player, location);
            }
            case ULTIMATE_CLANS: {
                return this.isOwnerRegionUltimateClans(player, location);
            }
            case KINGDOMS: {
                return this.isOwnerRegionKingdoms(player, location);
            }
            case MEDIEVAL_FACTIONS: {
                return this.isOwnerRegionMedievalFactions(player, location);
            }
            case KONQUEST: {
                return this.isOwnerRegionKonquest(player, location);
            }
            case RESIDENCE: {
                return this.isOwnerRegionResidence(player, location);
            }
            case WORLDGUARD: {
                return this.isOwnerRegionWorldGuard(player, location);
            }
        }
        return false;
    }

    private boolean isOwnerRegionKingdoms(Player player, Location location) {
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kingdomPlayer == null) {
            return false;
        }
        org.kingdoms.constants.land.Land land = org.kingdoms.constants.land.Land.getLand((Location)location);
        if (land == null) {
            return false;
        }
        if (land.isClaimed()) {
            Kingdom kingdom = land.getKingdom();
            Kingdom kingdom2 = kingdomPlayer.getKingdom();
            return kingdom2 != null && kingdom2.getId().equals(kingdom.getId());
        }
        return false;
    }

    private boolean isOwnerRegionUltimateClans(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionLands(Player player, Location location) {
        LandPlayer landPlayer = this.landsIntegration.getLandPlayer(player.getUniqueId());
        Land land = this.landsIntegration.getLand(location);
        if (land == null) {
            return false;
        }
        if (land.exists()) {
            for (Land land2 : landPlayer.getLands()) {
                if (!land2.getName().equals(land.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOwnerRegionTowny(Player player, Location location) {
        Town town;
        Town town2;
        block4: {
            Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
            town2 = TownyAPI.getInstance().getTown(location);
            if (town2 == null) {
                return false;
            }
            try {
                town = resident.getTown();
                if (town != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return town.getName().equals(town2.getName());
    }

    private boolean isOwnerRegionSaberFactions(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionFactionsUUID(Player player, Location location) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        FLocation fLocation = new FLocation(location);
        Faction faction = Board.getInstance().getFactionAt(fLocation);
        if (faction == null || fPlayer == null) {
            return false;
        }
        return faction.getId().equals(fPlayer.getFactionId());
    }

    private boolean isOwnerRegionGangsPlus(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionSimpleClans(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionMedievalFactions(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionKonquest(Player player, Location location) {
        KonquestTerritory konquestTerritory = this.konquestIntegration.getTerritoryManager().getChunkTerritory(location);
        if (konquestTerritory == null) {
            return false;
        }
        KonquestKingdom konquestKingdom = konquestTerritory.getKingdom();
        if (konquestKingdom == null) {
            return false;
        }
        KonquestPlayer konquestPlayer = this.konquestIntegration.getPlayerManager().getPlayer(player);
        KonquestKingdom konquestKingdom2 = konquestPlayer.getKingdom();
        return konquestKingdom2 != null && konquestKingdom2.getName().equals(konquestKingdom.getName());
    }

    private boolean isOwnerRegionResidence(Player player, Location location) {
        return false;
    }

    private boolean isOwnerRegionWorldGuard(Player player, Location location) {
        WorldGuardManager worldGuardManager = this.plugin.getDependencyManager().getWorldGuardManager();
        if (worldGuardManager == null) {
            return true;
        }
        return worldGuardManager.isOwnerCurrentRegion(location, player);
    }
}

