/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.MainConfigManager;
import ct.ajneb97.configs.others.ConfigArmorDurability;
import ct.ajneb97.managers.DependencyManager;
import ct.ajneb97.managers.holograms.HologramsManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.TurretEntityType;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.model.estructura.UpgradeAction;
import ct.ajneb97.model.others.ArmorItemSlot;
import ct.ajneb97.model.others.GeneratedDamage;
import ct.ajneb97.model.others.ProtectionLevel;
import ct.ajneb97.utils.UtilsEntities;
import ct.ajneb97.utils.UtilsMath;
import ct.ajneb97.utils.UtilsOthers;
import ct.ajneb97.utils.UtilsPlayers;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ShootManager {
    private ComplexTurrets plugin;
    private DecimalFormat decimalFormat;

    public ShootManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.decimalFormat = new DecimalFormat("#.##");
    }

    public void hitEntity(final Entity entity, final Location location, final Turret turret, final PlayerTurret playerTurret, final TurretUpgrade turretUpgrade) {
        new BukkitRunnable(){

            public void run() {
                Object object;
                Object object2;
                double d;
                ArrayList<Entity> arrayList = new ArrayList<Entity>();
                if (entity != null) {
                    arrayList.add(entity);
                }
                if ((d = turretUpgrade.getSplashRadius()) != 0.0) {
                    object2 = ShootManager.this.plugin.getDependencyManager();
                    boolean bl = ShootManager.this.plugin.getConfigsManager().getMainConfigManager().isIgnoreDamageToInvisiblePlayers();
                    Collection collection = location.getWorld().getNearbyEntities(location, d, d, d);
                    for (Entity entity2 : collection) {
                        if (entity2 == null || entity2.isDead() || arrayList.contains(entity2) || ((Enum)(object = UtilsEntities.getEntityType(entity2))).equals((Object)TurretEntityType.INVALID)) continue;
                        if (((Enum)object).equals((Object)TurretEntityType.PLAYER)) {
                            Player player = (Player)entity2;
                            if (((DependencyManager)object2).isNPC(entity2) || !UtilsPlayers.isSurvival(player) || bl && (UtilsPlayers.isInVanish(player) || UtilsPlayers.isInvisible(player))) continue;
                        }
                        arrayList.add(entity2);
                    }
                }
                object2 = ShootManager.this.plugin.getDependencyManager().getHologramsManager();
                MainConfigManager mainConfigManager = ShootManager.this.plugin.getConfigsManager().getMainConfigManager();
                boolean bl = mainConfigManager.isHitHolograms();
                int n = mainConfigManager.getHitHologramsDisappearTime();
                String string = playerTurret.getOwnerName();
                object = GeneratedDamage.generateDamage(turret, turretUpgrade);
                double d2 = ((GeneratedDamage)object).getMinValue();
                double d3 = ((GeneratedDamage)object).getMaxValue();
                boolean bl2 = ((GeneratedDamage)object).isDamage();
                boolean bl3 = ((GeneratedDamage)object).isCritical();
                for (Entity entity3 : arrayList) {
                    double d4 = UtilsMath.getRandomNumber((int)d2, (int)d3) / 100.0;
                    if (bl2) {
                        d4 = ShootManager.this.getValueWithReduction(d4, turretUpgrade.getEntityDamageReduction(), turretUpgrade.getShieldReduction(), (LivingEntity)entity3);
                    }
                    if (bl) {
                        String string2 = ShootManager.this.decimalFormat.format(d4).replace(",", ".");
                        ((HologramsManager)object2).createHitHologram(turret, string2, string, entity3.getLocation(), n, bl3);
                    }
                    ShootManager.this.executeActions((LivingEntity)entity3, turretUpgrade, playerTurret);
                    if (bl2) {
                        ShootManager.this.damageEntity((LivingEntity)entity3, d4, playerTurret);
                        continue;
                    }
                    ShootManager.this.healEntity((LivingEntity)entity3, d4);
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    public void healEntity(LivingEntity livingEntity, double d) {
        double d2 = livingEntity.getHealth() + d;
        if (d2 >= livingEntity.getMaxHealth()) {
            livingEntity.setHealth(livingEntity.getMaxHealth());
        } else {
            livingEntity.setHealth(d2);
        }
    }

    public double getValueWithReduction(double d, String string, double d2, LivingEntity livingEntity) {
        ProtectionLevel protectionLevel;
        if (string != null) {
            protectionLevel = UtilsEntities.getProtectionLevel(livingEntity);
            String string2 = string.replace("%armor%", String.valueOf(protectionLevel.getArmor())).replace("%protection_projectile_level%", String.valueOf(protectionLevel.getProtectionProjectileLevel())).replace("%protection_environmental_level%", String.valueOf(protectionLevel.getProtectionEnvironmentalLevel())).replace("%protection_explosions_level%", String.valueOf(protectionLevel.getProtectionExplosionsLevel())).replace("%protection_fire_level%", String.valueOf(protectionLevel.getProtectionFireLevel())).replace("%armor_toughness%", String.valueOf(protectionLevel.getArmorToughness()));
            double d3 = UtilsMath.eval(string2);
            if (d3 >= 1.0) {
                d3 = 1.0;
            } else if (d3 <= 0.0) {
                d3 = 0.0;
            }
            d *= 1.0 - d3;
        }
        if (livingEntity instanceof Player && d2 != 0.0 && UtilsPlayers.isBlockingWithShield((Player)(protectionLevel = (Player)livingEntity))) {
            d *= 1.0 - d2;
        }
        return d;
    }

    public void damageEntity(final LivingEntity livingEntity, double d, PlayerTurret playerTurret) {
        int n = livingEntity.getMaximumNoDamageTicks();
        livingEntity.setMaximumNoDamageTicks(0);
        livingEntity.setMetadata("complexturrets_damaged", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)playerTurret));
        livingEntity.damage(0.001);
        this.reduceArmorDurability(livingEntity, d);
        double d2 = livingEntity.getHealth();
        double d3 = d2 - d;
        if (d3 <= 0.0) {
            livingEntity.setHealth(0.0);
        } else {
            livingEntity.setHealth(d3);
        }
        livingEntity.setMaximumNoDamageTicks(n);
        new BukkitRunnable(){

            public void run() {
                livingEntity.removeMetadata("complexturrets_damaged", (Plugin)ShootManager.this.plugin);
            }
        }.runTaskLater((Plugin)this.plugin, 4L);
    }

    public void executeActions(LivingEntity livingEntity, TurretUpgrade turretUpgrade, PlayerTurret playerTurret) {
        ArrayList<UpgradeAction> arrayList = turretUpgrade.getActions();
        Random random = new Random();
        for (UpgradeAction upgradeAction : arrayList) {
            int n = random.nextInt(10001);
            int n2 = (int)upgradeAction.getProbability() * 100;
            if (n2 < n) continue;
            String string = upgradeAction.getType();
            int n3 = upgradeAction.getDuration();
            if (string.startsWith("potion_effect: ")) {
                this.actionPotionEffect(livingEntity, string, n3);
                continue;
            }
            if (string.equals("set_on_fire")) {
                this.actionSetOnFire(livingEntity, n3);
                continue;
            }
            if (string.startsWith("knockback: ")) {
                this.actionKnockback(livingEntity, string, playerTurret);
                continue;
            }
            if (!string.equals("freeze")) continue;
            this.actionFreeze(livingEntity, n3);
        }
    }

    public void actionKnockback(LivingEntity livingEntity, String string, PlayerTurret playerTurret) {
        string = string.replace("knockback: ", "");
        double d = Double.valueOf(string);
        Vector vector = livingEntity.getLocation().toVector();
        Vector vector2 = playerTurret.getLocation().toVector();
        Vector vector3 = vector.clone().subtract(vector2.clone()).normalize();
        Vector vector4 = vector3.clone();
        vector4.multiply(d);
        livingEntity.setVelocity(vector4);
    }

    public void actionSetOnFire(LivingEntity livingEntity, int n) {
        livingEntity.setFireTicks(n * 20);
    }

    public void actionFreeze(LivingEntity livingEntity, int n) {
        if (Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || UtilsOthers.isChatNew()) {
            livingEntity.setFreezeTicks(n * 20);
        }
    }

    public void actionPotionEffect(LivingEntity livingEntity, String string, int n) {
        string = string.replace("potion_effect: ", "");
        String[] stringArray = string.split(";");
        try {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)stringArray[0]);
            int n2 = Integer.valueOf(stringArray[1]);
            PotionEffect potionEffect = new PotionEffect(potionEffectType, n * 20, n2 - 1);
            livingEntity.addPotionEffect(potionEffect);
        }
        catch (Exception exception) {}
    }

    public void reduceArmorDurability(LivingEntity livingEntity, double d) {
        Object object2;
        ItemStack itemStack;
        boolean bl;
        ConfigArmorDurability configArmorDurability = this.plugin.getConfigsManager().getMainConfigManager().getConfigArmorDurability();
        if (!configArmorDurability.isEnabled()) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        Sound sound = null;
        sound = Bukkit.getVersion().contains("1.8") ? Sound.valueOf((String)"ITEM_BREAK") : Sound.ENTITY_ITEM_BREAK;
        if (d >= configArmorDurability.getMinDamageToReduceDurability()) {
            bl = configArmorDurability.isReduceDurabilityOneArmorSlotPerHit();
            itemStack = new ArrayList();
            itemStack.add(new ArmorItemSlot(entityEquipment.getHelmet(), "HELMET"));
            itemStack.add(new ArmorItemSlot(entityEquipment.getChestplate(), "CHESTPLATE"));
            itemStack.add(new ArmorItemSlot(entityEquipment.getLeggings(), "LEGGINGS"));
            itemStack.add(new ArmorItemSlot(entityEquipment.getBoots(), "BOOTS"));
            if (!bl) {
                for (Object object2 : itemStack) {
                    ItemStack itemStack2 = ((ArmorItemSlot)object2).getItem();
                    String string = ((ArmorItemSlot)object2).getSlot();
                    if (itemStack2 == null || itemStack2.getType().equals((Object)Material.AIR)) continue;
                    UtilsPlayers.reduceDurabilityItem(player, entityEquipment, sound, itemStack2, string);
                }
            } else {
                int n = 0;
                while (n < itemStack.size()) {
                    ItemStack itemStack3 = ((ArmorItemSlot)itemStack.get(n)).getItem();
                    if (itemStack3 == null || itemStack3.getType().equals((Object)Material.AIR)) {
                        itemStack.remove(n);
                        --n;
                    }
                    ++n;
                }
                if (!itemStack.isEmpty()) {
                    object2 = new Random();
                    int n2 = ((Random)object2).nextInt(itemStack.size());
                    ArmorItemSlot armorItemSlot = (ArmorItemSlot)itemStack.get(n2);
                    UtilsPlayers.reduceDurabilityItem(player, entityEquipment, sound, armorItemSlot.getItem(), armorItemSlot.getSlot());
                }
            }
        }
        if (Bukkit.getVersion().contains("1.8")) {
            return;
        }
        bl = player.isBlocking();
        if (!bl) {
            return;
        }
        itemStack = player.getInventory().getItemInMainHand();
        object2 = player.getInventory().getItemInOffHand();
        if (itemStack != null && itemStack.getType().equals((Object)Material.SHIELD)) {
            UtilsPlayers.reduceDurabilityItem(player, entityEquipment, sound, itemStack, "HAND");
        } else if (object2 != null && object2.getType().equals((Object)Material.SHIELD)) {
            UtilsPlayers.reduceDurabilityItem(player, entityEquipment, sound, (ItemStack)object2, "OFF_HAND");
        }
    }
}

