/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.MainConfigManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.model.others.SavedTurretProperties;
import ct.ajneb97.utils.UtilsOthers;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;

public class TurretsManager {
    private ArrayList<Turret> turrets = new ArrayList();
    private ComplexTurrets plugin;

    public TurretsManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public ArrayList<Turret> getTurrets() {
        return this.turrets;
    }

    public void setTurrets(ArrayList<Turret> arrayList) {
        this.turrets = arrayList;
    }

    public Turret getTurret(String string) {
        for (Turret turret : this.turrets) {
            if (!turret.getName().equals(string)) continue;
            return turret;
        }
        return null;
    }

    public int getMaxHealthTurret(String string, int n) {
        Turret turret = this.getTurret(string);
        if (turret != null) {
            return turret.getUpgrade(n).getHealth();
        }
        return 0;
    }

    public void createTurret(Player player, Turret turret, int n, Location location, SavedTurretProperties savedTurretProperties) {
        this.createStructure(turret, location);
        int n2 = turret.getUpgrade(n).getHealth();
        int n3 = turret.getActivationDelay();
        long l = 0L;
        if (n3 != 0) {
            l = System.currentTimeMillis() + (long)(n3 * 1000);
        }
        PlayerTurret playerTurret = PlayerTurret.createDefault(turret.getName(), n, location, player.getUniqueId().toString(), player.getName(), this.plugin, n2, turret, l);
        if (savedTurretProperties != null) {
            playerTurret.setAttackAnimals(savedTurretProperties.isAttackAnimals());
            playerTurret.setAttackMonsters(savedTurretProperties.isAttackMonsters());
            playerTurret.setAttackOthers(savedTurretProperties.isAttackOthers());
            playerTurret.setAttackPlayers(savedTurretProperties.isAttackPlayers());
            playerTurret.setPriority(savedTurretProperties.getPriority());
            playerTurret.setWhitelistedPlayers(new ArrayList<String>(savedTurretProperties.getWhitelistedPlayers()));
        }
        this.plugin.getJugadorManager().addTurret(player.getUniqueId().toString(), player.getName(), playerTurret);
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        if (mainConfigManager.isInformationHolograms() && mainConfigManager.isInformationHologramsAlwaysVisible()) {
            this.plugin.getDependencyManager().getHologramsManager().createInformationHologram(null, playerTurret);
        }
    }

    public void createTurret(PlayerTurret playerTurret) {
        this.plugin.getJugadorManager().addTurret(playerTurret.getOwnerUUID(), playerTurret.getOwnerName(), playerTurret);
    }

    public void createStructure(Turret turret, Location location) {
        List<String> list = turret.getStructure();
        int n = 0;
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            Material material;
            String[] stringArray;
            Location location2 = location.clone().add(0.0, (double)n, 0.0);
            if (list.get(n2).startsWith("ey")) {
                if (UtilsOthers.isLegacy()) {
                    location2.getBlock().setType(Material.valueOf((String)"SKULL"));
                } else {
                    location2.getBlock().setType(Material.valueOf((String)"PLAYER_HEAD"));
                }
                stringArray = (String[])location2.getBlock().getState();
                if (UtilsOthers.isLegacy()) {
                    stringArray.setSkullType(SkullType.PLAYER);
                    stringArray.setRawData((byte)1);
                }
                material = new GameProfile(UUID.randomUUID(), "");
                material.getProperties().put((Object)"textures", (Object)new Property("textures", list.get(n2)));
                try {
                    Field field = stringArray.getClass().getDeclaredField("profile");
                    field.setAccessible(true);
                    field.set(stringArray, material);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    exception.printStackTrace();
                }
                stringArray.update();
            } else if (list.get(n2).contains(":")) {
                stringArray = list.get(n2).split(":");
                material = Material.valueOf((String)stringArray[0]);
                byte by = Byte.valueOf(stringArray[1]);
                Block block = location2.getBlock();
                block.setType(material);
                BlockState blockState = block.getState();
                blockState.setData(new MaterialData(material, by));
                blockState.update();
            } else {
                location2.getBlock().setType(Material.valueOf((String)list.get(n2)));
            }
            ++n;
            --n2;
        }
    }

    public int getMaxAmmo(Turret turret, int n) {
        int n2 = this.plugin.getConfigsManager().getMainConfigManager().getDefaultMaxAmmo();
        TurretUpgrade turretUpgrade = turret.getUpgrade(n);
        if (turretUpgrade != null && turretUpgrade.getMaxAmmo() != 0) {
            n2 = turretUpgrade.getMaxAmmo();
        }
        return n2;
    }
}

