/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class VerifyManager {
    private ComplexTurrets plugin;

    public VerifyManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public boolean verifyPlaceTurret(Turret turret, Player player, Location location, MensajesManager mensajesManager, FileConfiguration fileConfiguration) {
        FileConfiguration fileConfiguration2 = this.plugin.getConfig();
        PlayerData playerData = this.plugin.getJugadorManager().getPlayerData(player);
        if (!this.isValidWorld(location, fileConfiguration2)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretWorldError"), true);
            return false;
        }
        if (!this.isPermissionApproved(turret.getName(), fileConfiguration2, player)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretNoPermissions"), true);
            return false;
        }
        if (!this.isValidPosition(location, turret)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretInvalidPosition"), true);
            return false;
        }
        if (!this.isValidPositionBlocksNearby(location, turret)) {
            int n = fileConfiguration2.getInt("turret_blocks_nearby_min_distance");
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretInvalidPositionBlocksNearby").replace("%distance%", String.valueOf(n)), true);
            return false;
        }
        if (this.isTooHigh(location, turret)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretTooHigh"), true);
            return false;
        }
        int n = this.isValidTurretLimit(fileConfiguration2, player, playerData);
        if (n != 12345) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretLimit").replace("%limit%", String.valueOf(n)), true);
            return false;
        }
        if (!this.isValidDistanceOtherTurrets(player, location, fileConfiguration2)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretOtherTurretDistance"), true);
            return false;
        }
        if (!this.isValidDistanceOwnTurrets(player, location, fileConfiguration2)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretOwnTurretDistance"), true);
            return false;
        }
        if (!this.isOwnerCurrentRegion(location, player, fileConfiguration2)) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("placeTurretOnOwnRegionError"), true);
            return false;
        }
        return true;
    }

    public boolean canOpenTurret(Player player, PlayerTurret playerTurret) {
        if (player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.open")) {
            return true;
        }
        return playerTurret.getOwnerUUID().equals(player.getUniqueId().toString());
    }

    private boolean isValidWorld(Location location, FileConfiguration fileConfiguration) {
        List list = fileConfiguration.getStringList("blacklisted_worlds");
        for (String string : list) {
            if (!location.getWorld().getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean isPermissionApproved(String string, FileConfiguration fileConfiguration, Player player) {
        if (fileConfiguration.getString("per_turret_permissions").equals("true")) {
            return player.isOp() || player.hasPermission("complexturrets.use." + string);
        }
        return true;
    }

    private boolean isValidPosition(Location location, Turret turret) {
        int n = turret.getStructure().size();
        int n2 = 1;
        while (n2 < n) {
            Location location2 = location.clone().add(0.0, (double)n2, 0.0);
            if (location2.getBlock() != null && !location2.getBlock().getType().name().contains("AIR")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isValidPositionBlocksNearby(Location location, Turret turret) {
        int n = this.plugin.getConfigsManager().getMainConfigManager().getTurretBlocksNearbyMinDistance();
        if (n <= 0) {
            return true;
        }
        int n2 = turret.getStructure().size();
        int n3 = 0;
        while (n3 < n2) {
            Location location2 = location.clone().add((double)(-n), (double)n3, (double)(-n));
            int n4 = 0;
            while (n4 <= n * 2) {
                int n5 = 0;
                while (n5 <= n * 2) {
                    Location location3 = location2.clone().add((double)n4, 0.0, (double)n5);
                    Block block = location3.getBlock();
                    if (block != null && block.getType().isSolid() && (location3.getBlockX() != location.getBlockX() || location3.getBlockZ() != location.getBlockZ())) {
                        return false;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public boolean isBlockNearbyTurret(Block block) {
        Location location = block.getLocation();
        int n = this.plugin.getConfigsManager().getMainConfigManager().getTurretBlocksNearbyMinDistance();
        if (n <= 0) {
            return false;
        }
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        for (PlayerData playerData : arrayList) {
            ArrayList<PlayerTurret> arrayList2 = playerData.getTurrets();
            for (PlayerTurret playerTurret : arrayList2) {
                Location location2 = playerTurret.getLocation();
                if (!location2.getWorld().getName().equals(location.getWorld().getName())) continue;
                Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
                int n2 = turret.getStructure().size();
                int n3 = 0;
                while (n3 < n2) {
                    int n4;
                    Location location3 = location2.clone().add(0.0, (double)n3, 0.0);
                    int n5 = location3.getBlockY();
                    if (location.getBlockY() == n5 && (n4 = (int)location3.distance(location)) <= n) {
                        return true;
                    }
                    ++n3;
                }
            }
        }
        return false;
    }

    private boolean isTooHigh(Location location, Turret turret) {
        int n;
        int n2 = turret.getStructure().size();
        int n3 = location.getWorld().getMaxHeight();
        int n4 = location.getBlockY();
        return n4 > (n = n3 - n2);
    }

    private int isValidTurretLimit(FileConfiguration fileConfiguration, Player player, PlayerData playerData) {
        if (fileConfiguration.getString("turret_limit_permissions.enabled").equals("true")) {
            if (player.isOp()) {
                return 12345;
            }
            Set set = player.getEffectivePermissions();
            int n = 0;
            if (playerData != null) {
                n = playerData.getTurrets().size();
            }
            for (PermissionAttachmentInfo permissionAttachmentInfo : set) {
                String string = permissionAttachmentInfo.getPermission();
                if (!permissionAttachmentInfo.getValue() || !string.startsWith("complexturrets.limit.")) continue;
                String[] stringArray = string.split("\\.");
                int n2 = Integer.valueOf(stringArray[2]);
                if (n >= n2) {
                    return n2;
                }
                return 12345;
            }
            int n3 = fileConfiguration.getInt("turret_limit_permissions.default_limit");
            if (n >= n3) {
                return n3;
            }
            return 12345;
        }
        return 12345;
    }

    private boolean isValidDistanceOwnTurrets(Player player, Location location, FileConfiguration fileConfiguration) {
        int n = fileConfiguration.getInt("min_distance_between_own_turrets");
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        for (PlayerData playerData : arrayList) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                double d;
                if (!playerTurret.getOwnerUUID().equals(player.getUniqueId().toString())) continue;
                Location location2 = playerTurret.getLocation();
                if (!location.getWorld().getName().equals(location2.getWorld().getName()) || !((d = location.distance(location2)) <= (double)n)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidDistanceOtherTurrets(Player player, Location location, FileConfiguration fileConfiguration) {
        int n = fileConfiguration.getInt("min_distance_between_other_turrets");
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        for (PlayerData playerData : arrayList) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                double d;
                if (playerTurret.getOwnerUUID().equals(player.getUniqueId().toString())) continue;
                Location location2 = playerTurret.getLocation();
                if (!location.getWorld().getName().equals(location2.getWorld().getName()) || !((d = location.distance(location2)) <= (double)n)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOwnerCurrentRegion(Location location, Player player, FileConfiguration fileConfiguration) {
        if (player.isOp() || player.hasPermission("complexturrets.admin")) {
            return true;
        }
        if (!fileConfiguration.getBoolean("place_turrets_only_on_own_region")) {
            return true;
        }
        return this.plugin.getDependencyManager().getRegionManager().isOwnerRegion(player, location);
    }
}

