/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.model;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.MainConfigManager;
import ct.ajneb97.model.PlayerTurretAmmoInventoryPage;
import ct.ajneb97.model.PlayerTurretAmmoInventorySlot;
import ct.ajneb97.model.TurretCooldown;
import ct.ajneb97.model.TurretHologram;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class PlayerTurret {
    private String turretName;
    private int turretLevel;
    private Location location;
    private boolean attackMonsters;
    private boolean attackPlayers;
    private boolean attackAnimals;
    private boolean attackOthers;
    private TurretAttackPriority priority;
    private boolean enabled;
    private int ammo;
    private List<PlayerTurretAmmoInventoryPage> ammoInventoryPages;
    private boolean infiniteAmmo;
    private int currentHealth;
    private int maxHealth;
    private long activationDelayMillis;
    private List<String> whitelistedPlayers;
    private String ownerUUID;
    private String ownerName;
    private TurretCooldown cooldown;
    private TurretHologram turretHologram;

    public PlayerTurret(String string, int n, Location location, boolean bl, boolean bl2, boolean bl3, boolean bl4, TurretAttackPriority turretAttackPriority, boolean bl5, int n2, boolean bl6, List<String> list, String string2, String string3, ComplexTurrets complexTurrets, int n3, List<PlayerTurretAmmoInventoryPage> list2, long l) {
        this.turretName = string;
        this.turretLevel = n;
        this.location = location;
        this.attackMonsters = bl;
        this.attackPlayers = bl2;
        this.attackAnimals = bl3;
        this.attackOthers = bl4;
        this.priority = turretAttackPriority;
        this.enabled = bl5;
        this.ammo = n2;
        this.infiniteAmmo = bl6;
        this.whitelistedPlayers = list;
        this.ownerUUID = string2;
        this.ownerName = string3;
        this.currentHealth = n3;
        this.maxHealth = n3;
        this.ammoInventoryPages = list2;
        this.activationDelayMillis = l;
        this.startCooldown(complexTurrets);
    }

    public String getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getTurretName() {
        return this.turretName;
    }

    public void setTurretName(String string) {
        this.turretName = string;
    }

    public int getTurretLevel() {
        return this.turretLevel;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean isAttackMonsters() {
        return this.attackMonsters;
    }

    public void setAttackMonsters(boolean bl) {
        this.attackMonsters = bl;
    }

    public boolean isAttackPlayers() {
        return this.attackPlayers;
    }

    public void setAttackPlayers(boolean bl) {
        this.attackPlayers = bl;
    }

    public boolean isAttackAnimals() {
        return this.attackAnimals;
    }

    public void setAttackAnimals(boolean bl) {
        this.attackAnimals = bl;
    }

    public boolean isAttackOthers() {
        return this.attackOthers;
    }

    public void setAttackOthers(boolean bl) {
        this.attackOthers = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isInfiniteAmmo() {
        return this.infiniteAmmo;
    }

    public void setInfiniteAmmo(boolean bl) {
        this.infiniteAmmo = bl;
    }

    public List<String> getWhitelistedPlayers() {
        return this.whitelistedPlayers;
    }

    public void setWhitelistedPlayers(List<String> list) {
        this.whitelistedPlayers = list;
    }

    public int getCurrentHealth() {
        return this.currentHealth;
    }

    public void setCurrentHealth(int n) {
        this.currentHealth = n;
    }

    public TurretAttackPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TurretAttackPriority turretAttackPriority) {
        this.priority = turretAttackPriority;
    }

    public static PlayerTurret createDefault(String string, int n, Location location, String string2, String string3, ComplexTurrets complexTurrets, int n2, Turret turret, long l) {
        boolean bl = turret.isEnabledDefault();
        PlayerTurret playerTurret = new PlayerTurret(string, n, location, turret.isAttackMonstersDefault(), turret.isAttackPlayersDefault(), turret.isAttackAnimalsDefault(), turret.isAttackOthersDefault(), turret.getAttackPriorityDefault(), bl, 0, false, new ArrayList<String>(), string2, string3, complexTurrets, n2, new ArrayList<PlayerTurretAmmoInventoryPage>(), l);
        return playerTurret;
    }

    public void startCooldown(ComplexTurrets complexTurrets) {
        Turret turret = complexTurrets.getTurretsManager().getTurret(this.turretName);
        if (turret == null) {
            return;
        }
        MainConfigManager mainConfigManager = complexTurrets.getConfigsManager().getMainConfigManager();
        this.cooldown = new TurretCooldown(complexTurrets, this);
        this.cooldown.update(turret, this.turretLevel, mainConfigManager.isEnableTurretsOnlyWhenOwnerIsOnline(), mainConfigManager.isAllyProtection(), mainConfigManager.isIgnoreDamageToInvisiblePlayers(), mainConfigManager.isWallsBetterCheck());
        this.cooldown.start();
    }

    public void upgrade(ComplexTurrets complexTurrets) {
        ++this.turretLevel;
        this.maxHealth = complexTurrets.getTurretsManager().getMaxHealthTurret(this.turretName, this.turretLevel);
        this.restartCooldown(complexTurrets);
    }

    public void restartCooldown(ComplexTurrets complexTurrets) {
        this.cooldown.finish();
        this.startCooldown(complexTurrets);
    }

    public void remove() {
        this.cooldown.finish();
    }

    public void decreaseAmmo() {
        if (this.ammoInventoryPages.isEmpty()) {
            return;
        }
        PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = this.ammoInventoryPages.get(this.ammoInventoryPages.size() - 1);
        List<PlayerTurretAmmoInventorySlot> list = playerTurretAmmoInventoryPage.getSlots();
        if (list.isEmpty()) {
            this.ammoInventoryPages.remove(this.ammoInventoryPages.size() - 1);
            return;
        }
        PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot = list.get(list.size() - 1);
        int n = playerTurretAmmoInventorySlot.getAmount();
        if (n <= 1) {
            playerTurretAmmoInventorySlot.setAmount(0);
            list.remove(list.size() - 1);
            int n2 = this.getPageAmmo(playerTurretAmmoInventoryPage);
            if (n2 == 0) {
                this.ammoInventoryPages.remove(this.ammoInventoryPages.size() - 1);
            }
        } else {
            playerTurretAmmoInventorySlot.setAmount(playerTurretAmmoInventorySlot.getAmount() - 1);
        }
    }

    public PlayerTurretAmmoInventoryPage getAmmoInventoryPage(int n) {
        for (PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage : this.ammoInventoryPages) {
            if (playerTurretAmmoInventoryPage.getPage() != n) continue;
            return playerTurretAmmoInventoryPage;
        }
        return null;
    }

    public boolean isMoreAmmoInNextPages(int n, int n2) {
        int n3 = n - 1;
        while (n3 < n2) {
            int n4;
            PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = this.getAmmoInventoryPage(n3 + 2);
            if (playerTurretAmmoInventoryPage != null && (n4 = this.getPageAmmo(playerTurretAmmoInventoryPage)) > 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int getPageAmmo(PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage) {
        int n = 0;
        List<PlayerTurretAmmoInventorySlot> list = playerTurretAmmoInventoryPage.getSlots();
        for (PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot : list) {
            n += playerTurretAmmoInventorySlot.getAmount();
        }
        return n;
    }

    public int getTotalAmmo() {
        int n = 0;
        for (PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage : this.ammoInventoryPages) {
            n += this.getPageAmmo(playerTurretAmmoInventoryPage);
        }
        return n;
    }

    public boolean isDamageable() {
        return this.currentHealth != 0;
    }

    public boolean isMaxHealth() {
        return this.currentHealth == this.maxHealth;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public TurretHologram getTurretHologram() {
        return this.turretHologram;
    }

    public void setTurretHologram(TurretHologram turretHologram) {
        this.turretHologram = turretHologram;
    }

    public List<PlayerTurretAmmoInventoryPage> getAmmoInventoryPages() {
        return this.ammoInventoryPages;
    }

    public void setAmmoInventoryPages(List<PlayerTurretAmmoInventoryPage> list) {
        this.ammoInventoryPages = list;
    }

    public long getActivationDelayMillis() {
        return this.activationDelayMillis;
    }

    public void addAmmoInventoryPage(PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage) {
        this.ammoInventoryPages.add(playerTurretAmmoInventoryPage);
        int n = 0;
        while (n < this.ammoInventoryPages.size()) {
            int n2 = n + 1;
            while (n2 < this.ammoInventoryPages.size()) {
                PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage2 = this.ammoInventoryPages.get(n);
                PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage3 = this.ammoInventoryPages.get(n2);
                if (playerTurretAmmoInventoryPage2.getPage() > playerTurretAmmoInventoryPage3.getPage()) {
                    PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage4 = playerTurretAmmoInventoryPage3;
                    this.ammoInventoryPages.set(n2, playerTurretAmmoInventoryPage2);
                    this.ammoInventoryPages.set(n, playerTurretAmmoInventoryPage4);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void removeAmmoInventoryPage(int n) {
        int n2 = 0;
        while (n2 < this.ammoInventoryPages.size()) {
            if (this.ammoInventoryPages.get(n2).getPage() == n) {
                this.ammoInventoryPages.remove(n2);
                break;
            }
            ++n2;
        }
    }

    public static List<PlayerTurretAmmoInventoryPage> generateAmmoInventoryFromAmmo(int n) {
        Object object;
        ArrayList<PlayerTurretAmmoInventoryPage> arrayList = new ArrayList<PlayerTurretAmmoInventoryPage>();
        arrayList.add(new PlayerTurretAmmoInventoryPage(1, new ArrayList<PlayerTurretAmmoInventorySlot>()));
        int n2 = 0;
        int n3 = 0;
        while (n != 0) {
            if (n >= 64) {
                ++n2;
                n -= 64;
                continue;
            }
            n3 = n;
            n = 0;
        }
        int n4 = 44;
        int n5 = 0;
        int n6 = 1;
        ArrayList<PlayerTurretAmmoInventorySlot> arrayList2 = new ArrayList<PlayerTurretAmmoInventorySlot>();
        while (n2 != 0) {
            object = new PlayerTurretAmmoInventorySlot(n5, 64);
            arrayList2.add((PlayerTurretAmmoInventorySlot)object);
            --n2;
            if (++n5 <= n4) continue;
            ((PlayerTurretAmmoInventoryPage)arrayList.get(arrayList.size() - 1)).setSlots(arrayList2);
            PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = new PlayerTurretAmmoInventoryPage(++n6, new ArrayList<PlayerTurretAmmoInventorySlot>());
            arrayList.add(playerTurretAmmoInventoryPage);
            n5 = 0;
            arrayList2 = new ArrayList();
        }
        ((PlayerTurretAmmoInventoryPage)arrayList.get(arrayList.size() - 1)).setSlots(arrayList2);
        if (n3 != 0) {
            object = (PlayerTurretAmmoInventoryPage)arrayList.get(arrayList.size() - 1);
            int n7 = ((PlayerTurretAmmoInventoryPage)object).getSlots().size();
            if (n7 > n4) {
                PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot = new PlayerTurretAmmoInventorySlot(0, n3);
                PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = new PlayerTurretAmmoInventoryPage(arrayList.size() + 1, new ArrayList<PlayerTurretAmmoInventorySlot>());
                playerTurretAmmoInventoryPage.getSlots().add(playerTurretAmmoInventorySlot);
                arrayList.add(playerTurretAmmoInventoryPage);
            } else {
                PlayerTurretAmmoInventorySlot playerTurretAmmoInventorySlot = new PlayerTurretAmmoInventorySlot(n7, n3);
                ((PlayerTurretAmmoInventoryPage)object).getSlots().add(playerTurretAmmoInventorySlot);
            }
        }
        return arrayList;
    }
}

