/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.model;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.DependencyManager;
import ct.ajneb97.managers.ShootManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.TurretEntityType;
import ct.ajneb97.model.estructura.ShootType;
import ct.ajneb97.model.estructura.TargetType;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.tasks.ParabolicShootTask;
import ct.ajneb97.utils.UtilsEffects;
import ct.ajneb97.utils.UtilsEntities;
import ct.ajneb97.utils.UtilsOthers;
import ct.ajneb97.utils.UtilsPlayers;
import ct.ajneb97.utils.UtilsTurrets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class TurretCooldown {
    private ComplexTurrets plugin;
    private PlayerTurret playerTurret;
    private DependencyManager dependencyManager;
    private Turret turret;
    private int currentLevel;
    private boolean enableTurretsOnlyWhenOwnerIsOnline;
    private boolean allyProtection;
    private boolean ignoreDamageToInvisiblePlayers;
    private boolean wallsBetterCheck;
    private boolean end;

    public TurretCooldown(ComplexTurrets complexTurrets, PlayerTurret playerTurret) {
        this.plugin = complexTurrets;
        this.playerTurret = playerTurret;
        this.dependencyManager = complexTurrets.getDependencyManager();
        this.end = false;
    }

    public void update(Turret turret, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.turret = turret;
        this.currentLevel = n;
        this.enableTurretsOnlyWhenOwnerIsOnline = bl;
        this.allyProtection = bl2;
        this.ignoreDamageToInvisiblePlayers = bl3;
        this.wallsBetterCheck = bl4;
    }

    public void start() {
        TurretUpgrade turretUpgrade = this.turret.getUpgrade(this.currentLevel);
        long l = (long)(turretUpgrade.getSpeed() * 20.0);
        new BukkitRunnable(){

            public void run() {
                if (TurretCooldown.this.end) {
                    this.cancel();
                    return;
                }
                TurretCooldown.this.execute();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, l);
    }

    public void finish() {
        this.end = true;
    }

    public void execute() {
        if (!this.playerTurret.isEnabled()) {
            return;
        }
        if (!UtilsOthers.isChunkLoaded(this.playerTurret.getLocation())) {
            return;
        }
        if (this.enableTurretsOnlyWhenOwnerIsOnline && Bukkit.getPlayer((String)this.playerTurret.getOwnerName()) == null) {
            return;
        }
        int n = this.playerTurret.getTotalAmmo();
        if (this.turret.isRequireAmmunition() && n <= 0 && !this.playerTurret.isInfiniteAmmo()) {
            return;
        }
        if (System.currentTimeMillis() < this.playerTurret.getActivationDelayMillis()) {
            return;
        }
        final TurretUpgrade turretUpgrade = this.turret.getUpgrade(this.currentLevel);
        int n2 = this.turret.getStructure().size();
        final Location location = this.playerTurret.getLocation().clone().add(0.5, (double)n2 - 0.5, 0.5);
        double d = turretUpgrade.getRange();
        final TurretAttackPriority turretAttackPriority = this.playerTurret.getPriority();
        final Collection collection = location.getWorld().getNearbyEntities(location, d, d, d);
        new BukkitRunnable(){

            public void run() {
                long l = System.currentTimeMillis();
                int n = turretUpgrade.getMaxTargets();
                ArrayList<Entity> arrayList = TurretCooldown.this.getClosestEnemies(collection, location, n, turretAttackPriority);
                ShootManager shootManager = TurretCooldown.this.plugin.getShootManager();
                if (!arrayList.isEmpty() && TurretCooldown.this.turret.isRequireAmmunition() && !TurretCooldown.this.playerTurret.isInfiniteAmmo()) {
                    TurretCooldown.this.playerTurret.decreaseAmmo();
                    TurretCooldown.this.plugin.getInventoryManager().updateAmmoInventory(TurretCooldown.this.playerTurret);
                }
                for (Entity entity : arrayList) {
                    TurretCooldown.this.shoot(entity, location, shootManager, turretUpgrade);
                }
                long l2 = System.currentTimeMillis();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void shoot(Entity entity, Location location, ShootManager shootManager, TurretUpgrade turretUpgrade) {
        int n;
        int n2;
        Location location2 = entity.getLocation();
        UtilsEffects.playSound(location, this.turret.getShootEffect().getSound(), this.plugin);
        Random random = new Random();
        boolean bl = false;
        int n3 = turretUpgrade.getAccuracy();
        if (n3 != 0 && (n2 = n3 * 100) < (n = random.nextInt(10001))) {
            double d = UtilsTurrets.getAccuracyFail(n, n2);
            double d2 = UtilsTurrets.getAccuracyFail(n, n2);
            location2 = location2.clone().add(d, 0.0, d2);
            bl = true;
        }
        n = this.plugin.getConfigsManager().getMainConfigManager().isForceParticles() ? 1 : 0;
        if (this.turret.getShootType().equals((Object)ShootType.INSTANT)) {
            UtilsEffects.turretShootEffectInstant(this.turret, location, location2, n != 0);
            UtilsEffects.turretEffectAtLocation(location2, this.turret.getImpactEffect(), null, n != 0);
            if (!bl) {
                shootManager.hitEntity(entity, location2, this.turret, this.playerTurret, turretUpgrade);
            }
        } else {
            ParabolicShootTask parabolicShootTask = new ParabolicShootTask(this.plugin, this.turret, this.playerTurret, turretUpgrade);
            parabolicShootTask.startParabolic(location, location2);
        }
    }

    public ArrayList<Entity> getClosestEnemies(Collection<Entity> collection, Location location, int n, TurretAttackPriority turretAttackPriority) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        boolean bl = this.playerTurret.isAttackAnimals();
        boolean bl2 = this.playerTurret.isAttackPlayers();
        boolean bl3 = this.playerTurret.isAttackMonsters();
        boolean bl4 = this.playerTurret.isAttackOthers();
        TargetType targetType = this.turret.getTargetType();
        String string = this.playerTurret.getOwnerName();
        String string2 = this.playerTurret.getOwnerUUID();
        int n2 = 0;
        while (n2 < n) {
            Entity entity = null;
            double d = 100.0;
            double d2 = 10000.0;
            for (Entity entity2 : collection) {
                double d3;
                Location location2;
                LivingEntity livingEntity;
                if (entity2 == null || entity2.isDead() || arrayList.contains(entity2)) continue;
                boolean bl5 = false;
                TurretEntityType turretEntityType = UtilsEntities.getEntityType(entity2);
                if (turretEntityType.equals((Object)TurretEntityType.INVALID)) continue;
                if (turretEntityType.equals((Object)TurretEntityType.ANIMAL) && bl) {
                    boolean bl6 = UtilsEntities.isTamed(string, entity2);
                    if (targetType.equals((Object)TargetType.ENEMIES) && !bl6) {
                        bl5 = true;
                    } else if (targetType.equals((Object)TargetType.ALLIES) && bl6) {
                        bl5 = true;
                    }
                } else if (turretEntityType.equals((Object)TurretEntityType.MONSTER) && bl3) {
                    if (targetType.equals((Object)TargetType.ENEMIES)) {
                        bl5 = true;
                    }
                } else if (turretEntityType.equals((Object)TurretEntityType.OTHER) && bl4) {
                    if (targetType.equals((Object)TargetType.ENEMIES)) {
                        bl5 = true;
                    }
                } else if (turretEntityType.equals((Object)TurretEntityType.PLAYER) && bl2) {
                    if (this.dependencyManager.isNPC(entity2)) continue;
                    livingEntity = (Player)entity2;
                    if (livingEntity.getUniqueId().toString().equals(string2) && targetType.equals((Object)TargetType.ALLIES)) {
                        bl5 = true;
                    } else if (livingEntity.getUniqueId().toString().equals(string2) && targetType.equals((Object)TargetType.ENEMIES)) continue;
                    if (!UtilsPlayers.isSurvival((Player)livingEntity) || this.ignoreDamageToInvisiblePlayers && (UtilsPlayers.isInVanish((Player)livingEntity) || UtilsPlayers.isInvisible((Player)livingEntity))) continue;
                    boolean bl7 = this.isAlly(this.playerTurret, string, string2, (Player)livingEntity);
                    if (targetType.equals((Object)TargetType.ENEMIES) && !bl7) {
                        bl5 = true;
                    } else if (targetType.equals((Object)TargetType.ALLIES) && bl7) {
                        bl5 = true;
                    }
                }
                livingEntity = (LivingEntity)entity2;
                if (targetType.equals((Object)TargetType.ALLIES) && livingEntity.getHealth() >= livingEntity.getMaxHealth() || !bl5 || !(location2 = entity2.getLocation()).getWorld().equals(location.getWorld()) || (d3 = location2.distance(location)) <= this.turret.getMinAttackDistance()) continue;
                if (turretAttackPriority.equals((Object)TurretAttackPriority.CLOSEST)) {
                    if (!(d3 < d) || this.shootIsBlocked(location, location2)) continue;
                    entity = entity2;
                    d = d3;
                    continue;
                }
                double d4 = livingEntity.getHealth();
                if (!(d4 < d2) || this.shootIsBlocked(location, location2)) continue;
                entity = entity2;
                d2 = d4;
            }
            if (entity != null) {
                arrayList.add(entity);
            }
            ++n2;
        }
        return arrayList;
    }

    public boolean shootIsBlocked(Location location, Location location2) {
        double d = location2.distance(location);
        Vector vector = location2.toVector();
        vector.setY(vector.getY() + 1.25);
        Vector vector2 = location.toVector();
        Vector vector3 = vector.clone().subtract(vector2).normalize();
        boolean bl = this.turret.isShootThroughLiquids();
        if (this.wallsBetterCheck) {
            Location location3 = location.clone().add(vector3);
            FluidCollisionMode fluidCollisionMode = bl ? FluidCollisionMode.NEVER : FluidCollisionMode.ALWAYS;
            RayTraceResult rayTraceResult = location.getWorld().rayTraceBlocks(location3, vector3, d -= 1.15, fluidCollisionMode, true);
            return rayTraceResult != null && rayTraceResult.getHitBlock() != null;
        }
        double d2 = 0.0;
        Location location4 = location.clone();
        int n = 0;
        while ((double)n < d) {
            String string;
            Location location5 = location4.add(vector3);
            Block block = location5.getBlock();
            if (!(!(d2 >= 1.0) || block == null || (string = block.getType().name()).equals("AIR") || string.contains("_AIR") || string.equals("LONG_GRASS") || string.equals("TALL_GRASS"))) {
                if (bl) {
                    if (!block.getType().name().contains("WATER") && !block.getType().name().contains("LAVA")) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            d2 += 1.0;
            ++n;
        }
        return false;
    }

    public boolean isAlly(PlayerTurret playerTurret, String string, String string2, Player player) {
        List<String> list = playerTurret.getWhitelistedPlayers();
        for (String string3 : list) {
            if (!string3.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        if (!this.allyProtection) {
            return false;
        }
        return this.dependencyManager.getAllyManager().isAlly(string, string2, player);
    }
}

