/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.tasks;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.JugadorManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerTurret;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HealthRecoveryTask {
    private ComplexTurrets plugin;
    private boolean end;

    public HealthRecoveryTask(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.end = false;
    }

    public void start() {
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        int n = fileConfiguration.getInt("health_recovery_time");
        new BukkitRunnable(){

            public void run() {
                if (HealthRecoveryTask.this.end) {
                    this.cancel();
                } else {
                    HealthRecoveryTask.this.execute();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L * (long)n);
    }

    public void end() {
        this.end = true;
    }

    public void execute() {
        if (this.plugin.isPluginDisabled()) {
            return;
        }
        JugadorManager jugadorManager = this.plugin.getJugadorManager();
        ArrayList<PlayerData> arrayList = jugadorManager.getPlayers();
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        for (PlayerData playerData : arrayList) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                if (playerTurret.isMaxHealth()) continue;
                int n = turretsManager.getTurret(playerTurret.getTurretName()).getHealthRecovery();
                int n2 = playerTurret.getMaxHealth();
                int n3 = playerTurret.getCurrentHealth() + n;
                if (n3 > n2) {
                    playerTurret.setCurrentHealth(n2);
                } else {
                    playerTurret.setCurrentHealth(n3);
                }
                jugadorManager.updateInformationHologram(playerTurret);
            }
        }
    }
}

