/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.utils;

import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class UtilsPlayers {
    public static boolean isSurvival(Player player) {
        return !player.getGameMode().equals((Object)GameMode.CREATIVE) && !player.getGameMode().equals((Object)GameMode.SPECTATOR);
    }

    public static boolean isInvisible(Player player) {
        Collection collection = player.getActivePotionEffects();
        for (PotionEffect potionEffect : collection) {
            if (!potionEffect.getType().equals((Object)PotionEffectType.INVISIBILITY)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInVanish(Player player) {
        for (MetadataValue metadataValue : player.getMetadata("vanished")) {
            if (!metadataValue.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockingWithShield(Player player) {
        if (Bukkit.getVersion().contains("1.8")) {
            return true;
        }
        boolean bl = player.isBlocking();
        if (!bl) {
            return false;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        if (itemStack != null && itemStack.getType().equals((Object)Material.SHIELD)) {
            return true;
        }
        return itemStack2 != null && itemStack2.getType().equals((Object)Material.SHIELD);
    }

    public static void reduceDurabilityItem(Player player, EntityEquipment entityEquipment, Sound sound, ItemStack itemStack, String string) {
        block26: {
            short s;
            block24: {
                Material material = itemStack.getType();
                String string2 = material.toString();
                if (!string2.contains("_HELMET")) {
                    return;
                }
                short s2 = material.getMaxDurability();
                short s3 = itemStack.getDurability();
                s = (short)(s3 + 1);
                int n = UtilsPlayers.getDurabilityEnchantmentLevel(itemStack);
                int n2 = 60 + 40 / (n + 1);
                Random random = new Random();
                int n3 = random.nextInt(101);
                if (n3 > n2) {
                    return;
                }
                if (s < s2) break block24;
                player.playSound(player.getLocation(), sound, 10.0f, 1.0f);
                switch (string) {
                    case "HELMET": {
                        entityEquipment.setHelmet(null);
                        break;
                    }
                    case "CHESTPLATE": {
                        entityEquipment.setChestplate(null);
                        break;
                    }
                    case "LEGGINGS": {
                        entityEquipment.setLeggings(null);
                        break;
                    }
                    case "BOOTS": {
                        entityEquipment.setBoots(null);
                        break;
                    }
                    case "HAND": {
                        entityEquipment.setItemInMainHand(null);
                        break;
                    }
                    case "OFF_HAND": {
                        entityEquipment.setItemInOffHand(null);
                    }
                }
                player.updateInventory();
                break block26;
            }
            itemStack.setDurability(s);
        }
    }

    public static int getDurabilityEnchantmentLevel(ItemStack itemStack) {
        int n = 0;
        if (!itemStack.hasItemMeta()) {
            return n;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasEnchant(Enchantment.DURABILITY)) {
            return itemMeta.getEnchantLevel(Enchantment.DURABILITY);
        }
        return n;
    }
}

