/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.command.subcmd;

import java.util.List;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.api.CustomNameplatesAPI;
import net.momirealms.customnameplates.command.AbstractSubCommand;
import net.momirealms.customnameplates.manager.MessageManager;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NameplatesEquipCommand
extends AbstractSubCommand {
    public static final AbstractSubCommand INSTANCE = new NameplatesEquipCommand();

    public NameplatesEquipCommand() {
        super("equip");
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.noConsoleExecute(sender) || this.lackArgs(sender, 1, args.size()) || this.notExist(sender, "nameplate", args.get(0))) {
            return true;
        }
        if (!sender.hasPermission("nameplates.equip." + args.get(0))) {
            AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.np_notAvailable);
            return true;
        }
        Player player = (Player)sender;
        CustomNameplatesAPI.getInstance().equipNameplate(player, args.get(0));
        AdventureUtils.sendMessage(sender, MessageManager.prefix + MessageManager.np_equip.replace("{Nameplate}", CustomNameplates.getInstance().getNameplateManager().getNameplateConfig(args.get(0)).display_name()));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, List<String> args) {
        if (args.size() == 1 && sender instanceof Player) {
            Player player = (Player)sender;
            return this.filterStartingWith(CustomNameplates.getInstance().getNameplateManager().getAvailableNameplates(player), args.get(0));
        }
        return null;
    }
}

