/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.command.subcmd;

import java.util.List;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.command.AbstractSubCommand;
import net.momirealms.customnameplates.libs.net.kyori.adventure.key.Key;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.Component;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.TextComponent;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.format.TextColor;
import net.momirealms.customnameplates.manager.MessageManager;
import net.momirealms.customnameplates.manager.NameplateManager;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.nameplate.NameplatesTeam;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ArmorStandUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PreviewCommand
extends AbstractSubCommand {
    public static final AbstractSubCommand INSTANCE = new PreviewCommand();

    public PreviewCommand() {
        super("preview");
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        if (this.noConsoleExecute(sender)) {
            return true;
        }
        Player player = (Player)sender;
        NameplateManager nameplateManager = CustomNameplates.getInstance().getNameplateManager();
        if (nameplateManager.isInCoolDown(player)) {
            AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.coolDown);
            return true;
        }
        if (nameplateManager.getMode() == DisplayMode.TEAM) {
            NameplatesTeam team = CustomNameplates.getInstance().getTeamManager().getNameplateTeam(player.getUniqueId());
            if (team != null) {
                Component full = team.getNameplatePrefixComponent().append(((TextComponent)Component.text(player.getName()).color(TextColor.color(AdventureUtils.colorToDecimal(team.getColor())))).font(Key.key("minecraft:default")).append(team.getNameplateSuffixComponent()));
                ArmorStandUtils.preview(full, player, (int)nameplateManager.getPreview_time());
            }
        } else if (nameplateManager.getMode() == DisplayMode.ARMOR_STAND || nameplateManager.getMode() == DisplayMode.TEXT_DISPLAY) {
            nameplateManager.showPlayerArmorStandTags(player);
        } else {
            AdventureUtils.playerMessage(player, MessageManager.prefix + "<white>Nameplate is disabled.");
            return true;
        }
        AdventureUtils.playerMessage(player, MessageManager.prefix + MessageManager.preview);
        return true;
    }
}

