/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.api.events.BubblesEvent;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import net.momirealms.customnameplates.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.customnameplates.listener.AbstractChatListener;
import net.momirealms.customnameplates.listener.AsyncChatListener;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.listener.TrChatListener;
import net.momirealms.customnameplates.listener.VentureChatListener;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.ConditionalText;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.SimpleChar;
import net.momirealms.customnameplates.object.bubble.BubbleConfig;
import net.momirealms.customnameplates.object.carrier.NamedEntityCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityImpl;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import net.momirealms.customnameplates.object.carrier.TextDisplayMeta;
import net.momirealms.customnameplates.object.font.OffsetFont;
import net.momirealms.customnameplates.object.img.ImageParser;
import net.momirealms.customnameplates.object.img.ItemsAdderImageImpl;
import net.momirealms.customnameplates.object.img.OraxenImageImpl;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class ChatBubblesManager
extends Function {
    private AbstractChatListener chatListener;
    private ImageParser imageParser;
    private final ConcurrentHashMap<Player, Long> coolDownMap;
    private final HashMap<String, BubbleConfig> bubbleConfigMap;
    private final CustomNameplates plugin;
    private NamedEntityCarrier namedEntityCarrier;
    private final JoinQuitListener joinQuitListener;
    private String defaultBubble;
    private String defaultStartFormat;
    private String defaultEndFormat;
    private String prefix;
    private String suffix;
    private double lineSpace;
    private double yOffset;
    private int stayTime;
    private int coolDown;
    private int maxCharLength;
    private int lengthPerLine;
    private String[] channels;
    private TextDisplayMeta textDisplayMeta;

    public ChatBubblesManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.bubbleConfigMap = new HashMap();
        this.coolDownMap = new ConcurrentHashMap();
        this.joinQuitListener = new JoinQuitListener(this);
    }

    @Override
    public void load() {
        if (!ConfigManager.enableBubbles) {
            return;
        }
        super.load();
        this.loadConfig();
        this.loadBubbles();
        this.registerListener();
        this.registerImageParser();
        this.namedEntityCarrier.load();
    }

    @Override
    public void unload() {
        super.unload();
        this.imageParser = null;
        this.bubbleConfigMap.clear();
        this.coolDownMap.clear();
        if (this.chatListener != null) {
            HandlerList.unregisterAll((Listener)this.chatListener);
        }
        if (this.joinQuitListener != null) {
            HandlerList.unregisterAll((Listener)this.joinQuitListener);
        }
        if (this.namedEntityCarrier != null) {
            this.namedEntityCarrier.unload();
        }
    }

    private void loadConfig() {
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "bubble.yml");
        DisplayMode displayMode = DisplayMode.valueOf(config.getString("mode", "ARMOR_STAND").toUpperCase(Locale.ENGLISH));
        this.defaultBubble = config.getString("default-bubbles", "chat");
        this.prefix = config.getString("text-prefix", "");
        this.suffix = config.getString("text-suffix", "");
        this.lineSpace = config.getDouble("line-spacing");
        this.defaultStartFormat = config.getString("default-format.start", "<gradient:#F5F5F5:#E1FFFF:#F5F5F5><u>");
        this.defaultEndFormat = config.getString("default-format.end", "<!u></gradient>");
        this.yOffset = config.getDouble("bottom-line-Y-offset") + (displayMode == DisplayMode.TEXT_DISPLAY ? 1.2 : 0.0);
        this.stayTime = config.getInt("stay-time", 5);
        this.coolDown = (int)(config.getDouble("cool-down", 1.0) * 1000.0);
        this.maxCharLength = config.getInt("max-character-length", 100);
        this.channels = config.getStringList("blacklist-channels").toArray(new String[0]);
        this.lengthPerLine = config.getInt("characters-per-line", 30);
        this.textDisplayMeta = ConfigUtils.getTextDisplayMeta(config.getConfigurationSection("text-display-options"));
        this.namedEntityCarrier = new NamedEntityCarrier(this.plugin, displayMode, new HashMap<ConditionalText, Double>());
    }

    private void registerImageParser() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (pluginManager.isPluginEnabled("Oraxen")) {
            this.imageParser = new OraxenImageImpl();
        } else if (pluginManager.isPluginEnabled("ItemsAdder")) {
            this.imageParser = new ItemsAdderImageImpl();
        }
    }

    private void registerListener() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.chatListener = ConfigManager.trChat_Hook ? new TrChatListener(this) : (ConfigManager.ventureChat_Hook ? new VentureChatListener(this) : new AsyncChatListener(this));
        pluginManager.registerEvents((Listener)this.chatListener, (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
    }

    private void loadBubbles() {
        File[] bb_config_files;
        File bb_file = new File(this.plugin.getDataFolder(), "contents" + File.separator + "bubbles");
        if (!bb_file.exists() && bb_file.mkdirs()) {
            this.saveDefaultBubbles();
        }
        if ((bb_config_files = bb_file.listFiles(file -> file.getName().endsWith(".yml"))) == null) {
            return;
        }
        Arrays.sort(bb_config_files, Comparator.comparing(File::getName));
        for (File bb_config_file : bb_config_files) {
            char left = ConfigManager.start_char;
            char middle = (char)(ConfigManager.start_char + '\u0001');
            char right = (char)(middle + '\u0001');
            char tail = (char)(right + '\u0001');
            ConfigManager.start_char = (char)(tail + '\u0001');
            String key = bb_config_file.getName().substring(0, bb_config_file.getName().length() - 4);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)bb_config_file);
            if (!config.contains("display-name")) {
                config.set("display-name", (Object)key);
            }
            if (!config.contains("text-format.start")) {
                config.set("text-format.start", (Object)"<white>");
            }
            if (!config.contains("text-format.end")) {
                config.set("text-format.end", (Object)"");
            }
            if (!config.contains("left.image")) {
                config.set("left.image", (Object)(key + "_left"));
            }
            if (!config.contains("left.height")) {
                config.set("left.height", (Object)16);
            }
            if (!config.contains("left.width")) {
                config.set("left.width", (Object)16);
            }
            if (!config.contains("left.ascent")) {
                config.set("left.ascent", (Object)12);
            }
            if (!config.contains("middle.image")) {
                config.set("middle.image", (Object)(key + "_middle"));
            }
            if (!config.contains("middle.height")) {
                config.set("middle.height", (Object)16);
            }
            if (!config.contains("middle.width")) {
                config.set("middle.width", (Object)16);
            }
            if (!config.contains("middle.ascent")) {
                config.set("middle.ascent", (Object)12);
            }
            if (!config.contains("right.image")) {
                config.set("right.image", (Object)(key + "_right"));
            }
            if (!config.contains("right.height")) {
                config.set("right.height", (Object)16);
            }
            if (!config.contains("right.width")) {
                config.set("right.width", (Object)16);
            }
            if (!config.contains("right.ascent")) {
                config.set("right.ascent", (Object)12);
            }
            if (!config.contains("tail.image")) {
                config.set("tail.image", (Object)(key + "_tail"));
            }
            if (!config.contains("tail.height")) {
                config.set("tail.height", (Object)16);
            }
            if (!config.contains("tail.width")) {
                config.set("tail.width", (Object)16);
            }
            if (!config.contains("tail.ascent")) {
                config.set("tail.ascent", (Object)12);
            }
            try {
                config.save(bb_config_file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SimpleChar leftChar = new SimpleChar(config.getInt("left.height"), config.getInt("left.ascent"), config.getInt("left.width"), left, config.getString("left.image") + ".png");
            SimpleChar middleChar = new SimpleChar(config.getInt("middle.height"), config.getInt("middle.ascent"), config.getInt("middle.width"), middle, config.getString("middle.image") + ".png");
            SimpleChar rightChar = new SimpleChar(config.getInt("right.height"), config.getInt("right.ascent"), config.getInt("right.width"), right, config.getString("right.image") + ".png");
            SimpleChar tailChar = new SimpleChar(config.getInt("tail.height"), config.getInt("tail.ascent"), config.getInt("tail.width"), tail, config.getString("tail.image") + ".png");
            this.bubbleConfigMap.put(key, new BubbleConfig(config.getString("text-format.start"), config.getString("text-format.end"), config.getString("display-name"), leftChar, middleChar, rightChar, tailChar));
        }
    }

    @Override
    public void onQuit(Player player) {
        this.coolDownMap.remove(player);
    }

    private boolean isCoolDown(Player player, int lines) {
        long time = System.currentTimeMillis();
        if (time - this.coolDownMap.getOrDefault(player, time - (long)this.coolDown * (long)lines) < (long)this.coolDown * (long)lines) {
            return true;
        }
        this.coolDownMap.put(player, time);
        return false;
    }

    public String getBubblePrefix(String text, BubbleConfig bubble) {
        int totalWidth = this.plugin.getFontManager().getTotalWidth(text);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(totalWidth % 2 == 0 ? totalWidth + bubble.left().getWidth() : totalWidth + bubble.left().getWidth() + 1)).append(bubble.left().getChars()).append(OffsetFont.NEG_1.getCharacter());
        int mid_amount = totalWidth - 1 <= bubble.tail().getWidth() ? -1 : (totalWidth - 1 - bubble.tail().getWidth()) / bubble.middle().getWidth();
        if (mid_amount == -1) {
            stringBuilder.append(bubble.tail().getChars()).append(OffsetFont.NEG_1.getCharacter());
        } else if (mid_amount == 0) {
            stringBuilder.append(bubble.tail().getChars()).append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(bubble.middle().getWidth() - (totalWidth - 1 - bubble.tail().getWidth()) % bubble.middle().getWidth()));
            stringBuilder.append(bubble.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
        } else {
            stringBuilder.append(bubble.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
            for (int i = 0; i < mid_amount; ++i) {
                if (i == mid_amount / 2) {
                    stringBuilder.append(bubble.tail().getChars()).append(OffsetFont.NEG_1.getCharacter());
                    continue;
                }
                stringBuilder.append(bubble.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
            }
            stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(bubble.middle().getWidth() - (totalWidth - 1 - bubble.tail().getWidth()) % bubble.middle().getWidth()));
            stringBuilder.append(bubble.middle().getChars()).append(OffsetFont.NEG_1.getCharacter());
        }
        stringBuilder.append(bubble.right().getChars());
        stringBuilder.append(this.plugin.getFontManager().getShortestNegChars(totalWidth + bubble.right().getWidth()));
        return stringBuilder.toString();
    }

    public void onChat(Player player, String text) {
        if (player.getGameMode() == GameMode.SPECTATOR || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || !player.hasPermission("bubbles.use")) {
            return;
        }
        String bubble = this.plugin.getDataManager().getEquippedBubble(player);
        BubblesEvent bubblesEvent = new BubblesEvent(player, bubble, text);
        Bukkit.getPluginManager().callEvent((Event)bubblesEvent);
        if (bubblesEvent.isCancelled()) {
            return;
        }
        bubble = bubblesEvent.getBubble();
        BubbleConfig bubbleConfig = this.getBubble(bubble);
        String miniText = AdventureUtils.replaceLegacy(bubblesEvent.getText());
        String stripped_text = MiniMessage.miniMessage().stripTags(miniText);
        if (stripped_text.length() > this.maxCharLength) {
            return;
        }
        String[] split = this.splitString(stripped_text, this.lengthPerLine);
        if (this.isCoolDown(player, split.length)) {
            return;
        }
        for (int i = 0; i < split.length; ++i) {
            int finalI = i;
            String finalBubble = bubble;
            this.plugin.getScheduler().runTaskAsyncLater(() -> this.sendBubble(player, split[finalI], bubbleConfig, finalBubble), (long)i * (long)(this.coolDown / 50) + 1L);
        }
    }

    private void sendBubble(Player player, String text, BubbleConfig bubbleConfig, String key) {
        String json;
        if (bubbleConfig == null || key.equals("none")) {
            text = this.defaultStartFormat + PlaceholderAPI.setPlaceholders((Player)player, (String)this.prefix) + (String)text + PlaceholderAPI.setPlaceholders((Player)player, (String)this.suffix) + this.defaultEndFormat;
            json = (String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(this.imageParser != null ? this.imageParser.parse(player, (String)text) : text));
        } else {
            String parsedPrefix = PlaceholderAPI.setPlaceholders((Player)player, (String)this.prefix);
            String parsedSuffix = PlaceholderAPI.setPlaceholders((Player)player, (String)this.suffix);
            String strippedPrefix = AdventureUtils.stripAllTags(parsedPrefix);
            String strippedSuffix = AdventureUtils.stripAllTags(parsedSuffix);
            String all = strippedPrefix + (String)text + strippedSuffix;
            String bubbleImage = this.getBubblePrefix(all, bubbleConfig);
            String suffixImage = this.plugin.getFontManager().getSuffixStringWithFont(all);
            String finalStr = ConfigManager.surroundWithFont(bubbleImage) + bubbleConfig.startFormat() + parsedPrefix + (String)text + parsedSuffix + bubbleConfig.endFormat() + ConfigManager.surroundWithFont(suffixImage);
            json = (String)GsonComponentSerializer.gson().serialize(MiniMessage.miniMessage().deserialize(finalStr));
        }
        NamedEntityManager nem = this.namedEntityCarrier.getNamedEntityManager(player);
        if (nem != null) {
            NamedEntityCarrier carrier;
            NamedEntityManager nameplatesNem;
            double offset = this.yOffset;
            DisplayMode nameplateMode = this.plugin.getNameplateManager().getMode();
            if ((nameplateMode == DisplayMode.ARMOR_STAND || nameplateMode == DisplayMode.TEXT_DISPLAY) && (nameplatesNem = (carrier = (NamedEntityCarrier)this.plugin.getNameplateManager().getTextCarrier()).getNamedEntityManager(player)) != null) {
                offset += nameplatesNem.getHighestTextHeight();
            }
            UUID uuid = UUID.randomUUID();
            nem.ascent(this.lineSpace);
            nem.addNamedEntity(uuid, new NamedEntityImpl(nem, player, json, offset, this.textDisplayMeta));
            this.plugin.getScheduler().runTaskAsyncLater(() -> nem.removeArmorStand(uuid), (long)this.stayTime * 20L);
        }
    }

    private String[] splitString(String str, int len) {
        int size = (int)Math.ceil((double)str.length() / (double)len);
        String[] result = new String[size];
        int index = 0;
        for (int i = 0; i < str.length(); i += len) {
            result[index++] = i + len > str.length() ? str.substring(i) : str.substring(i, i + len);
        }
        return result;
    }

    @Nullable
    public BubbleConfig getBubble(String bubble) {
        return this.bubbleConfigMap.get(bubble);
    }

    public ArrayList<String> getAvailableBubbles(Player player) {
        ArrayList<String> availableBubbles = new ArrayList<String>();
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            String permission = info.getPermission().toLowerCase();
            if (!permission.startsWith("bubbles.equip.") || this.bubbleConfigMap.get(permission = permission.substring(14)) == null) continue;
            availableBubbles.add(permission);
        }
        return availableBubbles;
    }

    private void saveDefaultBubbles() {
        String[] png_list = new String[]{"chat"};
        String[] part_list = new String[]{"_left.png", "_middle.png", "_right.png", "_tail.png", ".yml"};
        for (String name : png_list) {
            for (String part : part_list) {
                this.plugin.saveResource("contents" + File.separator + "bubbles" + File.separatorChar + name + part, false);
            }
        }
    }

    public String getDefaultBubble() {
        return this.defaultBubble;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public HashMap<String, BubbleConfig> getBubbleConfigMap() {
        return this.bubbleConfigMap;
    }

    public boolean existBubble(String bubble) {
        return this.bubbleConfigMap.containsKey(bubble);
    }

    public BubbleConfig getBubbleConfig(String bubble) {
        return this.bubbleConfigMap.get(bubble);
    }
}

