/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.data;

import java.util.UUID;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.mechanic.bubble.Bubble;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlineUser {
    private final Player player;
    private String nameplate;
    private String bubble;

    public OnlineUser(Player player, PlayerData playerData) {
        this.player = player;
        this.nameplate = playerData.getNameplate();
        this.bubble = playerData.getBubble();
    }

    public PlayerData toPlayerData() {
        return PlayerData.builder().setBubble(this.bubble).setNameplate(this.nameplate).build();
    }

    public UUID getUUID() {
        return this.player.getUniqueId();
    }

    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public String getNameplateKey() {
        return this.nameplate;
    }

    @NotNull
    public String getBubbleKey() {
        return this.bubble;
    }

    @Nullable
    public Nameplate getNameplate() {
        String temp = this.nameplate;
        if (temp.equals("none")) {
            temp = CustomNameplatesPlugin.get().getNameplateManager().getDefaultNameplate();
        }
        return CustomNameplatesPlugin.get().getNameplateManager().getNameplate(temp);
    }

    @Nullable
    public Bubble getBubble() {
        String temp = this.nameplate;
        if (temp.equals("none")) {
            temp = CustomNameplatesPlugin.get().getBubbleManager().getDefaultBubble();
        }
        return CustomNameplatesPlugin.get().getBubbleManager().getBubble(temp);
    }

    public void setNameplate(String nameplate) {
        this.nameplate = nameplate;
    }

    public void setBubble(String bubble) {
        this.bubble = bubble;
    }
}

