/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.misc;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ViewerText {
    private final Player owner;
    private String processedText;
    private final ClaimedText[] placeholders;
    private final ConcurrentHashMap<UUID, String> valueMap;

    public ViewerText(Player owner, String rawText) {
        this.processedText = rawText;
        this.valueMap = new ConcurrentHashMap();
        this.owner = owner;
        List<String> placeholders = CustomNameplatesPlugin.get().getPlaceholderManager().detectPlaceholders(rawText);
        this.placeholders = new ClaimedText[placeholders.size()];
        int i = 0;
        for (String placeholder : placeholders) {
            this.processedText = this.processedText.replace(placeholder, "%s");
            this.placeholders[i] = placeholder.startsWith("%viewer_") ? new ClaimedText(null, "%" + placeholder.substring("%viewer_".length()), false) : (placeholder.startsWith("%rel_") ? new ClaimedText(owner, placeholder, true) : new ClaimedText(owner, placeholder, false));
            ++i;
        }
    }

    public void updateForOwner() {
        for (ClaimedText text : this.placeholders) {
            text.update();
        }
    }

    public boolean updateForViewer(Player viewer) {
        String string;
        if ("%s".equals(this.processedText)) {
            string = this.placeholders[0].getValue(viewer);
        } else if (this.placeholders.length != 0) {
            Object[] values = new String[this.placeholders.length];
            for (int i = 0; i < this.placeholders.length; ++i) {
                values[i] = this.placeholders[i].getValue(viewer);
            }
            string = String.format(this.processedText, values);
        } else {
            string = this.processedText;
        }
        UUID uuid = viewer.getUniqueId();
        if (!this.valueMap.containsKey(uuid)) {
            this.valueMap.put(uuid, string);
            return true;
        }
        String previousValue = this.valueMap.get(uuid);
        if (!previousValue.equals(string)) {
            this.valueMap.put(uuid, string);
            return true;
        }
        return false;
    }

    public void removeViewer(Player viewer) {
        this.valueMap.remove(viewer.getUniqueId());
    }

    public void clear() {
        this.valueMap.clear();
    }

    public String getProcessedText() {
        return this.processedText;
    }

    public String getLatestValue(Player viewer) {
        return this.valueMap.get(viewer.getUniqueId());
    }

    public Entity getOwner() {
        return this.owner;
    }

    public static class ClaimedText {
        private final String placeholder;
        private final Player owner;
        private String latestValue;
        private final boolean relational;

        public ClaimedText(Player owner, String placeholder, boolean relational) {
            this.placeholder = placeholder;
            this.owner = owner;
            this.latestValue = null;
            this.relational = relational;
            this.update();
        }

        public void update() {
            if (this.owner == null) {
                return;
            }
            this.latestValue = PlaceholderAPI.setPlaceholders((Player)this.owner, (String)this.placeholder);
        }

        public String getValue(Player viewer) {
            return Objects.requireNonNullElseGet(this.latestValue, () -> {
                if (this.relational) {
                    return PlaceholderAPI.setRelationalPlaceholders((Player)viewer, (Player)this.owner, (String)this.placeholder);
                }
                return PlaceholderAPI.setPlaceholders((Player)(this.owner == null ? viewer : this.owner), (String)this.placeholder);
            });
        }
    }
}

