/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.nameplate;

import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.util.FontUtils;
import net.momirealms.customnameplates.common.team.TeamColor;

public class Nameplate {
    private String displayName;
    private TeamColor teamColor;
    private String namePrefix;
    private String nameSuffix;
    private ConfiguredChar left;
    private ConfiguredChar middle;
    private ConfiguredChar right;

    private Nameplate() {
    }

    public Nameplate(String displayName, TeamColor teamColor, String namePrefix, String nameSuffix, ConfiguredChar left, ConfiguredChar middle, ConfiguredChar right) {
        this.displayName = displayName;
        this.teamColor = teamColor;
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TeamColor getTeamColor() {
        return this.teamColor;
    }

    public ConfiguredChar getLeft() {
        return this.left;
    }

    public ConfiguredChar getMiddle() {
        return this.middle;
    }

    public ConfiguredChar getRight() {
        return this.right;
    }

    public String getNamePrefix() {
        if (this.teamColor == TeamColor.NONE) {
            return "";
        }
        if (this.teamColor == TeamColor.CUSTOM) {
            return this.namePrefix;
        }
        return "<" + this.teamColor.name() + ">";
    }

    public String getNameSuffix() {
        if (this.teamColor == TeamColor.NONE) {
            return "";
        }
        if (this.teamColor == TeamColor.CUSTOM) {
            return this.nameSuffix;
        }
        return "</" + this.teamColor.name() + ">";
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrefixWithFont(int textWidth) {
        return FontUtils.surroundNameplateFont(this.getPrefix(textWidth));
    }

    public String getPrefix(int textWidth) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<#FEFEFE>");
        stringBuilder.append(OffsetFont.getShortestNegChars(textWidth + this.left.getWidth() + 1));
        stringBuilder.append(this.left.getCharacter());
        stringBuilder.append(OffsetFont.NEG_1.getCharacter());
        int mid_amount = (textWidth + 2) / this.middle.getWidth();
        if (mid_amount != 0) {
            for (int i = 0; i < mid_amount; ++i) {
                stringBuilder.append(this.middle.getCharacter());
                stringBuilder.append(OffsetFont.NEG_1.getCharacter());
            }
            stringBuilder.append(OffsetFont.getShortestNegChars(this.middle.getWidth() - (textWidth + 2) % this.middle.getWidth() + 1));
        }
        stringBuilder.append("</#FEFEFE>");
        stringBuilder.append("<#FDFEFE>");
        stringBuilder.append(this.middle.getCharacter());
        stringBuilder.append(OffsetFont.NEG_1.getCharacter());
        stringBuilder.append(this.right.getCharacter());
        stringBuilder.append(OffsetFont.getShortestNegChars(textWidth + this.right.getWidth() + 1));
        stringBuilder.append("</#FDFEFE>");
        return stringBuilder.toString();
    }

    public String getSuffixWithFont(int textWidth) {
        return FontUtils.surroundNameplateFont(this.getSuffix(textWidth));
    }

    public String getSuffix(int textWidth) {
        return OffsetFont.getShortestNegChars(textWidth + textWidth % 2 + 1);
    }

    public static class Builder {
        private final Nameplate nameplate = new Nameplate();

        public static Builder of() {
            return new Builder();
        }

        public Builder displayName(String display) {
            this.nameplate.displayName = display;
            return this;
        }

        public Builder teamColor(TeamColor teamColor) {
            this.nameplate.teamColor = teamColor;
            return this;
        }

        public Builder namePrefix(String namePrefix) {
            this.nameplate.namePrefix = namePrefix;
            return this;
        }

        public Builder nameSuffix(String nameSuffix) {
            this.nameplate.nameSuffix = nameSuffix;
            return this;
        }

        public Builder left(ConfiguredChar configuredChar) {
            this.nameplate.left = configuredChar;
            return this;
        }

        public Builder middle(ConfiguredChar configuredChar) {
            this.nameplate.middle = configuredChar;
            return this;
        }

        public Builder right(ConfiguredChar configuredChar) {
            this.nameplate.right = configuredChar;
            return this;
        }

        public Nameplate build() {
            return this.nameplate;
        }
    }
}

