/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.util.FontUtils;
import net.momirealms.customnameplates.api.util.LogUtils;
import org.bukkit.OfflinePlayer;

public class VanillaHud {
    private String empty;
    private String half;
    private String full;
    private String maxPapi;
    private String currentPapi;
    private boolean reverse;

    private VanillaHud() {
    }

    public VanillaHud(char empty, char half, char full, String maxPapi, String currentPapi, boolean reverse) {
        this.empty = String.valueOf(empty) + OffsetFont.NEG_2.getCharacter();
        this.half = String.valueOf(half) + OffsetFont.NEG_2.getCharacter();
        this.full = String.valueOf(full) + OffsetFont.NEG_2.getCharacter();
        this.maxPapi = maxPapi;
        this.currentPapi = currentPapi;
        this.reverse = reverse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getValue(OfflinePlayer player) {
        double max;
        double current;
        try {
            current = Double.parseDouble(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.currentPapi));
            max = Double.parseDouble(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.maxPapi));
        }
        catch (NumberFormatException e) {
            current = 1.0;
            max = 1.0;
            LogUtils.warn("Invalid number format when parsing: " + this.currentPapi + "/" + this.maxPapi);
        }
        if (current >= max) {
            current = max;
        }
        if (current < 0.0) {
            current = 0.0;
        }
        int point = (int)(current / max * 20.0);
        int full_amount = point / 2;
        int half_amount = point % 2;
        int empty_amount = 10 - full_amount - half_amount;
        StringBuilder builder = new StringBuilder();
        if (this.reverse) {
            builder.append(String.valueOf(this.empty).repeat(empty_amount)).append(String.valueOf(this.half).repeat(half_amount)).append(String.valueOf(this.full).repeat(full_amount));
        } else {
            builder.append(String.valueOf(this.full).repeat(full_amount)).append(String.valueOf(this.half).repeat(half_amount)).append(String.valueOf(this.empty).repeat(empty_amount));
        }
        return FontUtils.surroundNameplateFont(builder.toString());
    }

    public static class Builder {
        private final VanillaHud hud = new VanillaHud();

        public static Builder of() {
            return new Builder();
        }

        public Builder full(char full) {
            this.hud.full = String.valueOf(full) + OffsetFont.NEG_2.getCharacter();
            return this;
        }

        public Builder half(char half) {
            this.hud.half = String.valueOf(half) + OffsetFont.NEG_2.getCharacter();
            return this;
        }

        public Builder empty(char empty) {
            this.hud.empty = String.valueOf(empty) + OffsetFont.NEG_2.getCharacter();
            return this;
        }

        public Builder reverse(boolean reverse) {
            this.hud.reverse = reverse;
            return this;
        }

        public Builder max(String max) {
            this.hud.maxPapi = max;
            return this;
        }

        public Builder current(String current) {
            this.hud.currentPapi = current;
            return this;
        }

        public VanillaHud build() {
            return this.hud;
        }
    }
}

