/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.tag.unlimited;

import net.momirealms.customnameplates.api.mechanic.tag.unlimited.NearbyRule;

public class StaticTextTagSetting {
    private double verticalOffset;
    private NearbyRule comeRule;
    private NearbyRule leaveRule;
    private String defaultText;
    private String plugin;

    public StaticTextTagSetting(double verticalOffset, NearbyRule comeRule, NearbyRule leaveRule, String defaultText, String plugin) {
        this.verticalOffset = verticalOffset;
        this.comeRule = comeRule;
        this.leaveRule = leaveRule;
        this.defaultText = defaultText;
        this.plugin = plugin;
    }

    private StaticTextTagSetting() {
        this.verticalOffset = 0.0;
        this.comeRule = (player, entity) -> true;
        this.leaveRule = (player, entity) -> true;
        this.defaultText = "";
        this.plugin = "";
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getVerticalOffset() {
        return this.verticalOffset;
    }

    public NearbyRule getComeRule() {
        return this.comeRule;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public NearbyRule getLeaveRule() {
        return this.leaveRule;
    }

    public static class Builder {
        private final StaticTextTagSetting setting = new StaticTextTagSetting();

        public static Builder of() {
            return new Builder();
        }

        public Builder verticalOffset(double verticalOffset) {
            this.setting.verticalOffset = verticalOffset;
            return this;
        }

        public Builder comeRule(NearbyRule rule) {
            this.setting.comeRule = rule;
            return this;
        }

        public Builder leaveRule(NearbyRule rule) {
            this.setting.leaveRule = rule;
            return this;
        }

        public Builder defaultText(String defaultText) {
            this.setting.defaultText = defaultText;
            return this;
        }

        public Builder plugin(String type) {
            this.setting.plugin = type;
            return this;
        }

        public StaticTextTagSetting build() {
            return this.setting;
        }
    }
}

